<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'dd/MM/y',
            'time' => 'HH:mm',
            'datetime' => 'dd/MM/y HH:mm',
        ],
        'medium' => [
            'date' => 'd \'de\' MMM \'de\' y',
            'time' => 'HH:mm:ss',
            'datetime' => 'd \'de\' MMM \'de\' y HH:mm:ss',
        ],
        'long' => [
            'date' => 'd \'de\' MMMM \'de\' y',
            'time' => 'HH:mm:ss z',
            'datetime' => 'd \'de\' MMMM \'de\' y HH:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE, d \'de\' MMMM \'de\' y',
            'time' => 'HH:mm:ss zzzz',
            'datetime' => 'EEEE, d \'de\' MMMM \'de\' y HH:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '¤ #,##0.00',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => 'AM',
    'pmName' => 'PM',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'XXX',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => '.',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => '.',
    ],
    'currencySymbols' => [
        'AUD' => 'AU$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => 'JP¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => '฿',
        'TWD' => 'NT$',
        'USD' => 'US$',
        'VND' => '₫',
        'XAF' => 'FCFA ',
        'XCD' => 'EC$',
        'XOF' => 'CFA ',
        'XPF' => 'CFPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'jan',
            'fev',
            'mar',
            'abr',
            'mai',
            'jun',
            'jul',
            'ago',
            'set',
            'out',
            'nov',
            'dez',
        ],
        'full' => [
            'janeiro',
            'fevereiro',
            'março',
            'abril',
            'maio',
            'junho',
            'julho',
            'agosto',
            'setembro',
            'outubro',
            'novembro',
            'dezembro',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'jan',
            'fev',
            'mar',
            'abr',
            'mai',
            'jun',
            'jul',
            'ago',
            'set',
            'out',
            'nov',
            'dez',
        ],
        'full' => [
            'janeiro',
            'fevereiro',
            'março',
            'abril',
            'maio',
            'junho',
            'julho',
            'agosto',
            'setembro',
            'outubro',
            'novembro',
            'dezembro',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'D',
            'S',
            'T',
            'Q',
            'Q',
            'S',
            'S',
        ],
        'short' => [
            'dom',
            'seg',
            'ter',
            'qua',
            'qui',
            'sex',
            'sáb',
        ],
        'medium' => [
            'dom',
            'seg',
            'ter',
            'qua',
            'qui',
            'sex',
            'sáb',
        ],
        'full' => [
            'domingo',
            'segunda-feira',
            'terça-feira',
            'quarta-feira',
            'quinta-feira',
            'sexta-feira',
            'sábado',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'D',
            'S',
            'T',
            'Q',
            'Q',
            'S',
            'S',
        ],
        'short' => [
            'dom',
            'seg',
            'ter',
            'qua',
            'qui',
            'sex',
            'sáb',
        ],
        'medium' => [
            'dom',
            'seg',
            'ter',
            'qua',
            'qui',
            'sex',
            'sáb',
        ],
        'full' => [
            'domingo',
            'segunda-feira',
            'terça-feira',
            'quarta-feira',
            'quinta-feira',
            'sexta-feira',
            'sábado',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'africâner',
        'af-NA' => 'africâner (Namíbia)',
        'af-ZA' => 'africâner (África do Sul)',
        'agq' => 'aghem',
        'agq-CM' => 'aghem (Camarões)',
        'ak' => 'akan',
        'ak-GH' => 'akan (Gana)',
        'am' => 'amárico',
        'am-ET' => 'amárico (Etiópia)',
        'ar' => 'árabe',
        'ar-001' => 'árabe (Mundo)',
        'ar-AE' => 'árabe (Emirados Árabes Unidos)',
        'ar-BH' => 'árabe (Bahrein)',
        'ar-DJ' => 'árabe (Djibuti)',
        'ar-DZ' => 'árabe (Argélia)',
        'ar-EG' => 'árabe (Egito)',
        'ar-EH' => 'árabe (Saara Ocidental)',
        'ar-ER' => 'árabe (Eritreia)',
        'ar-IL' => 'árabe (Israel)',
        'ar-IQ' => 'árabe (Iraque)',
        'ar-JO' => 'árabe (Jordânia)',
        'ar-KM' => 'árabe (Comores)',
        'ar-KW' => 'árabe (Kuwait)',
        'ar-LB' => 'árabe (Líbano)',
        'ar-LY' => 'árabe (Líbia)',
        'ar-MA' => 'árabe (Marrocos)',
        'ar-MR' => 'árabe (Mauritânia)',
        'ar-OM' => 'árabe (Omã)',
        'ar-PS' => 'árabe (Territórios palestinos)',
        'ar-QA' => 'árabe (Catar)',
        'ar-SA' => 'árabe (Arábia Saudita)',
        'ar-SD' => 'árabe (Sudão)',
        'ar-SO' => 'árabe (Somália)',
        'ar-SS' => 'árabe (Sudão do Sul)',
        'ar-SY' => 'árabe (Síria)',
        'ar-TD' => 'árabe (Chade)',
        'ar-TN' => 'árabe (Tunísia)',
        'ar-YE' => 'árabe (Iêmen)',
        'as' => 'assamês',
        'as-IN' => 'assamês (Índia)',
        'asa' => 'asu',
        'asa-TZ' => 'asu (Tanzânia)',
        'ast' => 'asturiano',
        'ast-ES' => 'asturiano (Espanha)',
        'az' => 'azerbaijano',
        'az-Cyrl' => 'azerbaijano (cirílico)',
        'az-Cyrl-AZ' => 'azerbaijano (cirílico, Azerbaijão)',
        'az-Latn' => 'azerbaijano (latim)',
        'az-Latn-AZ' => 'azerbaijano (latim, Azerbaijão)',
        'bas' => 'basa',
        'bas-CM' => 'basa (Camarões)',
        'be' => 'bielorrusso',
        'be-BY' => 'bielorrusso (Bielorrússia)',
        'bem' => 'bemba',
        'bem-ZM' => 'bemba (Zâmbia)',
        'bez' => 'bena',
        'bez-TZ' => 'bena (Tanzânia)',
        'bg' => 'búlgaro',
        'bg-BG' => 'búlgaro (Bulgária)',
        'bm' => 'bambara',
        'bm-ML' => 'bambara (Mali)',
        'bn' => 'bengali',
        'bn-BD' => 'bengali (Bangladesh)',
        'bn-IN' => 'bengali (Índia)',
        'bo' => 'tibetano',
        'bo-CN' => 'tibetano (China)',
        'bo-IN' => 'tibetano (Índia)',
        'br' => 'bretão',
        'br-FR' => 'bretão (França)',
        'brx' => 'bodo',
        'brx-IN' => 'bodo (Índia)',
        'bs' => 'bósnio',
        'bs-Cyrl' => 'bósnio (cirílico)',
        'bs-Cyrl-BA' => 'bósnio (cirílico, Bósnia e Herzegovina)',
        'bs-Latn' => 'bósnio (latim)',
        'bs-Latn-BA' => 'bósnio (latim, Bósnia e Herzegovina)',
        'ca' => 'catalão',
        'ca-AD' => 'catalão (Andorra)',
        'ca-ES' => 'catalão (Espanha)',
        'ca-FR' => 'catalão (França)',
        'ca-IT' => 'catalão (Itália)',
        'ccp' => 'Chakma',
        'ccp-BD' => 'Chakma (Bangladesh)',
        'ccp-IN' => 'Chakma (Índia)',
        'ce' => 'checheno',
        'ce-RU' => 'checheno (Rússia)',
        'ceb' => 'cebuano',
        'ceb-PH' => 'cebuano (Filipinas)',
        'cgg' => 'chiga',
        'cgg-UG' => 'chiga (Uganda)',
        'chr' => 'cheroqui',
        'chr-US' => 'cheroqui (Estados Unidos)',
        'ckb' => 'curdo central',
        'ckb-IQ' => 'curdo central (Iraque)',
        'ckb-IR' => 'curdo central (Irã)',
        'cs' => 'tcheco',
        'cs-CZ' => 'tcheco (Tchéquia)',
        'cy' => 'galês',
        'cy-GB' => 'galês (Reino Unido)',
        'da' => 'dinamarquês',
        'da-DK' => 'dinamarquês (Dinamarca)',
        'da-GL' => 'dinamarquês (Groenlândia)',
        'dav' => 'taita',
        'dav-KE' => 'taita (Quênia)',
        'de' => 'alemão',
        'de-AT' => 'alemão (Áustria)',
        'de-BE' => 'alemão (Bélgica)',
        'de-CH' => 'alemão (Suíça)',
        'de-DE' => 'alemão (Alemanha)',
        'de-IT' => 'alemão (Itália)',
        'de-LI' => 'alemão (Liechtenstein)',
        'de-LU' => 'alemão (Luxemburgo)',
        'dje' => 'zarma',
        'dje-NE' => 'zarma (Níger)',
        'dsb' => 'baixo sorábio',
        'dsb-DE' => 'baixo sorábio (Alemanha)',
        'dua' => 'duala',
        'dua-CM' => 'duala (Camarões)',
        'dyo' => 'jola-fonyi',
        'dyo-SN' => 'jola-fonyi (Senegal)',
        'dz' => 'dzonga',
        'dz-BT' => 'dzonga (Butão)',
        'ebu' => 'embu',
        'ebu-KE' => 'embu (Quênia)',
        'ee' => 'eve',
        'ee-GH' => 'eve (Gana)',
        'ee-TG' => 'eve (Togo)',
        'el' => 'grego',
        'el-CY' => 'grego (Chipre)',
        'el-GR' => 'grego (Grécia)',
        'en' => 'inglês',
        'en-001' => 'inglês (Mundo)',
        'en-150' => 'inglês (Europa)',
        'en-AE' => 'inglês (Emirados Árabes Unidos)',
        'en-AG' => 'inglês (Antígua e Barbuda)',
        'en-AI' => 'inglês (Anguila)',
        'en-AS' => 'inglês (Samoa Americana)',
        'en-AT' => 'inglês (Áustria)',
        'en-AU' => 'inglês (Austrália)',
        'en-BB' => 'inglês (Barbados)',
        'en-BE' => 'inglês (Bélgica)',
        'en-BI' => 'inglês (Burundi)',
        'en-BM' => 'inglês (Bermudas)',
        'en-BS' => 'inglês (Bahamas)',
        'en-BW' => 'inglês (Botsuana)',
        'en-BZ' => 'inglês (Belize)',
        'en-CA' => 'inglês (Canadá)',
        'en-CC' => 'inglês (Ilhas Cocos [Keeling])',
        'en-CH' => 'inglês (Suíça)',
        'en-CK' => 'inglês (Ilhas Cook)',
        'en-CM' => 'inglês (Camarões)',
        'en-CX' => 'inglês (Ilha Christmas)',
        'en-CY' => 'inglês (Chipre)',
        'en-DE' => 'inglês (Alemanha)',
        'en-DG' => 'inglês (Diego Garcia)',
        'en-DK' => 'inglês (Dinamarca)',
        'en-DM' => 'inglês (Dominica)',
        'en-ER' => 'inglês (Eritreia)',
        'en-FI' => 'inglês (Finlândia)',
        'en-FJ' => 'inglês (Fiji)',
        'en-FK' => 'inglês (Ilhas Malvinas)',
        'en-FM' => 'inglês (Micronésia)',
        'en-GB' => 'inglês (Reino Unido)',
        'en-GD' => 'inglês (Granada)',
        'en-GG' => 'inglês (Guernsey)',
        'en-GH' => 'inglês (Gana)',
        'en-GI' => 'inglês (Gibraltar)',
        'en-GM' => 'inglês (Gâmbia)',
        'en-GU' => 'inglês (Guam)',
        'en-GY' => 'inglês (Guiana)',
        'en-HK' => 'inglês (Hong Kong, RAE da China)',
        'en-IE' => 'inglês (Irlanda)',
        'en-IL' => 'inglês (Israel)',
        'en-IM' => 'inglês (Ilha de Man)',
        'en-IN' => 'inglês (Índia)',
        'en-IO' => 'inglês (Território Britânico do Oceano Índico)',
        'en-JE' => 'inglês (Jersey)',
        'en-JM' => 'inglês (Jamaica)',
        'en-KE' => 'inglês (Quênia)',
        'en-KI' => 'inglês (Quiribati)',
        'en-KN' => 'inglês (São Cristóvão e Névis)',
        'en-KY' => 'inglês (Ilhas Cayman)',
        'en-LC' => 'inglês (Santa Lúcia)',
        'en-LR' => 'inglês (Libéria)',
        'en-LS' => 'inglês (Lesoto)',
        'en-MG' => 'inglês (Madagascar)',
        'en-MH' => 'inglês (Ilhas Marshall)',
        'en-MO' => 'inglês (Macau, RAE da China)',
        'en-MP' => 'inglês (Ilhas Marianas do Norte)',
        'en-MS' => 'inglês (Montserrat)',
        'en-MT' => 'inglês (Malta)',
        'en-MU' => 'inglês (Maurício)',
        'en-MW' => 'inglês (Malaui)',
        'en-MY' => 'inglês (Malásia)',
        'en-NA' => 'inglês (Namíbia)',
        'en-NF' => 'inglês (Ilha Norfolk)',
        'en-NG' => 'inglês (Nigéria)',
        'en-NL' => 'inglês (Países Baixos)',
        'en-NR' => 'inglês (Nauru)',
        'en-NU' => 'inglês (Niue)',
        'en-NZ' => 'inglês (Nova Zelândia)',
        'en-PG' => 'inglês (Papua-Nova Guiné)',
        'en-PH' => 'inglês (Filipinas)',
        'en-PK' => 'inglês (Paquistão)',
        'en-PN' => 'inglês (Ilhas Pitcairn)',
        'en-PR' => 'inglês (Porto Rico)',
        'en-PW' => 'inglês (Palau)',
        'en-RW' => 'inglês (Ruanda)',
        'en-SB' => 'inglês (Ilhas Salomão)',
        'en-SC' => 'inglês (Seicheles)',
        'en-SD' => 'inglês (Sudão)',
        'en-SE' => 'inglês (Suécia)',
        'en-SG' => 'inglês (Singapura)',
        'en-SH' => 'inglês (Santa Helena)',
        'en-SI' => 'inglês (Eslovênia)',
        'en-SL' => 'inglês (Serra Leoa)',
        'en-SS' => 'inglês (Sudão do Sul)',
        'en-SX' => 'inglês (Sint Maarten)',
        'en-SZ' => 'inglês (Suazilândia)',
        'en-TC' => 'inglês (Ilhas Turcas e Caicos)',
        'en-TK' => 'inglês (Tokelau)',
        'en-TO' => 'inglês (Tonga)',
        'en-TT' => 'inglês (Trinidad e Tobago)',
        'en-TV' => 'inglês (Tuvalu)',
        'en-TZ' => 'inglês (Tanzânia)',
        'en-UG' => 'inglês (Uganda)',
        'en-UM' => 'inglês (Ilhas Menores Distantes dos EUA)',
        'en-US' => 'inglês (Estados Unidos)',
        'en-US-POSIX' => 'inglês (Estados Unidos, computador)',
        'en-VC' => 'inglês (São Vicente e Granadinas)',
        'en-VG' => 'inglês (Ilhas Virgens Britânicas)',
        'en-VI' => 'inglês (Ilhas Virgens Americanas)',
        'en-VU' => 'inglês (Vanuatu)',
        'en-WS' => 'inglês (Samoa)',
        'en-ZA' => 'inglês (África do Sul)',
        'en-ZM' => 'inglês (Zâmbia)',
        'en-ZW' => 'inglês (Zimbábue)',
        'eo' => 'esperanto',
        'eo-001' => 'esperanto (Mundo)',
        'es' => 'espanhol',
        'es-419' => 'espanhol (América Latina)',
        'es-AR' => 'espanhol (Argentina)',
        'es-BO' => 'espanhol (Bolívia)',
        'es-BR' => 'espanhol (Brasil)',
        'es-BZ' => 'espanhol (Belize)',
        'es-CL' => 'espanhol (Chile)',
        'es-CO' => 'espanhol (Colômbia)',
        'es-CR' => 'espanhol (Costa Rica)',
        'es-CU' => 'espanhol (Cuba)',
        'es-DO' => 'espanhol (República Dominicana)',
        'es-EA' => 'espanhol (Ceuta e Melilla)',
        'es-EC' => 'espanhol (Equador)',
        'es-ES' => 'espanhol (Espanha)',
        'es-GQ' => 'espanhol (Guiné Equatorial)',
        'es-GT' => 'espanhol (Guatemala)',
        'es-HN' => 'espanhol (Honduras)',
        'es-IC' => 'espanhol (Ilhas Canárias)',
        'es-MX' => 'espanhol (México)',
        'es-NI' => 'espanhol (Nicarágua)',
        'es-PA' => 'espanhol (Panamá)',
        'es-PE' => 'espanhol (Peru)',
        'es-PH' => 'espanhol (Filipinas)',
        'es-PR' => 'espanhol (Porto Rico)',
        'es-PY' => 'espanhol (Paraguai)',
        'es-SV' => 'espanhol (El Salvador)',
        'es-US' => 'espanhol (Estados Unidos)',
        'es-UY' => 'espanhol (Uruguai)',
        'es-VE' => 'espanhol (Venezuela)',
        'et' => 'estoniano',
        'et-EE' => 'estoniano (Estônia)',
        'eu' => 'basco',
        'eu-ES' => 'basco (Espanha)',
        'ewo' => 'ewondo',
        'ewo-CM' => 'ewondo (Camarões)',
        'fa' => 'persa',
        'fa-AF' => 'persa (Afeganistão)',
        'fa-IR' => 'persa (Irã)',
        'ff' => 'fula',
        'ff-Latn' => 'fula (latim)',
        'ff-Latn-BF' => 'fula (latim, Burquina Faso)',
        'ff-Latn-CM' => 'fula (latim, Camarões)',
        'ff-Latn-GH' => 'fula (latim, Gana)',
        'ff-Latn-GM' => 'fula (latim, Gâmbia)',
        'ff-Latn-GN' => 'fula (latim, Guiné)',
        'ff-Latn-GW' => 'fula (latim, Guiné-Bissau)',
        'ff-Latn-LR' => 'fula (latim, Libéria)',
        'ff-Latn-MR' => 'fula (latim, Mauritânia)',
        'ff-Latn-NE' => 'fula (latim, Níger)',
        'ff-Latn-NG' => 'fula (latim, Nigéria)',
        'ff-Latn-SL' => 'fula (latim, Serra Leoa)',
        'ff-Latn-SN' => 'fula (latim, Senegal)',
        'fi' => 'finlandês',
        'fi-FI' => 'finlandês (Finlândia)',
        'fil' => 'filipino',
        'fil-PH' => 'filipino (Filipinas)',
        'fo' => 'feroês',
        'fo-DK' => 'feroês (Dinamarca)',
        'fo-FO' => 'feroês (Ilhas Faroe)',
        'fr' => 'francês',
        'fr-BE' => 'francês (Bélgica)',
        'fr-BF' => 'francês (Burquina Faso)',
        'fr-BI' => 'francês (Burundi)',
        'fr-BJ' => 'francês (Benin)',
        'fr-BL' => 'francês (São Bartolomeu)',
        'fr-CA' => 'francês (Canadá)',
        'fr-CD' => 'francês (Congo - Kinshasa)',
        'fr-CF' => 'francês (República Centro-Africana)',
        'fr-CG' => 'francês (República do Congo)',
        'fr-CH' => 'francês (Suíça)',
        'fr-CI' => 'francês (Costa do Marfim)',
        'fr-CM' => 'francês (Camarões)',
        'fr-DJ' => 'francês (Djibuti)',
        'fr-DZ' => 'francês (Argélia)',
        'fr-FR' => 'francês (França)',
        'fr-GA' => 'francês (Gabão)',
        'fr-GF' => 'francês (Guiana Francesa)',
        'fr-GN' => 'francês (Guiné)',
        'fr-GP' => 'francês (Guadalupe)',
        'fr-GQ' => 'francês (Guiné Equatorial)',
        'fr-HT' => 'francês (Haiti)',
        'fr-KM' => 'francês (Comores)',
        'fr-LU' => 'francês (Luxemburgo)',
        'fr-MA' => 'francês (Marrocos)',
        'fr-MC' => 'francês (Mônaco)',
        'fr-MF' => 'francês (São Martinho)',
        'fr-MG' => 'francês (Madagascar)',
        'fr-ML' => 'francês (Mali)',
        'fr-MQ' => 'francês (Martinica)',
        'fr-MR' => 'francês (Mauritânia)',
        'fr-MU' => 'francês (Maurício)',
        'fr-NC' => 'francês (Nova Caledônia)',
        'fr-NE' => 'francês (Níger)',
        'fr-PF' => 'francês (Polinésia Francesa)',
        'fr-PM' => 'francês (São Pedro e Miquelão)',
        'fr-RE' => 'francês (Reunião)',
        'fr-RW' => 'francês (Ruanda)',
        'fr-SC' => 'francês (Seicheles)',
        'fr-SN' => 'francês (Senegal)',
        'fr-SY' => 'francês (Síria)',
        'fr-TD' => 'francês (Chade)',
        'fr-TG' => 'francês (Togo)',
        'fr-TN' => 'francês (Tunísia)',
        'fr-VU' => 'francês (Vanuatu)',
        'fr-WF' => 'francês (Wallis e Futuna)',
        'fr-YT' => 'francês (Mayotte)',
        'fur' => 'friulano',
        'fur-IT' => 'friulano (Itália)',
        'fy' => 'frísio ocidental',
        'fy-NL' => 'frísio ocidental (Países Baixos)',
        'ga' => 'irlandês',
        'ga-IE' => 'irlandês (Irlanda)',
        'gd' => 'gaélico escocês',
        'gd-GB' => 'gaélico escocês (Reino Unido)',
        'gl' => 'galego',
        'gl-ES' => 'galego (Espanha)',
        'gsw' => 'alemão (Suíça)',
        'gsw-CH' => 'alemão (Suíça) (Suíça)',
        'gsw-FR' => 'alemão (Suíça) (França)',
        'gsw-LI' => 'alemão (Suíça) (Liechtenstein)',
        'gu' => 'guzerate',
        'gu-IN' => 'guzerate (Índia)',
        'guz' => 'gusii',
        'guz-KE' => 'gusii (Quênia)',
        'gv' => 'manx',
        'gv-IM' => 'manx (Ilha de Man)',
        'ha' => 'hauçá',
        'ha-GH' => 'hauçá (Gana)',
        'ha-NE' => 'hauçá (Níger)',
        'ha-NG' => 'hauçá (Nigéria)',
        'haw' => 'havaiano',
        'haw-US' => 'havaiano (Estados Unidos)',
        'he' => 'hebraico',
        'he-IL' => 'hebraico (Israel)',
        'hi' => 'híndi',
        'hi-IN' => 'híndi (Índia)',
        'hr' => 'croata',
        'hr-BA' => 'croata (Bósnia e Herzegovina)',
        'hr-HR' => 'croata (Croácia)',
        'hsb' => 'alto sorábio',
        'hsb-DE' => 'alto sorábio (Alemanha)',
        'hu' => 'húngaro',
        'hu-HU' => 'húngaro (Hungria)',
        'hy' => 'armênio',
        'hy-AM' => 'armênio (Armênia)',
        'ia' => 'interlíngua',
        'ia-001' => 'interlíngua (Mundo)',
        'id' => 'indonésio',
        'id-ID' => 'indonésio (Indonésia)',
        'ig' => 'igbo',
        'ig-NG' => 'igbo (Nigéria)',
        'ii' => 'sichuan yi',
        'ii-CN' => 'sichuan yi (China)',
        'is' => 'islandês',
        'is-IS' => 'islandês (Islândia)',
        'it' => 'italiano',
        'it-CH' => 'italiano (Suíça)',
        'it-IT' => 'italiano (Itália)',
        'it-SM' => 'italiano (San Marino)',
        'it-VA' => 'italiano (Cidade do Vaticano)',
        'ja' => 'japonês',
        'ja-JP' => 'japonês (Japão)',
        'jgo' => 'nguemba',
        'jgo-CM' => 'nguemba (Camarões)',
        'jmc' => 'machame',
        'jmc-TZ' => 'machame (Tanzânia)',
        'jv' => 'javanês',
        'jv-ID' => 'javanês (Indonésia)',
        'ka' => 'georgiano',
        'ka-GE' => 'georgiano (Geórgia)',
        'kab' => 'kabyle',
        'kab-DZ' => 'kabyle (Argélia)',
        'kam' => 'kamba',
        'kam-KE' => 'kamba (Quênia)',
        'kde' => 'maconde',
        'kde-TZ' => 'maconde (Tanzânia)',
        'kea' => 'crioulo cabo-verdiano',
        'kea-CV' => 'crioulo cabo-verdiano (Cabo Verde)',
        'khq' => 'koyra chiini',
        'khq-ML' => 'koyra chiini (Mali)',
        'ki' => 'quicuio',
        'ki-KE' => 'quicuio (Quênia)',
        'kk' => 'cazaque',
        'kk-KZ' => 'cazaque (Cazaquistão)',
        'kkj' => 'kako',
        'kkj-CM' => 'kako (Camarões)',
        'kl' => 'groenlandês',
        'kl-GL' => 'groenlandês (Groenlândia)',
        'kln' => 'kalenjin',
        'kln-KE' => 'kalenjin (Quênia)',
        'km' => 'khmer',
        'km-KH' => 'khmer (Camboja)',
        'kn' => 'canarim',
        'kn-IN' => 'canarim (Índia)',
        'ko' => 'coreano',
        'ko-KP' => 'coreano (Coreia do Norte)',
        'ko-KR' => 'coreano (Coreia do Sul)',
        'kok' => 'concani',
        'kok-IN' => 'concani (Índia)',
        'ks' => 'caxemira',
        'ks-IN' => 'caxemira (Índia)',
        'ksb' => 'shambala',
        'ksb-TZ' => 'shambala (Tanzânia)',
        'ksf' => 'bafia',
        'ksf-CM' => 'bafia (Camarões)',
        'ksh' => 'kölsch',
        'ksh-DE' => 'kölsch (Alemanha)',
        'ku' => 'curdo',
        'ku-TR' => 'curdo (Turquia)',
        'kw' => 'córnico',
        'kw-GB' => 'córnico (Reino Unido)',
        'ky' => 'quirguiz',
        'ky-KG' => 'quirguiz (Quirguistão)',
        'lag' => 'langi',
        'lag-TZ' => 'langi (Tanzânia)',
        'lb' => 'luxemburguês',
        'lb-LU' => 'luxemburguês (Luxemburgo)',
        'lg' => 'luganda',
        'lg-UG' => 'luganda (Uganda)',
        'lkt' => 'lacota',
        'lkt-US' => 'lacota (Estados Unidos)',
        'ln' => 'lingala',
        'ln-AO' => 'lingala (Angola)',
        'ln-CD' => 'lingala (Congo - Kinshasa)',
        'ln-CF' => 'lingala (República Centro-Africana)',
        'ln-CG' => 'lingala (República do Congo)',
        'lo' => 'laosiano',
        'lo-LA' => 'laosiano (Laos)',
        'lrc' => 'luri setentrional',
        'lrc-IQ' => 'luri setentrional (Iraque)',
        'lrc-IR' => 'luri setentrional (Irã)',
        'lt' => 'lituano',
        'lt-LT' => 'lituano (Lituânia)',
        'lu' => 'luba-catanga',
        'lu-CD' => 'luba-catanga (Congo - Kinshasa)',
        'luo' => 'luo',
        'luo-KE' => 'luo (Quênia)',
        'luy' => 'luyia',
        'luy-KE' => 'luyia (Quênia)',
        'lv' => 'letão',
        'lv-LV' => 'letão (Letônia)',
        'mas' => 'massai',
        'mas-KE' => 'massai (Quênia)',
        'mas-TZ' => 'massai (Tanzânia)',
        'mer' => 'meru',
        'mer-KE' => 'meru (Quênia)',
        'mfe' => 'morisyen',
        'mfe-MU' => 'morisyen (Maurício)',
        'mg' => 'malgaxe',
        'mg-MG' => 'malgaxe (Madagascar)',
        'mgh' => 'macua',
        'mgh-MZ' => 'macua (Moçambique)',
        'mgo' => 'meta’',
        'mgo-CM' => 'meta’ (Camarões)',
        'mi' => 'maori',
        'mi-NZ' => 'maori (Nova Zelândia)',
        'mk' => 'macedônio',
        'mk-MK' => 'macedônio (Macedônia do Norte)',
        'ml' => 'malaiala',
        'ml-IN' => 'malaiala (Índia)',
        'mn' => 'mongol',
        'mn-MN' => 'mongol (Mongólia)',
        'mr' => 'marati',
        'mr-IN' => 'marati (Índia)',
        'ms' => 'malaio',
        'ms-BN' => 'malaio (Brunei)',
        'ms-MY' => 'malaio (Malásia)',
        'ms-SG' => 'malaio (Singapura)',
        'mt' => 'maltês',
        'mt-MT' => 'maltês (Malta)',
        'mua' => 'mundang',
        'mua-CM' => 'mundang (Camarões)',
        'my' => 'birmanês',
        'my-MM' => 'birmanês (Mianmar [Birmânia])',
        'mzn' => 'mazandarani',
        'mzn-IR' => 'mazandarani (Irã)',
        'naq' => 'nama',
        'naq-NA' => 'nama (Namíbia)',
        'nb' => 'bokmål norueguês',
        'nb-NO' => 'bokmål norueguês (Noruega)',
        'nb-SJ' => 'bokmål norueguês (Svalbard e Jan Mayen)',
        'nd' => 'ndebele do norte',
        'nd-ZW' => 'ndebele do norte (Zimbábue)',
        'nds' => 'baixo alemão',
        'nds-DE' => 'baixo alemão (Alemanha)',
        'nds-NL' => 'baixo alemão (Países Baixos)',
        'ne' => 'nepalês',
        'ne-IN' => 'nepalês (Índia)',
        'ne-NP' => 'nepalês (Nepal)',
        'nl' => 'holandês',
        'nl-AW' => 'holandês (Aruba)',
        'nl-BE' => 'holandês (Bélgica)',
        'nl-BQ' => 'holandês (Países Baixos Caribenhos)',
        'nl-CW' => 'holandês (Curaçao)',
        'nl-NL' => 'holandês (Países Baixos)',
        'nl-SR' => 'holandês (Suriname)',
        'nl-SX' => 'holandês (Sint Maarten)',
        'nmg' => 'kwasio',
        'nmg-CM' => 'kwasio (Camarões)',
        'nn' => 'nynorsk norueguês',
        'nn-NO' => 'nynorsk norueguês (Noruega)',
        'nnh' => 'ngiemboon',
        'nnh-CM' => 'ngiemboon (Camarões)',
        'nus' => 'nuer',
        'nus-SS' => 'nuer (Sudão do Sul)',
        'nyn' => 'nyankole',
        'nyn-UG' => 'nyankole (Uganda)',
        'om' => 'oromo',
        'om-ET' => 'oromo (Etiópia)',
        'om-KE' => 'oromo (Quênia)',
        'or' => 'oriá',
        'or-IN' => 'oriá (Índia)',
        'os' => 'osseto',
        'os-GE' => 'osseto (Geórgia)',
        'os-RU' => 'osseto (Rússia)',
        'pa' => 'panjabi',
        'pa-Arab' => 'panjabi (árabe)',
        'pa-Arab-PK' => 'panjabi (árabe, Paquistão)',
        'pa-Guru' => 'panjabi (gurmuqui)',
        'pa-Guru-IN' => 'panjabi (gurmuqui, Índia)',
        'pl' => 'polonês',
        'pl-PL' => 'polonês (Polônia)',
        'ps' => 'pashto',
        'ps-AF' => 'pashto (Afeganistão)',
        'ps-PK' => 'pashto (Paquistão)',
        'pt' => 'português',
        'pt-AO' => 'português (Angola)',
        'pt-BR' => 'português (Brasil)',
        'pt-CH' => 'português (Suíça)',
        'pt-CV' => 'português (Cabo Verde)',
        'pt-GQ' => 'português (Guiné Equatorial)',
        'pt-GW' => 'português (Guiné-Bissau)',
        'pt-LU' => 'português (Luxemburgo)',
        'pt-MO' => 'português (Macau, RAE da China)',
        'pt-MZ' => 'português (Moçambique)',
        'pt-PT' => 'português (Portugal)',
        'pt-ST' => 'português (São Tomé e Príncipe)',
        'pt-TL' => 'português (Timor-Leste)',
        'qu' => 'quíchua',
        'qu-BO' => 'quíchua (Bolívia)',
        'qu-EC' => 'quíchua (Equador)',
        'qu-PE' => 'quíchua (Peru)',
        'rm' => 'romanche',
        'rm-CH' => 'romanche (Suíça)',
        'rn' => 'rundi',
        'rn-BI' => 'rundi (Burundi)',
        'ro' => 'romeno',
        'ro-MD' => 'romeno (Moldova)',
        'ro-RO' => 'romeno (Romênia)',
        'rof' => 'rombo',
        'rof-TZ' => 'rombo (Tanzânia)',
        'ru' => 'russo',
        'ru-BY' => 'russo (Bielorrússia)',
        'ru-KG' => 'russo (Quirguistão)',
        'ru-KZ' => 'russo (Cazaquistão)',
        'ru-MD' => 'russo (Moldova)',
        'ru-RU' => 'russo (Rússia)',
        'ru-UA' => 'russo (Ucrânia)',
        'rw' => 'quiniaruanda',
        'rw-RW' => 'quiniaruanda (Ruanda)',
        'rwk' => 'rwa',
        'rwk-TZ' => 'rwa (Tanzânia)',
        'sah' => 'sakha',
        'sah-RU' => 'sakha (Rússia)',
        'saq' => 'samburu',
        'saq-KE' => 'samburu (Quênia)',
        'sbp' => 'sangu',
        'sbp-TZ' => 'sangu (Tanzânia)',
        'sd' => 'sindi',
        'sd-PK' => 'sindi (Paquistão)',
        'se' => 'sami setentrional',
        'se-FI' => 'sami setentrional (Finlândia)',
        'se-NO' => 'sami setentrional (Noruega)',
        'se-SE' => 'sami setentrional (Suécia)',
        'seh' => 'sena',
        'seh-MZ' => 'sena (Moçambique)',
        'ses' => 'koyraboro senni',
        'ses-ML' => 'koyraboro senni (Mali)',
        'sg' => 'sango',
        'sg-CF' => 'sango (República Centro-Africana)',
        'shi' => 'tachelhit',
        'shi-Latn' => 'tachelhit (latim)',
        'shi-Latn-MA' => 'tachelhit (latim, Marrocos)',
        'shi-Tfng' => 'tachelhit (tifinagh)',
        'shi-Tfng-MA' => 'tachelhit (tifinagh, Marrocos)',
        'si' => 'cingalês',
        'si-LK' => 'cingalês (Sri Lanka)',
        'sk' => 'eslovaco',
        'sk-SK' => 'eslovaco (Eslováquia)',
        'sl' => 'esloveno',
        'sl-SI' => 'esloveno (Eslovênia)',
        'smn' => 'sami de Inari',
        'smn-FI' => 'sami de Inari (Finlândia)',
        'sn' => 'xona',
        'sn-ZW' => 'xona (Zimbábue)',
        'so' => 'somali',
        'so-DJ' => 'somali (Djibuti)',
        'so-ET' => 'somali (Etiópia)',
        'so-KE' => 'somali (Quênia)',
        'so-SO' => 'somali (Somália)',
        'sq' => 'albanês',
        'sq-AL' => 'albanês (Albânia)',
        'sq-MK' => 'albanês (Macedônia do Norte)',
        'sq-XK' => 'albanês (Kosovo)',
        'sr' => 'sérvio',
        'sr-Cyrl' => 'sérvio (cirílico)',
        'sr-Cyrl-BA' => 'sérvio (cirílico, Bósnia e Herzegovina)',
        'sr-Cyrl-ME' => 'sérvio (cirílico, Montenegro)',
        'sr-Cyrl-RS' => 'sérvio (cirílico, Sérvia)',
        'sr-Cyrl-XK' => 'sérvio (cirílico, Kosovo)',
        'sr-Latn' => 'sérvio (latim)',
        'sr-Latn-BA' => 'sérvio (latim, Bósnia e Herzegovina)',
        'sr-Latn-ME' => 'sérvio (latim, Montenegro)',
        'sr-Latn-RS' => 'sérvio (latim, Sérvia)',
        'sr-Latn-XK' => 'sérvio (latim, Kosovo)',
        'sv' => 'sueco',
        'sv-AX' => 'sueco (Ilhas Aland)',
        'sv-FI' => 'sueco (Finlândia)',
        'sv-SE' => 'sueco (Suécia)',
        'sw' => 'suaíli',
        'sw-CD' => 'suaíli (Congo - Kinshasa)',
        'sw-KE' => 'suaíli (Quênia)',
        'sw-TZ' => 'suaíli (Tanzânia)',
        'sw-UG' => 'suaíli (Uganda)',
        'ta' => 'tâmil',
        'ta-IN' => 'tâmil (Índia)',
        'ta-LK' => 'tâmil (Sri Lanka)',
        'ta-MY' => 'tâmil (Malásia)',
        'ta-SG' => 'tâmil (Singapura)',
        'te' => 'télugo',
        'te-IN' => 'télugo (Índia)',
        'teo' => 'teso',
        'teo-KE' => 'teso (Quênia)',
        'teo-UG' => 'teso (Uganda)',
        'tg' => 'tadjique',
        'tg-TJ' => 'tadjique (Tadjiquistão)',
        'th' => 'tailandês',
        'th-TH' => 'tailandês (Tailândia)',
        'ti' => 'tigrínia',
        'ti-ER' => 'tigrínia (Eritreia)',
        'ti-ET' => 'tigrínia (Etiópia)',
        'tk' => 'turcomeno',
        'tk-TM' => 'turcomeno (Turcomenistão)',
        'to' => 'tonganês',
        'to-TO' => 'tonganês (Tonga)',
        'tr' => 'turco',
        'tr-CY' => 'turco (Chipre)',
        'tr-TR' => 'turco (Turquia)',
        'tt' => 'tártaro',
        'tt-RU' => 'tártaro (Rússia)',
        'twq' => 'tasawaq',
        'twq-NE' => 'tasawaq (Níger)',
        'tzm' => 'tamazirte do Atlas Central',
        'tzm-MA' => 'tamazirte do Atlas Central (Marrocos)',
        'ug' => 'uigur',
        'ug-CN' => 'uigur (China)',
        'uk' => 'ucraniano',
        'uk-UA' => 'ucraniano (Ucrânia)',
        'ur' => 'urdu',
        'ur-IN' => 'urdu (Índia)',
        'ur-PK' => 'urdu (Paquistão)',
        'uz' => 'uzbeque',
        'uz-Arab' => 'uzbeque (árabe)',
        'uz-Arab-AF' => 'uzbeque (árabe, Afeganistão)',
        'uz-Cyrl' => 'uzbeque (cirílico)',
        'uz-Cyrl-UZ' => 'uzbeque (cirílico, Uzbequistão)',
        'uz-Latn' => 'uzbeque (latim)',
        'uz-Latn-UZ' => 'uzbeque (latim, Uzbequistão)',
        'vai' => 'vai',
        'vai-Latn' => 'vai (latim)',
        'vai-Latn-LR' => 'vai (latim, Libéria)',
        'vai-Vaii' => 'vai (vai)',
        'vai-Vaii-LR' => 'vai (vai, Libéria)',
        'vi' => 'vietnamita',
        'vi-VN' => 'vietnamita (Vietnã)',
        'vun' => 'vunjo',
        'vun-TZ' => 'vunjo (Tanzânia)',
        'wae' => 'walser',
        'wae-CH' => 'walser (Suíça)',
        'wo' => 'uolofe',
        'wo-SN' => 'uolofe (Senegal)',
        'xh' => 'xhosa',
        'xh-ZA' => 'xhosa (África do Sul)',
        'xog' => 'lusoga',
        'xog-UG' => 'lusoga (Uganda)',
        'yav' => 'yangben',
        'yav-CM' => 'yangben (Camarões)',
        'yi' => 'iídiche',
        'yi-001' => 'iídiche (Mundo)',
        'yo' => 'iorubá',
        'yo-BJ' => 'iorubá (Benin)',
        'yo-NG' => 'iorubá (Nigéria)',
        'yue' => 'cantonês',
        'yue-Hans' => 'cantonês (simplificado)',
        'yue-Hans-CN' => 'cantonês (simplificado, China)',
        'yue-Hant' => 'cantonês (tradicional)',
        'yue-Hant-HK' => 'cantonês (tradicional, Hong Kong, RAE da China)',
        'zgh' => 'tamazirte marroqino padrão',
        'zgh-MA' => 'tamazirte marroqino padrão (Marrocos)',
        'zh' => 'chinês',
        'zh-Hans' => 'chinês (simplificado)',
        'zh-Hans-CN' => 'chinês (simplificado, China)',
        'zh-Hans-HK' => 'chinês (simplificado, Hong Kong, RAE da China)',
        'zh-Hans-MO' => 'chinês (simplificado, Macau, RAE da China)',
        'zh-Hans-SG' => 'chinês (simplificado, Singapura)',
        'zh-Hant' => 'chinês (tradicional)',
        'zh-Hant-HK' => 'chinês (tradicional, Hong Kong, RAE da China)',
        'zh-Hant-MO' => 'chinês (tradicional, Macau, RAE da China)',
        'zh-Hant-TW' => 'chinês (tradicional, Taiwan)',
        'zu' => 'zulu',
        'zu-ZA' => 'zulu (África do Sul)',
    ],
];
