-- MySQL dump 10.13  Distrib 8.0.33, for Linux (x86_64)
--
-- Host: localhost    Database: addons_craft_demo
-- ------------------------------------------------------
-- Server version	8.0.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `addresses`
--

DROP TABLE IF EXISTS `addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `addresses` (
  `id` int NOT NULL,
  `ownerId` int DEFAULT NULL,
  `countryCode` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `administrativeArea` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `locality` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `dependentLocality` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `postalCode` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `sortingCode` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `addressLine1` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `addressLine2` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `organization` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `organizationTaxId` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `fullName` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `firstName` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `lastName` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `latitude` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `longitude` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_qqktqsukqiiyeixkudtaovpbvbzzwethfvvs` (`ownerId`),
  CONSTRAINT `fk_qqktqsukqiiyeixkudtaovpbvbzzwethfvvs` FOREIGN KEY (`ownerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_rdzpjytvxwmssxwivlonpkwkopzekpnggdel` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `pluginId` int DEFAULT NULL,
  `heading` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `body` text COLLATE utf8mb3_unicode_ci NOT NULL,
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `dateRead` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_azhoblzffxeswoynqryloidnruiddfaonhsy` (`userId`,`unread`,`dateRead`,`dateCreated`),
  KEY `idx_cljdfdozqpvosluaproiujzoiaevquswshxt` (`dateRead`),
  KEY `fk_dyxqmmrmfpvkacjkopsijnsgcgryyvfrubnu` (`pluginId`),
  CONSTRAINT `fk_dyxqmmrmfpvkacjkopsijnsgcgryyvfrubnu` FOREIGN KEY (`pluginId`) REFERENCES `plugins` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_wrorwnaoxjdasajdfzsoyafkumnavuqurxjj` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assetindexdata`
--

DROP TABLE IF EXISTS `assetindexdata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assetindexdata` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sessionId` int NOT NULL,
  `volumeId` int NOT NULL,
  `uri` text COLLATE utf8mb3_unicode_ci,
  `size` bigint unsigned DEFAULT NULL,
  `timestamp` datetime DEFAULT NULL,
  `isDir` tinyint(1) DEFAULT '0',
  `recordId` int DEFAULT NULL,
  `isSkipped` tinyint(1) DEFAULT '0',
  `inProgress` tinyint(1) DEFAULT '0',
  `completed` tinyint(1) DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_sytrumngpguiygburkttdmlomerwtknshtrw` (`volumeId`),
  KEY `idx_yqqfwsbcitxwhfildxqrbsrfduunjphhlcqz` (`volumeId`),
  KEY `fk_jzykzrlqgudaodkzkeityvaqdqofyklqntrk` (`sessionId`),
  CONSTRAINT `fk_bxwkfoyitjzflryeacbczhedpqcgbgsfhwvt` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_jzykzrlqgudaodkzkeityvaqdqofyklqntrk` FOREIGN KEY (`sessionId`) REFERENCES `assetindexingsessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assetindexingsessions`
--

DROP TABLE IF EXISTS `assetindexingsessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assetindexingsessions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `indexedVolumes` text COLLATE utf8mb3_unicode_ci,
  `totalEntries` int DEFAULT NULL,
  `processedEntries` int NOT NULL DEFAULT '0',
  `cacheRemoteImages` tinyint(1) DEFAULT NULL,
  `listEmptyFolders` tinyint(1) DEFAULT '0',
  `isCli` tinyint(1) DEFAULT '0',
  `actionRequired` tinyint(1) DEFAULT '0',
  `processIfRootEmpty` tinyint(1) DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `id` int NOT NULL,
  `volumeId` int DEFAULT NULL,
  `folderId` int NOT NULL,
  `uploaderId` int DEFAULT NULL,
  `filename` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `kind` varchar(50) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'unknown',
  `alt` text COLLATE utf8mb3_unicode_ci,
  `width` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `size` bigint unsigned DEFAULT NULL,
  `focalPoint` varchar(13) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `deletedWithVolume` tinyint(1) DEFAULT NULL,
  `keptFile` tinyint(1) DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_mlzavahknakogvcixiswzheqkxkaokyyqbqe` (`filename`,`folderId`),
  KEY `idx_reluphcwujueozpfiymkjpjehepeueubxefa` (`folderId`),
  KEY `idx_gqwupuydqkeakddltbcbvgbheozjbctczbzh` (`volumeId`),
  KEY `fk_xdcfeqnakwbprkgrgxgbtdfeovqmxmbdfyip` (`uploaderId`),
  CONSTRAINT `fk_rgvyouzktdtmbpsdfwuumbakbixitxwqfyja` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_uydizinkfcwxaqahsqxrhjecftloxufzcbjc` FOREIGN KEY (`folderId`) REFERENCES `volumefolders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vsvbuxgbqmcieidulchhydktuhokdfmbrmeg` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_xdcfeqnakwbprkgrgxgbtdfeovqmxmbdfyip` FOREIGN KEY (`uploaderId`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int NOT NULL,
  `groupId` int NOT NULL,
  `parentId` int DEFAULT NULL,
  `deletedWithGroup` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_giglmfnlshsczixahlncxnyobtpfptqpknlg` (`groupId`),
  KEY `fk_xxducifobixvfqzqgkqvubmkthczumwyfvoo` (`parentId`),
  CONSTRAINT `fk_wwugrjyxydclwqapzpywdugjskkacubwixfw` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_xxducifobixvfqzqgkqvubmkthczumwyfvoo` FOREIGN KEY (`parentId`) REFERENCES `categories` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_ziyoqkxyodfrcbwazwdayjaynvrwbkzkgrcj` FOREIGN KEY (`groupId`) REFERENCES `categorygroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categorygroups`
--

DROP TABLE IF EXISTS `categorygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorygroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `structureId` int NOT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `defaultPlacement` enum('beginning','end') COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'end',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_gmmhzkgpqtbmcfijwbtblgcvmrnenedxegsh` (`name`),
  KEY `idx_nuqkfclfkjrqfydadfgurmumglhxjxvsxenv` (`handle`),
  KEY `idx_eugfbsjyadpockherpkfdrlcjtcttyxguumc` (`structureId`),
  KEY `idx_qluibkvlvccqymuwttutexlhtbhymryzmfof` (`fieldLayoutId`),
  KEY `idx_cvmefbbzuxirrlxnsileaxvejmtnvezpmkyz` (`dateDeleted`),
  CONSTRAINT `fk_kjlekxopwajbjhqkjolljgtctorjtfbqytvw` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_tqkoexkcdqcojjqrhxnlkmjzncucxrybpbth` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categorygroups_sites`
--

DROP TABLE IF EXISTS `categorygroups_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorygroups_sites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `groupId` int NOT NULL,
  `siteId` int NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT '1',
  `uriFormat` text COLLATE utf8mb3_unicode_ci,
  `template` varchar(500) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_rtnawecvxdugnozentlkuvnqfcpuhxjcddfq` (`groupId`,`siteId`),
  KEY `idx_mittdpmnfmmfyldcppbpbzflzwfqwnjzsxuv` (`siteId`),
  CONSTRAINT `fk_ggyjrtdinwfmsxpfvnamuihqkkzutldxmdrs` FOREIGN KEY (`groupId`) REFERENCES `categorygroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_tyajapvzadsznvspapuevblxyeeqrrjjszvw` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `changedattributes`
--

DROP TABLE IF EXISTS `changedattributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `changedattributes` (
  `elementId` int NOT NULL,
  `siteId` int NOT NULL,
  `attribute` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `propagated` tinyint(1) NOT NULL,
  `userId` int DEFAULT NULL,
  PRIMARY KEY (`elementId`,`siteId`,`attribute`),
  KEY `idx_yugbyohrmzwwgrktqvkqsnpvpvseujsqtjje` (`elementId`,`siteId`,`dateUpdated`),
  KEY `fk_zzpwbvahuqpcrbuzxrzskqelhzbahrdzzvcc` (`siteId`),
  KEY `fk_jiiksqpbilagtomgamcxytokhwcrsfrazytd` (`userId`),
  CONSTRAINT `fk_jiiksqpbilagtomgamcxytokhwcrsfrazytd` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_phowfmvtbfdczftkzqevhbhpsunamnwxuwqo` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_zzpwbvahuqpcrbuzxrzskqelhzbahrdzzvcc` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `changedfields`
--

DROP TABLE IF EXISTS `changedfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `changedfields` (
  `elementId` int NOT NULL,
  `siteId` int NOT NULL,
  `fieldId` int NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `propagated` tinyint(1) NOT NULL,
  `userId` int DEFAULT NULL,
  PRIMARY KEY (`elementId`,`siteId`,`fieldId`),
  KEY `idx_qejpmswclefljqatyfbdkwtptuzlcyaoljnx` (`elementId`,`siteId`,`dateUpdated`),
  KEY `fk_pqqjulpurwyybszyunotwcgisrnvxojwoxmf` (`siteId`),
  KEY `fk_dqrnforqnrohafwkwifxrqbpxicnslixrzql` (`fieldId`),
  KEY `fk_kfzafkynpvdjcyocdvyxbbptbwrqnhoovqzc` (`userId`),
  CONSTRAINT `fk_dqrnforqnrohafwkwifxrqbpxicnslixrzql` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_igiuwglsuxpjpnyqtobcmhghwaqcsvlotpoi` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_kfzafkynpvdjcyocdvyxbbptbwrqnhoovqzc` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_pqqjulpurwyybszyunotwcgisrnvxojwoxmf` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `content`
--

DROP TABLE IF EXISTS `content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `content` (
  `id` int NOT NULL AUTO_INCREMENT,
  `elementId` int NOT NULL,
  `siteId` int NOT NULL,
  `title` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  `field_homeTitle_dcwxekih` varchar(600) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `field_price_hedotwnu` int DEFAULT NULL,
  `field_suburb_fixdfhog` text COLLATE utf8mb3_unicode_ci,
  `field_state_nyrarqel` text COLLATE utf8mb3_unicode_ci,
  `field_mainText_idddvzgl` text COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_hnhbeqqxedqwaxcmyapjgnexiurvoaydbfif` (`elementId`,`siteId`),
  KEY `idx_brxzahhjofsclmmhmsujclnkictwyvlrqdzi` (`siteId`),
  KEY `idx_rfgcbeuspduussvrdgrseopywykvnijcnszm` (`title`),
  CONSTRAINT `fk_qjxomvbawfazaoffnuceibuaodrcxplzpsya` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_qlgsivdjleudwwratrlmcvamvxiylotrwdci` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `craftidtokens`
--

DROP TABLE IF EXISTS `craftidtokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `craftidtokens` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `accessToken` text COLLATE utf8mb3_unicode_ci NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_srilbthubixkdbdquguezzfbynvadbinsdhf` (`userId`),
  CONSTRAINT `fk_srilbthubixkdbdquguezzfbynvadbinsdhf` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `deprecationerrors`
--

DROP TABLE IF EXISTS `deprecationerrors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `deprecationerrors` (
  `id` int NOT NULL AUTO_INCREMENT,
  `key` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `fingerprint` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `lastOccurrence` datetime NOT NULL,
  `file` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `line` smallint unsigned DEFAULT NULL,
  `message` text COLLATE utf8mb3_unicode_ci,
  `traces` text COLLATE utf8mb3_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_oeisuimjwlqauejbujzodouanancaclupaon` (`key`,`fingerprint`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `drafts`
--

DROP TABLE IF EXISTS `drafts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `drafts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `canonicalId` int DEFAULT NULL,
  `creatorId` int DEFAULT NULL,
  `provisional` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `notes` text COLLATE utf8mb3_unicode_ci,
  `trackChanges` tinyint(1) NOT NULL DEFAULT '0',
  `dateLastMerged` datetime DEFAULT NULL,
  `saved` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_hnzwbscqlgtlepaaxezettlyhxybwtpllenc` (`creatorId`,`provisional`),
  KEY `idx_vggfxfghjoizusuykkkskvomsznytxiqrjqm` (`saved`),
  KEY `fk_handkcylvnnqcwcuribpljgkstpncnsoumyg` (`canonicalId`),
  CONSTRAINT `fk_handkcylvnnqcwcuribpljgkstpncnsoumyg` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ivkshsxrmpdtrmbmjhqirrcgkjvtxkjruutt` FOREIGN KEY (`creatorId`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements`
--

DROP TABLE IF EXISTS `elements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements` (
  `id` int NOT NULL AUTO_INCREMENT,
  `canonicalId` int DEFAULT NULL,
  `draftId` int DEFAULT NULL,
  `revisionId` int DEFAULT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateLastMerged` datetime DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_arochknmmtbuhnfpcrlvfxgobrcfshweyafl` (`dateDeleted`),
  KEY `idx_brmyycdtxqrqcepazozzrwlhycjjdnjwijet` (`fieldLayoutId`),
  KEY `idx_aecilbclveqeoanosyjjabrtykwacldrvmwd` (`type`),
  KEY `idx_syyhnwfmtnciazkjylhbblkqlhsoytwpcztn` (`enabled`),
  KEY `idx_cxmhwjwhoharfpecifhroatrzgdipxhqebwz` (`archived`,`dateCreated`),
  KEY `idx_inugjhltnzsrcapzyyileqtlpcedumnokcwu` (`archived`,`dateDeleted`,`draftId`,`revisionId`,`canonicalId`),
  KEY `idx_fevmajpegtwjapmifdpkferwlcfrzfmqnomc` (`archived`,`dateDeleted`,`draftId`,`revisionId`,`canonicalId`,`enabled`),
  KEY `fk_qwiflijggjyipyxmsdtpkhkuzkwvbbrfghfr` (`canonicalId`),
  KEY `fk_tuaivxxdpbupcnlfznjgbvmyrpesgzwkeipd` (`draftId`),
  KEY `fk_wkroiydtniahllgzqwpcfcydchxhufmctxji` (`revisionId`),
  CONSTRAINT `fk_pertacqhyniyzaoanegjsozoqpcmunbpwkjz` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_qwiflijggjyipyxmsdtpkhkuzkwvbbrfghfr` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_tuaivxxdpbupcnlfznjgbvmyrpesgzwkeipd` FOREIGN KEY (`draftId`) REFERENCES `drafts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_wkroiydtniahllgzqwpcfcydchxhufmctxji` FOREIGN KEY (`revisionId`) REFERENCES `revisions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_sites`
--

DROP TABLE IF EXISTS `elements_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements_sites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `elementId` int NOT NULL,
  `siteId` int NOT NULL,
  `slug` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `uri` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_mjdfwudurrooewxfokjkhqocfirtpaoxsvhw` (`elementId`,`siteId`),
  KEY `idx_atzwprjelqotksftuxvyjqhsidkeeemkrgdz` (`siteId`),
  KEY `idx_genpukgnmecbidqjoaughqqsuhteprsinvox` (`slug`,`siteId`),
  KEY `idx_opjnnfhljulaqckkhuwlsilegtjshlywzdkg` (`enabled`),
  KEY `idx_fnlvgxfqosbwirghldufahufwkgvuooyzkbj` (`uri`,`siteId`),
  CONSTRAINT `fk_cqyhenxygjfnvjttptryixhlcbrmrpnejhsy` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_qdquhuemmuykroktviuquebkrowmoqfuglxw` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entries`
--

DROP TABLE IF EXISTS `entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `entries` (
  `id` int NOT NULL,
  `sectionId` int NOT NULL,
  `parentId` int DEFAULT NULL,
  `typeId` int NOT NULL,
  `authorId` int DEFAULT NULL,
  `postDate` datetime DEFAULT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `deletedWithEntryType` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_qbtqinvrhlpcpbrzamoegrhywipbegskgght` (`postDate`),
  KEY `idx_beruqeossbxyroipwjbqnzelrqfzauzspgdx` (`expiryDate`),
  KEY `idx_otbrcahlthgvlyixbfyjxfdbrtfxrmxtsaoh` (`authorId`),
  KEY `idx_uibvthwmylpnxysvtbxfllroxijndfmnaozh` (`sectionId`),
  KEY `idx_jgaznqkxubdsmybapvebhokvpcmmosdngvgl` (`typeId`),
  KEY `fk_jshjnvqqkveguvnerutrvxnbeuymrrzrmqfs` (`parentId`),
  CONSTRAINT `fk_dqbkqgoojrzahbdlpzgnhyzgibivybvcqffw` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_fphkamdabzprkywousbntrqxupvtytkldtvg` FOREIGN KEY (`authorId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_gkbfwfvufiqlsloqubmfddsvpcbxiuyytyin` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_jshjnvqqkveguvnerutrvxnbeuymrrzrmqfs` FOREIGN KEY (`parentId`) REFERENCES `entries` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_yhwbmvomzeiyuiqakabtndsqtygggquyyrud` FOREIGN KEY (`typeId`) REFERENCES `entrytypes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entrytypes`
--

DROP TABLE IF EXISTS `entrytypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `entrytypes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sectionId` int NOT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `hasTitleField` tinyint(1) NOT NULL DEFAULT '1',
  `titleTranslationMethod` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'site',
  `titleTranslationKeyFormat` text COLLATE utf8mb3_unicode_ci,
  `titleFormat` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_hetvyusrsktnfwbmbopnjwpvjozltwqjhaac` (`name`,`sectionId`),
  KEY `idx_hgsgttdjgujrrwqjjtpmhisiucitykniqhzp` (`handle`,`sectionId`),
  KEY `idx_vjxdkganepiseswvvbvgfkjdavggjdzipgdb` (`sectionId`),
  KEY `idx_eterttadufemchjoaddatebyqkmlxigierss` (`fieldLayoutId`),
  KEY `idx_fmotfcopthanqalytucsphllgflkodgtwreo` (`dateDeleted`),
  CONSTRAINT `fk_cmwroilycwihirnvfmvlldndzfiogibkhgab` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_nciomgzauimfvsbbkvndwdvfqjyrvyiaudrg` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldgroups`
--

DROP TABLE IF EXISTS `fieldgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fieldgroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_ewaevxhepfrdrumumqqzfamswenbjeftpaje` (`name`),
  KEY `idx_hzfcaqwkcpkreutatsayoqpjowvehemzmuhk` (`dateDeleted`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldlayoutfields`
--

DROP TABLE IF EXISTS `fieldlayoutfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fieldlayoutfields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `layoutId` int NOT NULL,
  `tabId` int NOT NULL,
  `fieldId` int NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ddcjqzquxhiyatqlzoioubdgpirajgztkzkg` (`layoutId`,`fieldId`),
  KEY `idx_wjxgkvkgkquzwuemuasmkkqsziwttsnkrvpv` (`sortOrder`),
  KEY `idx_hcoggpjvcrscfbbkspaczhpiosjwxjojetqk` (`tabId`),
  KEY `idx_kjvlmrheszoujlytsvcdhdwxirdkdmcryftt` (`fieldId`),
  CONSTRAINT `fk_gpywxkdgbfxjwwvtjwregdvxyhssylqplrrl` FOREIGN KEY (`tabId`) REFERENCES `fieldlayouttabs` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_pigdjozdfnasdwrullivkssyuqnakqzylqqu` FOREIGN KEY (`layoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_yrnhwbzpzdshimgcdnolxjduljaylaibbopl` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldlayouts`
--

DROP TABLE IF EXISTS `fieldlayouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fieldlayouts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_zjwudxhatiwpkfzprspmbqhdafoqrnhbsbwu` (`dateDeleted`),
  KEY `idx_usjuwhdrfzoftorezeaefchzetvlvkxcvamj` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldlayouttabs`
--

DROP TABLE IF EXISTS `fieldlayouttabs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fieldlayouttabs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `layoutId` int NOT NULL,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb3_unicode_ci,
  `elements` text COLLATE utf8mb3_unicode_ci,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_gdrmxcqxsvufxvhbliemfzzzywebabratmbs` (`sortOrder`),
  KEY `idx_lhvuqoyngbaidmeasznhdctdmkcwbignqtst` (`layoutId`),
  CONSTRAINT `fk_kabqtmzayycdfwkftdkpwxinqkohxgokxzbc` FOREIGN KEY (`layoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fields`
--

DROP TABLE IF EXISTS `fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `groupId` int DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(64) COLLATE utf8mb3_unicode_ci NOT NULL,
  `context` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'global',
  `columnSuffix` char(8) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `instructions` text COLLATE utf8mb3_unicode_ci,
  `searchable` tinyint(1) NOT NULL DEFAULT '1',
  `translationMethod` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'none',
  `translationKeyFormat` text COLLATE utf8mb3_unicode_ci,
  `type` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb3_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_weiynvuvajzpclmsffvyyldvflgyhmozrval` (`handle`,`context`),
  KEY `idx_onjfagscbgrqqmfnrvjfmgaxfnchpfwczgha` (`groupId`),
  KEY `idx_mmuveptwocauxrlpgexwdnnkxzpzalqxzoyf` (`context`),
  CONSTRAINT `fk_rynnuzbtcdopltgmjrbiphhalmfeqfaxcawn` FOREIGN KEY (`groupId`) REFERENCES `fieldgroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `globalsets`
--

DROP TABLE IF EXISTS `globalsets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `globalsets` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_vmxokclysdoxdyyqjkhbgxwchindpwrnrqys` (`name`),
  KEY `idx_fxkaibnwiyufrwmckqqlrdzbrarwbaqqhiii` (`handle`),
  KEY `idx_fonflghzhofjglfnzzcatzqtbdrwuxxbacds` (`fieldLayoutId`),
  KEY `idx_ftofwnariitebzsjhtyhivzaswbtnzyqjlom` (`sortOrder`),
  CONSTRAINT `fk_regtkjvdgwsypsnaffdzkdlnmfxxpeoibqwa` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_yklbgdotsvxmkrexttraqemivoehofrgzwmo` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqlschemas`
--

DROP TABLE IF EXISTS `gqlschemas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gqlschemas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `scope` text COLLATE utf8mb3_unicode_ci,
  `isPublic` tinyint(1) NOT NULL DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqltokens`
--

DROP TABLE IF EXISTS `gqltokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gqltokens` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `accessToken` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `expiryDate` datetime DEFAULT NULL,
  `lastUsed` datetime DEFAULT NULL,
  `schemaId` int DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_agavwxmtytcdmwnrclzrpcpfixdmomjtatgi` (`accessToken`),
  UNIQUE KEY `idx_tubapjhwvlbrompmgosxnzdmygjinwstgvaa` (`name`),
  KEY `fk_jdoswvljzvztixywydaajgwaqwxqeqczoisi` (`schemaId`),
  CONSTRAINT `fk_jdoswvljzvztixywydaajgwaqwxqeqczoisi` FOREIGN KEY (`schemaId`) REFERENCES `gqlschemas` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `imagetransformindex`
--

DROP TABLE IF EXISTS `imagetransformindex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `imagetransformindex` (
  `id` int NOT NULL AUTO_INCREMENT,
  `assetId` int NOT NULL,
  `transformer` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `filename` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `format` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `transformString` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `fileExists` tinyint(1) NOT NULL DEFAULT '0',
  `inProgress` tinyint(1) NOT NULL DEFAULT '0',
  `error` tinyint(1) NOT NULL DEFAULT '0',
  `dateIndexed` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_vtrdoeporrgeutbyzkfikjulgwqoxanhkfov` (`assetId`,`format`,`transformString`),
  KEY `idx_kqdpnfbqzanooblzkavmieutnrkhvjxtjfdr` (`assetId`,`transformString`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `imagetransforms`
--

DROP TABLE IF EXISTS `imagetransforms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `imagetransforms` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `mode` enum('stretch','fit','crop','letterbox') COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'crop',
  `position` enum('top-left','top-center','top-right','center-left','center-center','center-right','bottom-left','bottom-center','bottom-right') COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'center-center',
  `width` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `format` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `quality` int DEFAULT NULL,
  `interlace` enum('none','line','plane','partition') COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'none',
  `fill` varchar(11) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `upscale` tinyint(1) NOT NULL DEFAULT '1',
  `parameterChangeTime` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_rtxijfyuxcwxhesbwbyobtypixgcvhconoww` (`name`),
  KEY `idx_ujmkuhygritfsqufsbsqotdclfbhgyvagwud` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `info`
--

DROP TABLE IF EXISTS `info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `info` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8mb3_unicode_ci NOT NULL,
  `schemaVersion` varchar(15) COLLATE utf8mb3_unicode_ci NOT NULL,
  `maintenance` tinyint(1) NOT NULL DEFAULT '0',
  `configVersion` char(12) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '000000000000',
  `fieldVersion` char(12) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '000000000000',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `matrixblocks`
--

DROP TABLE IF EXISTS `matrixblocks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `matrixblocks` (
  `id` int NOT NULL,
  `primaryOwnerId` int NOT NULL,
  `fieldId` int NOT NULL,
  `typeId` int NOT NULL,
  `deletedWithOwner` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_rbolckmcclnuojgqvquqvtrnhrnrmckxsnwr` (`primaryOwnerId`),
  KEY `idx_raaeknftqmmzrsdrtauxhgcvqbyjdkvomkgk` (`fieldId`),
  KEY `idx_ctyrdfzsxdyflcakgjaubisrlwoguchjdgsf` (`typeId`),
  CONSTRAINT `fk_calfpcatilayyswhuutevettsfntibitcuij` FOREIGN KEY (`primaryOwnerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_dmlkhixvyzpaadfuesmdlmddesuhihsgjujq` FOREIGN KEY (`typeId`) REFERENCES `matrixblocktypes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_uxwcrgzgosdpdeqsbrtkdtjtofcdwrdtpfur` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_xjsvtcvmbetbkgqolyvqnezkoztolwevzmdv` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `matrixblocks_owners`
--

DROP TABLE IF EXISTS `matrixblocks_owners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `matrixblocks_owners` (
  `blockId` int NOT NULL,
  `ownerId` int NOT NULL,
  `sortOrder` smallint unsigned NOT NULL,
  PRIMARY KEY (`blockId`,`ownerId`),
  KEY `fk_lwiyxjhkyfdivgbhfrqwnmxgejaaelgcrrgb` (`ownerId`),
  CONSTRAINT `fk_gmlqvtxzkotvhdporjokoysxiyiwrtzyhjhn` FOREIGN KEY (`blockId`) REFERENCES `matrixblocks` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_lwiyxjhkyfdivgbhfrqwnmxgejaaelgcrrgb` FOREIGN KEY (`ownerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `matrixblocktypes`
--

DROP TABLE IF EXISTS `matrixblocktypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `matrixblocktypes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fieldId` int NOT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_zucxvebbrnlymgoaaaluhfqgbodhxqrnazaw` (`name`,`fieldId`),
  KEY `idx_zuiikpfxjpftzkgxikawzkhioyxjlhschjqx` (`handle`,`fieldId`),
  KEY `idx_uxilrmjskzxisyjlmgvoconawstxebcgkcjz` (`fieldId`),
  KEY `idx_gedkyybmgrhjzfmtpwbvqfuahtchlnpopykc` (`fieldLayoutId`),
  CONSTRAINT `fk_eisbcixofwdgwhucrxzdrfqmcodgpmpzlupn` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_wnsblabyjmymyyciwwzlgayqoozzfgiagnpk` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `track` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `applyTime` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_wbjwmdnweugoqopeikswlpzwexmeunbglyzk` (`track`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `plugins`
--

DROP TABLE IF EXISTS `plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `plugins` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `version` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `schemaVersion` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `installDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_oiunsonckshmyaliojpwiegiiffeyltjzmvo` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `projectconfig`
--

DROP TABLE IF EXISTS `projectconfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `projectconfig` (
  `path` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue`
--

DROP TABLE IF EXISTS `queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `queue` (
  `id` int NOT NULL AUTO_INCREMENT,
  `channel` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'queue',
  `job` longblob NOT NULL,
  `description` text COLLATE utf8mb3_unicode_ci,
  `timePushed` int NOT NULL,
  `ttr` int NOT NULL,
  `delay` int NOT NULL DEFAULT '0',
  `priority` int unsigned NOT NULL DEFAULT '1024',
  `dateReserved` datetime DEFAULT NULL,
  `timeUpdated` int DEFAULT NULL,
  `progress` smallint NOT NULL DEFAULT '0',
  `progressLabel` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `attempt` int DEFAULT NULL,
  `fail` tinyint(1) DEFAULT '0',
  `dateFailed` datetime DEFAULT NULL,
  `error` text COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_rrhcnmzqavbccfmutvcxzdncxmylfpqknvfj` (`channel`,`fail`,`timeUpdated`,`timePushed`),
  KEY `idx_koqbhzaqcecanwyvtpsuwprgtrpsbbdutejn` (`channel`,`fail`,`timeUpdated`,`delay`)
) ENGINE=InnoDB AUTO_INCREMENT=207 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `relations`
--

DROP TABLE IF EXISTS `relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `relations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fieldId` int NOT NULL,
  `sourceId` int NOT NULL,
  `sourceSiteId` int DEFAULT NULL,
  `targetId` int NOT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ljaqvrtvausknmgzdqasbuzrjxctsywydnxs` (`fieldId`,`sourceId`,`sourceSiteId`,`targetId`),
  KEY `idx_jnzjblmyuzgxumwszhpsgafaxwzuexyhqwcb` (`sourceId`),
  KEY `idx_vpgoinoauzvnryrbbyvdjsfivapldnqkasif` (`targetId`),
  KEY `idx_elshgiflyqfnnlbamkiowkbapjeejzyfzudx` (`sourceSiteId`),
  CONSTRAINT `fk_gextarjnyackprnurypqpyaxgsdokfmqxxxs` FOREIGN KEY (`sourceSiteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_lrijupvxknvfnpefhaaiembsqyizmcaxfjpm` FOREIGN KEY (`sourceId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vsfbhfoumjzzqukakmmumfrtlfsilwhoxhgb` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `resourcepaths`
--

DROP TABLE IF EXISTS `resourcepaths`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `resourcepaths` (
  `hash` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `canonicalId` int NOT NULL,
  `creatorId` int DEFAULT NULL,
  `num` int NOT NULL,
  `notes` text COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ffeucssmruihgjxjgqpwujvflmwefsszwjhl` (`canonicalId`,`num`),
  KEY `fk_ppqiwmhpwtqsnwlywzfuwctoqzoqrpqswxhn` (`creatorId`),
  CONSTRAINT `fk_ocsikcxiqnzprwlbzocgvvaceibvodmmgnur` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ppqiwmhpwtqsnwlywzfuwctoqzoqrpqswxhn` FOREIGN KEY (`creatorId`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindex`
--

DROP TABLE IF EXISTS `searchindex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `searchindex` (
  `elementId` int NOT NULL,
  `attribute` varchar(25) COLLATE utf8mb3_unicode_ci NOT NULL,
  `fieldId` int NOT NULL,
  `siteId` int NOT NULL,
  `keywords` text COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`elementId`,`attribute`,`fieldId`,`siteId`),
  FULLTEXT KEY `idx_ljvgphnuspixqwphlemjfvctelplohnwgfyr` (`keywords`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections`
--

DROP TABLE IF EXISTS `sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections` (
  `id` int NOT NULL AUTO_INCREMENT,
  `structureId` int DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `type` enum('single','channel','structure') COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'channel',
  `enableVersioning` tinyint(1) NOT NULL DEFAULT '0',
  `propagationMethod` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'all',
  `defaultPlacement` enum('beginning','end') COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'end',
  `previewTargets` text COLLATE utf8mb3_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_ddghbiknmoltveabnrlvgrvukystwdukqnco` (`handle`),
  KEY `idx_dosgmggsyamqwtsmvpvkgrtkxjbohhkkwzah` (`name`),
  KEY `idx_efwlzxjffpebhqpqrlhlgykclljdexwcdimc` (`structureId`),
  KEY `idx_idnbuovguutcguvvyldsmsnqoqosqszgcxhg` (`dateDeleted`),
  CONSTRAINT `fk_pttwxsthleaefpqnaijfjqlrkeqhldnatksz` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections_sites`
--

DROP TABLE IF EXISTS `sections_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections_sites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sectionId` int NOT NULL,
  `siteId` int NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT '1',
  `uriFormat` text COLLATE utf8mb3_unicode_ci,
  `template` varchar(500) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `enabledByDefault` tinyint(1) NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_psjrturjhumdjehhgdiswwfvqtjodsgubbkb` (`sectionId`,`siteId`),
  KEY `idx_hnmmlddybpnjtkdfessruebovwukfhjcvynt` (`siteId`),
  CONSTRAINT `fk_pmvpgqkuxjtnrsotazjydhtcfsikbodbvigs` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ybfqscideetktabzcamkurxyvfqxohzamewk` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequences`
--

DROP TABLE IF EXISTS `sequences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequences` (
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `next` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `token` char(100) COLLATE utf8mb3_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_ugdqqqzmjqsmvdjsenqwsgkmyfibdcandlgr` (`uid`),
  KEY `idx_ycguxuotlvpcnxnwpsbiijrihqvahdgdoztt` (`token`),
  KEY `idx_vdneszdjsyjemcmbmpybvlavwcjcqhpwwspc` (`dateUpdated`),
  KEY `idx_oodwaceumkqllwizttqsopvuxliqazujpran` (`userId`),
  CONSTRAINT `fk_dcakzrxinhtmgquhiqmyrhdhnivsgxafihxz` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `shunnedmessages`
--

DROP TABLE IF EXISTS `shunnedmessages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shunnedmessages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `message` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_cccxkimzgividynrjkdxehvwametsfvukfhr` (`userId`,`message`),
  CONSTRAINT `fk_lfwbnkitoywuyqpuyowblzywlybqxuighqaa` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sitegroups`
--

DROP TABLE IF EXISTS `sitegroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sitegroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_qckpncttswntywurcrlksvfkuxjtxrolcwae` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sites`
--

DROP TABLE IF EXISTS `sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `groupId` int NOT NULL,
  `primary` tinyint(1) NOT NULL,
  `enabled` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'true',
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `language` varchar(12) COLLATE utf8mb3_unicode_ci NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT '0',
  `baseUrl` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_lrwecnuqhrnlikushqaupudmalqqqjgddgja` (`dateDeleted`),
  KEY `idx_tizhembhtxxkqupttfwotdcnxcwmtgawjsvk` (`handle`),
  KEY `idx_qmajkdhebohjgqitcppyevchovaxookbnvcy` (`sortOrder`),
  KEY `fk_ujqrorpcnivjgjfxfhwqoezkxixlrqkgciea` (`groupId`),
  CONSTRAINT `fk_ujqrorpcnivjgjfxfhwqoezkxixlrqkgciea` FOREIGN KEY (`groupId`) REFERENCES `sitegroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `structureelements`
--

DROP TABLE IF EXISTS `structureelements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `structureelements` (
  `id` int NOT NULL AUTO_INCREMENT,
  `structureId` int NOT NULL,
  `elementId` int DEFAULT NULL,
  `root` int unsigned DEFAULT NULL,
  `lft` int unsigned NOT NULL,
  `rgt` int unsigned NOT NULL,
  `level` smallint unsigned NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_wtksfyrfgkjusscwspqhvpciaqqgykktyocf` (`structureId`,`elementId`),
  KEY `idx_rdwdrokyyxsxiwrweuihexiaqlevvgnijmex` (`root`),
  KEY `idx_zwylzilewxalcszumyicmglmweaimmimhprv` (`lft`),
  KEY `idx_sfxzzxuuuvxlqkxonilqxbebsjstvkcztjia` (`rgt`),
  KEY `idx_tesjyjbqiiwpwyqvxotzbmawydinlvxsncpb` (`level`),
  KEY `idx_ymmyytklyaccihpqbfdlsslsnmfujwwqjpha` (`elementId`),
  CONSTRAINT `fk_mfbovemgmgndqqjzjvfydyehkwfhhbpghply` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `structures`
--

DROP TABLE IF EXISTS `structures`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `structures` (
  `id` int NOT NULL AUTO_INCREMENT,
  `maxLevels` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_onedgilfcetwimxcdmytjsgvwvmjpcwotxwg` (`dateDeleted`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `systemmessages`
--

DROP TABLE IF EXISTS `systemmessages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `systemmessages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `language` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `key` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `subject` text COLLATE utf8mb3_unicode_ci NOT NULL,
  `body` text COLLATE utf8mb3_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_skpquhfyqgigdevukdspcbeetukdeavwitbh` (`key`,`language`),
  KEY `idx_mupsnoqrvhrezjrmadiaffrbydjdoduokyqu` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `taggroups`
--

DROP TABLE IF EXISTS `taggroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `taggroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_caznrrhoinikmlkyguhncjfpkloroavxaaln` (`name`),
  KEY `idx_ukyjjcclszpdksawmtioswtrsrgdjenmlenf` (`handle`),
  KEY `idx_nsvzruqqkksoqmgtegomslsbaqegumbrffyp` (`dateDeleted`),
  KEY `fk_ijclbbqkitxpfjcblohhflkqjqeopfwdheao` (`fieldLayoutId`),
  CONSTRAINT `fk_ijclbbqkitxpfjcblohhflkqjqeopfwdheao` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` int NOT NULL,
  `groupId` int NOT NULL,
  `deletedWithGroup` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_qsjqvnjlvvccesfcgbvisxwiyiditclrregq` (`groupId`),
  CONSTRAINT `fk_kghsyypwlvipieavjjhpfsuijjtdnmtfpqtv` FOREIGN KEY (`groupId`) REFERENCES `taggroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_muidtjgqddowotdiaqvsndiqqpvtfohdqsjp` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tokens`
--

DROP TABLE IF EXISTS `tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tokens` (
  `id` int NOT NULL AUTO_INCREMENT,
  `token` char(32) COLLATE utf8mb3_unicode_ci NOT NULL,
  `route` text COLLATE utf8mb3_unicode_ci,
  `usageLimit` tinyint unsigned DEFAULT NULL,
  `usageCount` tinyint unsigned DEFAULT NULL,
  `expiryDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_lbjrskeghaekqgghoklasqfhsmjnypkufmzt` (`token`),
  KEY `idx_nlmahlrwwoxcyndmxutqzvvrudkeylrupddw` (`expiryDate`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usergroups`
--

DROP TABLE IF EXISTS `usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `usergroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb3_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_povxhqsihkqlqijmcktfdkkvhziomhsjewdf` (`handle`),
  KEY `idx_sbxgzpydigjligxhqcilvvvwjupwgafvktev` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usergroups_users`
--

DROP TABLE IF EXISTS `usergroups_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `usergroups_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `groupId` int NOT NULL,
  `userId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_elmuwtantlmzhkpqxaxdsihehjzarfnbjcze` (`groupId`,`userId`),
  KEY `idx_olkkatvfuwhcbculyqlfeghpcczpofhvtrim` (`userId`),
  CONSTRAINT `fk_jhyzpmswcchjrkrkdgslwdxrhtczuobgcemu` FOREIGN KEY (`groupId`) REFERENCES `usergroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_wjlwylcfuajevaqvmezeoscgnkaszuiswcqj` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions`
--

DROP TABLE IF EXISTS `userpermissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_azpvdmdzleazlxumgvxpzqutisrlbslxskfj` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions_usergroups`
--

DROP TABLE IF EXISTS `userpermissions_usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions_usergroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `permissionId` int NOT NULL,
  `groupId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_nnplyyzzshhaxpznaqxdjdqclowcndvonuan` (`permissionId`,`groupId`),
  KEY `idx_ucpmchqglakxttaxlnldscvqegxrfseupclm` (`groupId`),
  CONSTRAINT `fk_mjpchldajdfpzxdnlpkiwsvfddeqqfqkaygt` FOREIGN KEY (`permissionId`) REFERENCES `userpermissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_uvvyouxxradmhthmdfjxttlunmjhondufaef` FOREIGN KEY (`groupId`) REFERENCES `usergroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions_users`
--

DROP TABLE IF EXISTS `userpermissions_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `permissionId` int NOT NULL,
  `userId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ujumilibxzextzizdshiprswcsdmijkkqzcm` (`permissionId`,`userId`),
  KEY `idx_cxgvrhfsjlfhvmkvhnvswiknkggniakxioup` (`userId`),
  CONSTRAINT `fk_elizkxrbgzotugklbsvntoplsgabfskmvwri` FOREIGN KEY (`permissionId`) REFERENCES `userpermissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_jmqeuhylohgxtwzxfoyhftgvzmnwxivbzzmu` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpreferences`
--

DROP TABLE IF EXISTS `userpreferences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpreferences` (
  `userId` int NOT NULL AUTO_INCREMENT,
  `preferences` text COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`userId`),
  CONSTRAINT `fk_apxtqhjfzfedavjoxvmutneogmfisjkhqxkw` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int NOT NULL,
  `username` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `fullName` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `photoId` int DEFAULT NULL,
  `firstName` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `lastName` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `admin` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `suspended` tinyint(1) NOT NULL DEFAULT '0',
  `pending` tinyint(1) NOT NULL DEFAULT '0',
  `lastLoginDate` datetime DEFAULT NULL,
  `lastLoginAttemptIp` varchar(45) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `invalidLoginWindowStart` datetime DEFAULT NULL,
  `invalidLoginCount` tinyint unsigned DEFAULT NULL,
  `lastInvalidLoginDate` datetime DEFAULT NULL,
  `lockoutDate` datetime DEFAULT NULL,
  `hasDashboard` tinyint(1) NOT NULL DEFAULT '0',
  `verificationCode` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `verificationCodeIssuedDate` datetime DEFAULT NULL,
  `unverifiedEmail` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `passwordResetRequired` tinyint(1) NOT NULL DEFAULT '0',
  `lastPasswordChangeDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_jahboymazqgmhpskuvkiwdtkqqauitemhuyt` (`verificationCode`),
  KEY `idx_dywwgiiexmmmslaqnssjpterhjtzpirtspde` (`email`),
  KEY `idx_yotibqtscgrdqbpvlajhqprldzjvdrxutskj` (`username`),
  KEY `fk_vwnlvwgrjbrxmqivscsdgmheriiuvblydxku` (`photoId`),
  KEY `idx_pgddwepnldijnywiljozbplwullwpsmbarbg` (`active`),
  KEY `idx_csrvlfufhyeueivoswmbhztyoqhdqgavgzfi` (`locked`),
  KEY `idx_xeqkdlevmwrmdnzjpeuybcsewfpqjjjirwke` (`pending`),
  KEY `idx_bkevgxauvwyuasfbffqqxrfowyadeqwaqdbp` (`suspended`),
  CONSTRAINT `fk_ncurkgibbgwfuftxderszvsxjwipmqoqgyit` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vwnlvwgrjbrxmqivscsdgmheriiuvblydxku` FOREIGN KEY (`photoId`) REFERENCES `assets` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `volumefolders`
--

DROP TABLE IF EXISTS `volumefolders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumefolders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `parentId` int DEFAULT NULL,
  `volumeId` int DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_lpcxyazsvzpchiakzxhhswsbchfxjhdcysfx` (`name`,`parentId`,`volumeId`),
  KEY `idx_fspsfokhowozklxocygedqixzlhmkjxgpifg` (`parentId`),
  KEY `idx_tnmninnlgdvqhwzljejciagnhzamvfzkjpex` (`volumeId`),
  CONSTRAINT `fk_eefjgnqskrrriabilgntcdmtfzopigmuiexd` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_qsoxbewqqpsrrszzhnycxpsiwysfulcngyra` FOREIGN KEY (`parentId`) REFERENCES `volumefolders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fieldLayoutId` int DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `fs` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `transformFs` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `transformSubpath` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `titleTranslationMethod` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'site',
  `titleTranslationKeyFormat` text COLLATE utf8mb3_unicode_ci,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_ulglrldqtyxhtdojtudlkpnuncwzisjcwflr` (`name`),
  KEY `idx_yolbduskhlnegorhqxtctydpdfmarvtybfbk` (`handle`),
  KEY `idx_glqsbdkqulvxqwgdltqwpyipuwtyhmtypzxl` (`fieldLayoutId`),
  KEY `idx_jfyggwmjvzebwajwjaesjdfkhxopzckmvmdv` (`dateDeleted`),
  CONSTRAINT `fk_tusfswfmptfaxdczmnjtyzbqzexzuwnmeshd` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `type` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `colspan` tinyint DEFAULT NULL,
  `settings` text COLLATE utf8mb3_unicode_ci,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_tfbvjrjtkmiovyluhkptgvctdttsccdblmaj` (`userId`),
  CONSTRAINT `fk_ljvwxcuuyfkntzdbhlowbrlbmiqxvwsqcxoq` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping routines for database 'addons_craft_demo'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-05-30 11:37:30
-- MySQL dump 10.13  Distrib 8.0.33, for Linux (x86_64)
--
-- Host: localhost    Database: addons_craft_demo
-- ------------------------------------------------------
-- Server version	8.0.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `addresses`
--

LOCK TABLES `addresses` WRITE;
/*!40000 ALTER TABLE `addresses` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `addresses` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assetindexingsessions`
--

LOCK TABLES `assetindexingsessions` WRITE;
/*!40000 ALTER TABLE `assetindexingsessions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `assetindexingsessions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `assets` VALUES (10,1,5,1,'hero_bg_1.jpg','image',NULL,1920,1536,182559,NULL,NULL,NULL,'2023-05-05 15:34:22','2023-05-05 15:34:22','2023-05-05 15:34:22'),(11,1,5,1,'hero_bg_2.jpg','image',NULL,1920,1536,462181,NULL,NULL,NULL,'2023-05-05 15:34:23','2023-05-05 15:34:23','2023-05-05 15:34:23'),(12,1,5,1,'hero_bg_3.jpg','image',NULL,1920,1536,374988,NULL,NULL,NULL,'2023-05-05 15:34:23','2023-05-05 15:34:25','2023-05-05 15:34:25'),(22,1,7,1,'img_1.jpg','image',NULL,500,500,45426,NULL,NULL,NULL,'2023-05-05 16:35:51','2023-05-05 16:35:51','2023-05-05 16:35:51'),(25,1,7,1,'U8142581_1_0.webp','image',NULL,1024,716,108340,NULL,NULL,NULL,'2023-05-06 13:19:17','2023-05-06 13:19:17','2023-05-06 13:19:35'),(35,1,7,1,'jardin-house-1.jpg','image',NULL,1316,1012,188722,NULL,NULL,NULL,'2023-05-07 07:10:08','2023-05-07 07:02:49','2023-05-07 07:10:08'),(37,1,7,1,'2.png','image',NULL,976,593,908512,NULL,NULL,NULL,'2023-05-07 07:05:42','2023-05-07 07:05:42','2023-05-07 07:05:42'),(57,1,8,1,'real-estate-profile.webp','image',NULL,1000,1410,93520,NULL,NULL,NULL,'2023-05-30 03:21:26','2023-05-30 03:21:26','2023-05-30 03:21:26');
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `categories` VALUES (44,1,NULL,NULL,'2023-05-29 14:01:39','2023-05-29 14:01:39'),(48,1,NULL,NULL,'2023-05-29 15:41:01','2023-05-29 15:41:01');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categorygroups`
--

LOCK TABLES `categorygroups` WRITE;
/*!40000 ALTER TABLE `categorygroups` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `categorygroups` VALUES (1,2,5,'Property Type','propertyType','beginning','2023-05-29 13:59:09','2023-05-29 13:59:09',NULL,'9ca8966f-b6f7-4cf9-acf9-401ac6a384d0');
/*!40000 ALTER TABLE `categorygroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categorygroups_sites`
--

LOCK TABLES `categorygroups_sites` WRITE;
/*!40000 ALTER TABLE `categorygroups_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `categorygroups_sites` VALUES (1,1,1,1,'property/index-type/{slug}','property\\index-type','2023-05-29 13:59:09','2023-05-29 15:52:44','85f866f4-debf-4668-95f4-854344ee6801');
/*!40000 ALTER TABLE `categorygroups_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `changedattributes`
--

LOCK TABLES `changedattributes` WRITE;
/*!40000 ALTER TABLE `changedattributes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `changedattributes` VALUES (1,1,'lastPasswordChangeDate','2023-05-04 15:24:44',0,NULL),(1,1,'password','2023-05-04 15:24:44',0,NULL),(18,1,'slug','2023-05-05 16:30:51',0,1),(18,1,'title','2023-05-05 16:30:51',0,1),(18,1,'uri','2023-05-05 16:30:51',0,1),(20,1,'fieldLayoutId','2023-05-05 16:33:26',0,1),(20,1,'typeId','2023-05-05 16:33:26',0,1),(21,1,'enabled','2023-05-06 13:30:19',0,1),(21,1,'slug','2023-05-05 16:35:18',0,1),(21,1,'title','2023-05-06 13:29:56',0,1),(21,1,'uri','2023-05-05 16:35:18',0,1),(24,1,'slug','2023-05-06 13:18:03',0,1),(24,1,'title','2023-05-06 13:18:03',0,1),(24,1,'uri','2023-05-06 13:18:03',0,1),(34,1,'slug','2023-05-07 07:02:22',0,1),(34,1,'title','2023-05-07 07:02:59',0,1),(34,1,'uri','2023-05-07 07:02:22',0,1),(44,1,'slug','2023-05-29 14:01:46',0,1),(44,1,'title','2023-05-29 14:01:46',0,1),(44,1,'uri','2023-05-29 14:01:46',0,1),(48,1,'slug','2023-05-29 15:41:08',0,1),(48,1,'title','2023-05-29 15:41:08',0,1),(48,1,'uri','2023-05-29 15:41:08',0,1),(52,1,'enabled','2023-05-30 03:23:18',0,1);
/*!40000 ALTER TABLE `changedattributes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `changedfields`
--

LOCK TABLES `changedfields` WRITE;
/*!40000 ALTER TABLE `changedfields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `changedfields` VALUES (2,1,1,'2023-05-05 15:34:35',0,1),(2,1,2,'2023-05-05 15:39:30',0,1),(16,1,1,'2023-05-06 03:47:47',0,1),(20,1,2,'2023-05-05 16:33:26',0,1),(21,1,1,'2023-05-05 16:36:09',0,1),(21,1,3,'2023-05-06 13:28:41',0,1),(21,1,4,'2023-05-06 13:28:41',0,1),(21,1,5,'2023-05-06 13:29:56',0,1),(21,1,6,'2023-05-06 13:28:41',0,1),(21,1,7,'2023-05-29 15:42:07',0,1),(24,1,3,'2023-05-06 13:28:41',0,1),(24,1,4,'2023-05-06 13:28:41',0,1),(24,1,5,'2023-05-06 13:28:41',0,1),(24,1,6,'2023-05-06 13:28:41',0,1),(24,1,7,'2023-05-29 15:41:24',0,1),(34,1,3,'2023-05-07 07:05:49',0,1),(34,1,4,'2023-05-07 07:02:25',0,1),(34,1,5,'2023-05-07 07:02:40',0,1),(34,1,6,'2023-05-07 07:02:34',0,1),(34,1,7,'2023-05-29 14:26:07',0,1),(52,1,8,'2023-05-30 03:21:31',0,1),(52,1,9,'2023-05-30 03:21:31',0,1),(53,1,8,'2023-05-30 03:20:21',0,1),(53,1,9,'2023-05-30 03:20:21',0,1),(54,1,8,'2023-05-30 03:20:21',0,1),(54,1,9,'2023-05-30 03:20:21',0,1),(55,1,8,'2023-05-30 03:20:21',0,1),(55,1,9,'2023-05-30 03:20:21',0,1),(62,1,8,'2023-05-30 03:23:33',0,1),(63,1,8,'2023-05-30 03:24:52',0,1),(63,1,9,'2023-05-30 03:24:52',0,1);
/*!40000 ALTER TABLE `changedfields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `content`
--

LOCK TABLES `content` WRITE;
/*!40000 ALTER TABLE `content` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `content` VALUES (1,1,1,NULL,'2023-05-01 08:06:42','2023-05-04 15:24:43','2ad1638d-7aa8-490c-9a01-fe67873c3a50',NULL,NULL,NULL,NULL,NULL),(2,2,1,'Home','2023-05-01 15:38:56','2023-05-29 10:11:01','251769e9-82c9-4930-b043-45d86edc008c','Find Your Dream Home Now! Or Buy a Lower Price with extra info',NULL,NULL,NULL,NULL),(3,3,1,'Home','2023-05-01 15:38:56','2023-05-01 15:38:56','1626f0b9-8b6f-4114-8f31-283d009fd244',NULL,NULL,NULL,NULL,NULL),(4,4,1,'Home','2023-05-01 15:39:06','2023-05-01 15:39:06','9dc08eff-ad80-4fde-b621-0449f282911f',NULL,NULL,NULL,NULL,NULL),(5,5,1,'Home','2023-05-01 15:40:41','2023-05-01 15:40:41','de01993c-c1ef-45c5-a538-6cad6169f304',NULL,NULL,NULL,NULL,NULL),(7,7,1,'Home','2023-05-01 15:40:58','2023-05-01 15:40:58','2e19836f-a046-4867-a431-36287733bec4','Find Your Dream Home Now!',NULL,NULL,NULL,NULL),(9,9,1,'Home','2023-05-05 15:33:02','2023-05-05 15:33:02','089d2e66-613c-45a3-a654-446a71de172b','Find Your Dream Home Now!',NULL,NULL,NULL,NULL),(10,10,1,'Hero bg 1','2023-05-05 15:34:21','2023-05-05 15:34:21','75ab89db-979b-433b-b55e-e6fb85b340aa',NULL,NULL,NULL,NULL,NULL),(11,11,1,'Hero bg 2','2023-05-05 15:34:22','2023-05-05 15:34:22','81093c46-d64b-4726-bc8f-6186228d14ab',NULL,NULL,NULL,NULL,NULL),(12,12,1,'Hero bg 3','2023-05-05 15:34:24','2023-05-05 15:34:24','f38edee7-4bb4-4946-8d1d-917c7d0262af',NULL,NULL,NULL,NULL,NULL),(13,13,1,'Home','2023-05-05 15:34:35','2023-05-05 15:34:35','7e278473-51a3-4d0e-8149-e64de7651685','Find Your Dream Home Now! Or Buy a Lower Price with extra info',NULL,NULL,NULL,NULL),(15,15,1,'Home','2023-05-05 15:39:30','2023-05-05 15:39:30','425f5d0f-3a3b-4cc9-91e1-7c76c0740366','Find Your Dream Home Now! Or Buy a Lower Price with extra info',NULL,NULL,NULL,NULL),(16,16,1,'Home','2023-05-05 15:41:47','2023-05-30 03:21:46','ee5b6eed-4c6e-4081-a177-c6f089d53ddd','Find Your Dream Home Now! Or Buy a Lower Price with extra info hello <b>',NULL,NULL,NULL,NULL),(17,17,1,NULL,'2023-05-05 16:30:12','2023-05-05 16:30:12','bbd070f7-8e82-47d2-8973-2d1cb09574db',NULL,NULL,NULL,NULL,NULL),(18,18,1,'property1','2023-05-05 16:30:43','2023-05-05 16:30:51','f96a2e67-d024-49f7-a36f-4613952861e1',NULL,NULL,NULL,NULL,NULL),(19,19,1,'property1','2023-05-05 16:30:51','2023-05-05 16:30:51','fa7de62e-fafc-4c98-a125-5c662439c7bc',NULL,NULL,NULL,NULL,NULL),(20,20,1,'property1','2023-05-05 16:33:26','2023-05-05 16:33:26','ee8b2473-feda-4e22-8bb4-287c123bb602',NULL,NULL,NULL,NULL,NULL),(21,21,1,'1600 William Street','2023-05-05 16:34:42','2023-05-29 15:42:07','29a4400d-6848-43e4-a857-bd88d7dfe027','Great Home',560,'Dakota','WA',NULL),(22,22,1,'Img 1','2023-05-05 16:35:51','2023-05-05 16:35:51','9609c795-c1f4-4003-af4c-40b6e63f17f3',NULL,NULL,NULL,NULL,NULL),(23,23,1,'1 California, USA','2023-05-06 13:13:47','2023-05-06 13:13:47','7e7514b5-8b02-4a35-a18e-284abfa78858',NULL,560,'Good Place','WA',NULL),(24,24,1,'501 Knights Run','2023-05-06 13:17:53','2023-05-29 15:41:24','fa56049d-6504-4ef7-9714-cea0fe142499',NULL,380,'Harbour Island','FL',NULL),(25,25,1,'501knights-1','2023-05-06 13:19:17','2023-05-06 13:19:35','62f4934d-62b4-4ed2-a6ef-3fc4f0e5ebd7',NULL,NULL,NULL,NULL,NULL),(26,26,1,'501 Knights Run','2023-05-06 13:19:40','2023-05-06 13:19:40','98846cb1-bdf1-46c5-804d-64b3a2f7e9d3',NULL,380,'Harbour Island','FL',NULL),(27,27,1,'1 California, USA','2023-05-06 13:28:03','2023-05-06 13:28:03','c5e3e29a-49e7-473b-b650-553a8652fb2a',NULL,560,'Good Place','WA',NULL),(29,29,1,'1600 William Street','2023-05-06 13:29:56','2023-05-06 13:29:56','9dcdd9c5-9c3a-489c-84e4-ab8cee503e12',NULL,560,'Dakota','WA',NULL),(31,31,1,'1600 William Street','2023-05-06 13:30:08','2023-05-06 13:30:08','e8a70718-07c5-4b14-8e6a-11cc96e59cfb',NULL,560,'Dakota','WA',NULL),(33,33,1,'1600 William Street','2023-05-06 13:30:19','2023-05-06 13:30:19','fbe3cf75-2480-4a98-8240-60405f51cb88',NULL,560,'Dakota','WA',NULL),(34,34,1,'The Jardine Residences','2023-05-07 07:02:11','2023-05-29 14:26:07','7328cf4e-8dce-4a37-8165-fee4a862b41f',NULL,5700,'Seng Kang','Punggol',NULL),(35,35,1,'jardin-house-1','2023-05-07 07:02:48','2023-05-07 07:10:07','52026390-2328-47c4-bf02-834f24616b07',NULL,NULL,NULL,NULL,NULL),(36,36,1,'The Jardine Residences','2023-05-07 07:02:59','2023-05-07 07:02:59','fc46f4bb-26be-4c0d-aac5-a09a851d8844',NULL,5700,'Seng Kang','Punggol',NULL),(37,37,1,'2','2023-05-07 07:05:42','2023-05-07 07:05:42','87655ca9-2fc8-4007-a636-70d593a53b3d',NULL,NULL,NULL,NULL,NULL),(39,39,1,'The Jardine Residences','2023-05-07 07:05:49','2023-05-07 07:05:49','964f69b6-7a03-451d-a704-7baec2066203',NULL,5700,'Seng Kang','Punggol',NULL),(40,40,1,'Home','2023-05-29 10:11:01','2023-05-29 10:11:01','f6e76497-a504-480e-9a69-b64961153a9d','Find Your Dream Home Now! Or Buy a Lower Price with extra info',NULL,NULL,NULL,NULL),(41,41,1,'Home','2023-05-29 10:11:01','2023-05-29 10:11:01','8c82e632-3b53-446e-9d79-c81832e000b7','Find Your Dream Home Now! Or Buy a Lower Price with extra info',NULL,NULL,NULL,NULL),(42,42,1,'Home','2023-05-29 10:11:01','2023-05-29 10:11:01','e3e24233-47b3-4999-ad89-0779538a5302','Find Your Dream Home Now! Or Buy a Lower Price with extra info',NULL,NULL,NULL,NULL),(43,43,1,'Home','2023-05-29 10:11:01','2023-05-29 10:11:01','fdc52ac9-f121-4cbd-8c20-ce7fb76680f4','Find Your Dream Home Now! Or Buy a Lower Price with extra info',NULL,NULL,NULL,NULL),(44,44,1,'Landed','2023-05-29 14:01:39','2023-05-29 14:01:50','b2fb0cbd-e440-495e-b700-02d06ec9fd82',NULL,NULL,NULL,NULL,NULL),(47,47,1,'The Jardine Residences','2023-05-29 14:26:07','2023-05-29 14:26:07','39601fe0-be80-4030-9ec2-19db6e97150f',NULL,5700,'Seng Kang','Punggol',NULL),(48,48,1,'Condo','2023-05-29 15:41:01','2023-05-29 15:41:09','22949863-8d2a-4562-a2f4-0590310be5d3',NULL,NULL,NULL,NULL,NULL),(50,50,1,'501 Knights Run','2023-05-29 15:41:24','2023-05-29 15:41:24','157b30d3-4578-41c7-bcfa-c937f39990d1',NULL,380,'Harbour Island','FL',NULL),(51,51,1,'1600 William Street','2023-05-29 15:42:07','2023-05-29 15:42:07','1085df89-37a5-4f6e-bb58-d984d1ed08d9',NULL,560,'Dakota','WA',NULL),(52,52,1,'About','2023-05-30 03:20:20','2023-05-30 03:23:18','93d82f5d-3498-48d9-a6d5-ba59f03665d8',NULL,NULL,NULL,NULL,'<p>Mr. Real Seller is a highly accomplished real estate agent who has \nmade a name for himself in the industry. His dedication and hard work \nhave paid off, as he has sold $12 million worth of real estate in just \none year. Mr. Real Seller\'s success is a testament to his expertise and \nprofessionalism, and he is a valuable asset to anyone looking to buy or \nsell property. One of the reasons for Mr. Real Seller\'s success is his \nability to navigate the complex and ever-changing real estate market. <br /><br />As\n the industry becomes more competitive, it is increasingly important for\n agents to stay up-to-date on the latest trends and developments. Mr. \nReal Seller has a deep understanding of the market and is able to use \nthis knowledge to help his clients make informed decisions. Whether it\'s\n pricing a property correctly or negotiating a deal, Mr. Real Seller has\n the skills and expertise to get the job done. <br /></p>\n<p>Another factor that sets Mr. Real Seller apart from other agents is \nhis commitment to his clients. He understands that buying or selling a \nproperty can be a stressful and emotional experience, and he works hard \nto make the process as smooth and stress-free as possible. Mr. Real \nSeller takes the time to listen to his clients\' needs and concerns, and \nhe is always available to answer questions or provide guidance. His \ndedication to his clients has earned him a reputation as a trusted and \nreliable agent. </p>\n<p>Despite the challenges facing the real estate industry, Mr. Real \nSeller remains optimistic about the future. He believes that there will \nalways be a need for skilled and knowledgeable agents, and he is \ncommitted to continuing to provide his clients with the highest level of\n service. Whether it\'s helping a first-time homebuyer find their dream \nhome or assisting a seller in getting top dollar for their property, Mr.\n Real Seller is dedicated to helping his clients achieve their real \nestate goals. With his expertise, professionalism, and commitment to his\n clients, it\'s no wonder that Mr. Real Seller has been so successful in \nthe industry.</p>'),(53,53,1,'About','2023-05-30 03:20:20','2023-05-30 03:20:21','3b1cb1bf-2b3d-4571-8355-fbe91984c039',NULL,NULL,NULL,NULL,NULL),(54,54,1,'About','2023-05-30 03:20:20','2023-05-30 03:20:21','1c5abcd8-a571-4613-948b-e02dad0af27d',NULL,NULL,NULL,NULL,NULL),(55,55,1,'About','2023-05-30 03:20:21','2023-05-30 03:20:21','67903b24-91a7-4398-88d8-a7d2207bd707',NULL,NULL,NULL,NULL,NULL),(57,57,1,'Real estate profile','2023-05-30 03:21:26','2023-05-30 03:21:26','bd8f5ba7-b606-477d-a071-dfcd694a2ab1',NULL,NULL,NULL,NULL,NULL),(58,58,1,'About','2023-05-30 03:21:31','2023-05-30 03:21:31','86bba954-400f-4a1f-9db7-b8052cc56598',NULL,NULL,NULL,NULL,'<p>Mr. Real Seller is a highly accomplished real estate agent who has \nmade a name for himself in the industry. His dedication and hard work \nhave paid off, as he has sold $12 million worth of real estate in just \none year. Mr. Real Seller\'s success is a testament to his expertise and \nprofessionalism, and he is a valuable asset to anyone looking to buy or \nsell property. One of the reasons for Mr. Real Seller\'s success is his \nability to navigate the complex and ever-changing real estate market. <br /><br />As\n the industry becomes more competitive, it is increasingly important for\n agents to stay up-to-date on the latest trends and developments. Mr. \nReal Seller has a deep understanding of the market and is able to use \nthis knowledge to help his clients make informed decisions. Whether it\'s\n pricing a property correctly or negotiating a deal, Mr. Real Seller has\n the skills and expertise to get the job done. <br /></p>\n<p>Another factor that sets Mr. Real Seller apart from other agents is \nhis commitment to his clients. He understands that buying or selling a \nproperty can be a stressful and emotional experience, and he works hard \nto make the process as smooth and stress-free as possible. Mr. Real \nSeller takes the time to listen to his clients\' needs and concerns, and \nhe is always available to answer questions or provide guidance. His \ndedication to his clients has earned him a reputation as a trusted and \nreliable agent. </p>\n<p>Despite the challenges facing the real estate industry, Mr. Real \nSeller remains optimistic about the future. He believes that there will \nalways be a need for skilled and knowledgeable agents, and he is \ncommitted to continuing to provide his clients with the highest level of\n service. Whether it\'s helping a first-time homebuyer find their dream \nhome or assisting a seller in getting top dollar for their property, Mr.\n Real Seller is dedicated to helping his clients achieve their real \nestate goals. With his expertise, professionalism, and commitment to his\n clients, it\'s no wonder that Mr. Real Seller has been so successful in \nthe industry.</p>'),(59,59,1,'About','2023-05-30 03:21:43','2023-05-30 03:21:43','df83527c-445a-4bcb-8d52-9485e7bfdeff',NULL,NULL,NULL,NULL,'<p>Mr. Real Seller is a highly accomplished real estate agent who has \nmade a name for himself in the industry. His dedication and hard work \nhave paid off, as he has sold $12 million worth of real estate in just \none year. Mr. Real Seller\'s success is a testament to his expertise and \nprofessionalism, and he is a valuable asset to anyone looking to buy or \nsell property. One of the reasons for Mr. Real Seller\'s success is his \nability to navigate the complex and ever-changing real estate market. <br /><br />As\n the industry becomes more competitive, it is increasingly important for\n agents to stay up-to-date on the latest trends and developments. Mr. \nReal Seller has a deep understanding of the market and is able to use \nthis knowledge to help his clients make informed decisions. Whether it\'s\n pricing a property correctly or negotiating a deal, Mr. Real Seller has\n the skills and expertise to get the job done. <br /></p>\n<p>Another factor that sets Mr. Real Seller apart from other agents is \nhis commitment to his clients. He understands that buying or selling a \nproperty can be a stressful and emotional experience, and he works hard \nto make the process as smooth and stress-free as possible. Mr. Real \nSeller takes the time to listen to his clients\' needs and concerns, and \nhe is always available to answer questions or provide guidance. His \ndedication to his clients has earned him a reputation as a trusted and \nreliable agent. </p>\n<p>Despite the challenges facing the real estate industry, Mr. Real \nSeller remains optimistic about the future. He believes that there will \nalways be a need for skilled and knowledgeable agents, and he is \ncommitted to continuing to provide his clients with the highest level of\n service. Whether it\'s helping a first-time homebuyer find their dream \nhome or assisting a seller in getting top dollar for their property, Mr.\n Real Seller is dedicated to helping his clients achieve their real \nestate goals. With his expertise, professionalism, and commitment to his\n clients, it\'s no wonder that Mr. Real Seller has been so successful in \nthe industry.</p>'),(60,60,1,'About','2023-05-30 03:22:19','2023-05-30 03:22:19','667432ce-c029-4a66-9af9-cdb3c862b35f',NULL,NULL,NULL,NULL,'<p>Mr. Real Seller is a highly accomplished real estate agent who has \nmade a name for himself in the industry. His dedication and hard work \nhave paid off, as he has sold $12 million worth of real estate in just \none year. Mr. Real Seller\'s success is a testament to his expertise and \nprofessionalism, and he is a valuable asset to anyone looking to buy or \nsell property. One of the reasons for Mr. Real Seller\'s success is his \nability to navigate the complex and ever-changing real estate market. <br /><br />As\n the industry becomes more competitive, it is increasingly important for\n agents to stay up-to-date on the latest trends and developments. Mr. \nReal Seller has a deep understanding of the market and is able to use \nthis knowledge to help his clients make informed decisions. Whether it\'s\n pricing a property correctly or negotiating a deal, Mr. Real Seller has\n the skills and expertise to get the job done. <br /></p>\n<p>Another factor that sets Mr. Real Seller apart from other agents is \nhis commitment to his clients. He understands that buying or selling a \nproperty can be a stressful and emotional experience, and he works hard \nto make the process as smooth and stress-free as possible. Mr. Real \nSeller takes the time to listen to his clients\' needs and concerns, and \nhe is always available to answer questions or provide guidance. His \ndedication to his clients has earned him a reputation as a trusted and \nreliable agent. </p>\n<p>Despite the challenges facing the real estate industry, Mr. Real \nSeller remains optimistic about the future. He believes that there will \nalways be a need for skilled and knowledgeable agents, and he is \ncommitted to continuing to provide his clients with the highest level of\n service. Whether it\'s helping a first-time homebuyer find their dream \nhome or assisting a seller in getting top dollar for their property, Mr.\n Real Seller is dedicated to helping his clients achieve their real \nestate goals. With his expertise, professionalism, and commitment to his\n clients, it\'s no wonder that Mr. Real Seller has been so successful in \nthe industry.</p>'),(61,61,1,'About','2023-05-30 03:23:18','2023-05-30 03:23:18','5af006bf-536e-4f78-97df-e0a8710cdca0',NULL,NULL,NULL,NULL,'<p>Mr. Real Seller is a highly accomplished real estate agent who has \nmade a name for himself in the industry. His dedication and hard work \nhave paid off, as he has sold $12 million worth of real estate in just \none year. Mr. Real Seller\'s success is a testament to his expertise and \nprofessionalism, and he is a valuable asset to anyone looking to buy or \nsell property. One of the reasons for Mr. Real Seller\'s success is his \nability to navigate the complex and ever-changing real estate market. <br /><br />As\n the industry becomes more competitive, it is increasingly important for\n agents to stay up-to-date on the latest trends and developments. Mr. \nReal Seller has a deep understanding of the market and is able to use \nthis knowledge to help his clients make informed decisions. Whether it\'s\n pricing a property correctly or negotiating a deal, Mr. Real Seller has\n the skills and expertise to get the job done. <br /></p>\n<p>Another factor that sets Mr. Real Seller apart from other agents is \nhis commitment to his clients. He understands that buying or selling a \nproperty can be a stressful and emotional experience, and he works hard \nto make the process as smooth and stress-free as possible. Mr. Real \nSeller takes the time to listen to his clients\' needs and concerns, and \nhe is always available to answer questions or provide guidance. His \ndedication to his clients has earned him a reputation as a trusted and \nreliable agent. </p>\n<p>Despite the challenges facing the real estate industry, Mr. Real \nSeller remains optimistic about the future. He believes that there will \nalways be a need for skilled and knowledgeable agents, and he is \ncommitted to continuing to provide his clients with the highest level of\n service. Whether it\'s helping a first-time homebuyer find their dream \nhome or assisting a seller in getting top dollar for their property, Mr.\n Real Seller is dedicated to helping his clients achieve their real \nestate goals. With his expertise, professionalism, and commitment to his\n clients, it\'s no wonder that Mr. Real Seller has been so successful in \nthe industry.</p>'),(62,62,1,'About','2023-05-30 03:23:32','2023-05-30 03:23:32','67587a42-8d51-42a2-83f6-3e0ac165ea8e',NULL,NULL,NULL,NULL,'<p>Mr. Real Seller is a highly accomplished real estate agent who has \nmade a name for himself in the industry. His dedication and hard work \nhave paid off, as he has sold $12 million worth of real estate in just \none year. Mr. Real Seller\'s success is a testament to his expertise and \nprofessionalism, and he is a valuable asset to anyone looking to buy or \nsell property. One of the reasons for Mr. Real Seller\'s success is his \nability to navigate the complex and ever-changing real estate market. <br /><br />As\n the industry becomes more competitive, it is increasingly important for\n agents to stay up-to-date on the latest trends and developments. Mr. \nReal Seller has a deep understanding of the market and is able to use \nthis knowledge to help his clients make informed decisions. Whether it\'s\n pricing a property correctly or negotiating a deal, Mr. Real Seller has\n the skills and expertise to get the job done. <br /></p>\n<p>Another factor that sets Mr. Real Seller apart from other agents is \nhis commitment to his clients. He understands that buying or selling a \nproperty can be a stressful and emotional experience, and he works hard \nto make the process as smooth and stress-free as possible. Mr. Real \nSeller takes the time to listen to his clients\' needs and concerns, and \nhe is always available to answer questions or provide guidance. His \ndedication to his clients has earned him a reputation as a trusted and \nreliable agent. </p>\n<p>Despite the challenges facing the real estate industry, Mr. Real \nSeller remains optimistic about the future. He believes that there will \nalways be a need for skilled and knowledgeable agents, and he is \ncommitted to continuing to provide his clients with the highest level of\n service. Whether it\'s helping a first-time homebuyer find their dream \nhome or assisting a seller in getting top dollar for their property, Mr.\n Real Seller is dedicated to helping his clients achieve their real \nestate goals. With his expertise, professionalism, and commitment to his\n clients, it\'s no wonder that Mr. Real Seller has been so successful in \nthe industry.</p>'),(63,63,1,'About','2023-05-30 03:24:20','2023-05-30 03:25:06','324fdd37-6c51-4911-ac2c-6a5d19823a64',NULL,NULL,NULL,NULL,'<p>Mr. Real Seller is a highly accomplished real estate agent who has \nmade a name for himself in the industry. His dedication and hard work \nhave paid off, as he has sold $12 million worth of real estate in just \none year. Mr. Real Seller\'s success is a testament to his expertise and \nprofessionalism, and he is a valuable asset to anyone looking to buy or \nsell property. One of the reasons for Mr. Real Seller\'s success is his \nability to navigate the complex and ever-changing real estate market. <br /><br />As\n the industry becomes more competitive, it is increasingly important for\n agents to stay up-to-date on the latest trends and developments. Mr. \nReal Seller has a deep understanding of the market and is able to use \nthis knowledge to help his clients make informed decisions. Whether it\'s\n pricing a property correctly or negotiating a deal, Mr. Real Seller has\n the skills and expertise to get the job done. <br /></p>\n<p>Another factor that sets Mr. Real Seller apart from other agents is \nhis commitment to his clients. He understands that buying or selling a \nproperty can be a stressful and emotional experience, and he works hard \nto make the process as smooth and stress-free as possible. Mr. Real \nSeller takes the time to listen to his clients\' needs and concerns, and \nhe is always available to answer questions or provide guidance. His \ndedication to his clients has earned him a reputation as a trusted and \nreliable agent. </p>\n<p>Despite the challenges facing the real estate industry, Mr. Real \nSeller remains optimistic about the future. He believes that there will \nalways be a need for skilled and knowledgeable agents, and he is \ncommitted to continuing to provide his clients with the highest level of\n service. Whether it\'s helping a first-time homebuyer find their dream \nhome or assisting a seller in getting top dollar for their property, Mr.\n Real Seller is dedicated to helping his clients achieve their real \nestate goals. With his expertise, professionalism, and commitment to his\n clients, it\'s no wonder that Mr. Real Seller has been so successful in \nthe industry.</p>'),(64,64,1,'About','2023-05-30 03:24:20','2023-05-30 03:24:20','d3a1c589-8cc7-4302-b6a2-776bfe7a41c8',NULL,NULL,NULL,NULL,NULL),(65,65,1,'About','2023-05-30 03:24:20','2023-05-30 03:24:20','c392ac7d-0fba-47da-91bd-40a89eba9367',NULL,NULL,NULL,NULL,NULL),(66,66,1,'About','2023-05-30 03:24:30','2023-05-30 03:24:30','4ddd7651-6c5e-4fe5-9bb7-615c5f1a6215',NULL,NULL,NULL,NULL,NULL),(68,68,1,'About','2023-05-30 03:24:52','2023-05-30 03:24:52','d08473fa-adad-4ba2-822f-093d5de0e03f',NULL,NULL,NULL,NULL,'<p>Mr. Real Seller is a highly accomplished real estate agent who has \nmade a name for himself in the industry. His dedication and hard work \nhave paid off, as he has sold $12 million worth of real estate in just \none year. Mr. Real Seller\'s success is a testament to his expertise and \nprofessionalism, and he is a valuable asset to anyone looking to buy or \nsell property. One of the reasons for Mr. Real Seller\'s success is his \nability to navigate the complex and ever-changing real estate market. <br /><br />As\n the industry becomes more competitive, it is increasingly important for\n agents to stay up-to-date on the latest trends and developments. Mr. \nReal Seller has a deep understanding of the market and is able to use \nthis knowledge to help his clients make informed decisions. Whether it\'s\n pricing a property correctly or negotiating a deal, Mr. Real Seller has\n the skills and expertise to get the job done. <br /></p>\n<p>Another factor that sets Mr. Real Seller apart from other agents is \nhis commitment to his clients. He understands that buying or selling a \nproperty can be a stressful and emotional experience, and he works hard \nto make the process as smooth and stress-free as possible. Mr. Real \nSeller takes the time to listen to his clients\' needs and concerns, and \nhe is always available to answer questions or provide guidance. His \ndedication to his clients has earned him a reputation as a trusted and \nreliable agent. </p>\n<p>Despite the challenges facing the real estate industry, Mr. Real \nSeller remains optimistic about the future. He believes that there will \nalways be a need for skilled and knowledgeable agents, and he is \ncommitted to continuing to provide his clients with the highest level of\n service. Whether it\'s helping a first-time homebuyer find their dream \nhome or assisting a seller in getting top dollar for their property, Mr.\n Real Seller is dedicated to helping his clients achieve their real \nestate goals. With his expertise, professionalism, and commitment to his\n clients, it\'s no wonder that Mr. Real Seller has been so successful in \nthe industry.</p>'),(69,69,1,'About','2023-05-30 03:25:06','2023-05-30 03:25:06','dd089472-76f3-4563-b27a-129b915807e0',NULL,NULL,NULL,NULL,'<p>Mr. Real Seller is a highly accomplished real estate agent who has \nmade a name for himself in the industry. His dedication and hard work \nhave paid off, as he has sold $12 million worth of real estate in just \none year. Mr. Real Seller\'s success is a testament to his expertise and \nprofessionalism, and he is a valuable asset to anyone looking to buy or \nsell property. One of the reasons for Mr. Real Seller\'s success is his \nability to navigate the complex and ever-changing real estate market. <br /><br />As\n the industry becomes more competitive, it is increasingly important for\n agents to stay up-to-date on the latest trends and developments. Mr. \nReal Seller has a deep understanding of the market and is able to use \nthis knowledge to help his clients make informed decisions. Whether it\'s\n pricing a property correctly or negotiating a deal, Mr. Real Seller has\n the skills and expertise to get the job done. <br /></p>\n<p>Another factor that sets Mr. Real Seller apart from other agents is \nhis commitment to his clients. He understands that buying or selling a \nproperty can be a stressful and emotional experience, and he works hard \nto make the process as smooth and stress-free as possible. Mr. Real \nSeller takes the time to listen to his clients\' needs and concerns, and \nhe is always available to answer questions or provide guidance. His \ndedication to his clients has earned him a reputation as a trusted and \nreliable agent. </p>\n<p>Despite the challenges facing the real estate industry, Mr. Real \nSeller remains optimistic about the future. He believes that there will \nalways be a need for skilled and knowledgeable agents, and he is \ncommitted to continuing to provide his clients with the highest level of\n service. Whether it\'s helping a first-time homebuyer find their dream \nhome or assisting a seller in getting top dollar for their property, Mr.\n Real Seller is dedicated to helping his clients achieve their real \nestate goals. With his expertise, professionalism, and commitment to his\n clients, it\'s no wonder that Mr. Real Seller has been so successful in \nthe industry.</p>');
/*!40000 ALTER TABLE `content` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `craftidtokens`
--

LOCK TABLES `craftidtokens` WRITE;
/*!40000 ALTER TABLE `craftidtokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `craftidtokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `deprecationerrors`
--

LOCK TABLES `deprecationerrors` WRITE;
/*!40000 ALTER TABLE `deprecationerrors` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `deprecationerrors` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `drafts`
--

LOCK TABLES `drafts` WRITE;
/*!40000 ALTER TABLE `drafts` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `drafts` VALUES (4,2,1,1,'Draft 1','',1,'2023-05-30 03:21:46',1),(5,NULL,1,0,'First draft',NULL,0,NULL,0),(7,18,1,1,'Draft 1','',1,NULL,1),(21,52,1,1,'Draft 1','',1,NULL,1);
/*!40000 ALTER TABLE `drafts` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements`
--

LOCK TABLES `elements` WRITE;
/*!40000 ALTER TABLE `elements` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements` VALUES (1,NULL,NULL,NULL,NULL,'craft\\elements\\User',1,0,'2023-05-01 08:06:42','2023-05-04 15:24:43',NULL,NULL,'f3e96ac9-8877-4d86-a8db-d2151e25531b'),(2,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2023-05-01 15:38:56','2023-05-29 10:11:01',NULL,NULL,'8ffc4bbb-37f1-4c2f-b28b-8265526b4a2a'),(3,2,NULL,1,1,'craft\\elements\\Entry',1,0,'2023-05-01 15:38:56','2023-05-01 15:38:56',NULL,NULL,'f32ad392-d124-466f-8e7e-3cdb48f88a5f'),(4,2,NULL,2,1,'craft\\elements\\Entry',1,0,'2023-05-01 15:39:06','2023-05-01 15:39:06',NULL,NULL,'6c90c70a-4eba-45aa-8016-562caae22a95'),(5,2,NULL,3,1,'craft\\elements\\Entry',1,0,'2023-05-01 15:40:41','2023-05-01 15:40:41',NULL,NULL,'09d5e3e3-725f-4518-8ef7-4b317cf77a9a'),(7,2,NULL,4,1,'craft\\elements\\Entry',1,0,'2023-05-01 15:40:58','2023-05-01 15:40:58',NULL,NULL,'df68dc91-ef19-42ee-aab8-843f2f056f1d'),(9,2,NULL,5,1,'craft\\elements\\Entry',1,0,'2023-05-05 15:33:02','2023-05-05 15:33:02',NULL,NULL,'642393fc-0698-419e-91ba-c599caa9bf29'),(10,NULL,NULL,NULL,2,'craft\\elements\\Asset',1,0,'2023-05-05 15:34:21','2023-05-05 15:34:21',NULL,NULL,'3a2711a9-39db-4e63-a434-943915b4630c'),(11,NULL,NULL,NULL,2,'craft\\elements\\Asset',1,0,'2023-05-05 15:34:22','2023-05-05 15:34:22',NULL,NULL,'7b99e9e3-98a6-4cdb-8406-ee457496c897'),(12,NULL,NULL,NULL,2,'craft\\elements\\Asset',1,0,'2023-05-05 15:34:24','2023-05-05 15:34:24',NULL,NULL,'c63841f9-d260-435b-8b0a-10eb0c50f823'),(13,2,NULL,6,1,'craft\\elements\\Entry',1,0,'2023-05-05 15:34:35','2023-05-05 15:34:35',NULL,NULL,'c8ebab45-df53-496d-9c02-ce683904ba45'),(15,2,NULL,7,1,'craft\\elements\\Entry',1,0,'2023-05-05 15:39:30','2023-05-05 15:39:30',NULL,NULL,'4f7b8bcf-a4dd-4e1c-afbc-84b60e0eb959'),(16,2,4,NULL,1,'craft\\elements\\Entry',1,0,'2023-05-05 15:41:47','2023-05-30 03:21:46','2023-05-30 03:21:46',NULL,'26222635-429f-4d48-9efd-94ff4e528fc9'),(17,NULL,5,NULL,3,'craft\\elements\\Entry',1,0,'2023-05-05 16:30:12','2023-05-05 16:30:12',NULL,'2023-05-05 16:33:46','8d33b193-e212-49ff-96aa-ecbd0c365d60'),(18,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2023-05-05 16:30:43','2023-05-05 16:30:51',NULL,'2023-05-05 16:33:46','f6013f42-43f1-4a74-a4fa-908b23ce9d59'),(19,18,NULL,8,3,'craft\\elements\\Entry',1,0,'2023-05-05 16:30:51','2023-05-05 16:30:51',NULL,'2023-05-05 16:33:46','8db3a8e7-966f-474f-8f07-9cd55aef0dca'),(20,18,7,NULL,4,'craft\\elements\\Entry',1,0,'2023-05-05 16:33:26','2023-05-05 16:33:26',NULL,'2023-05-05 16:33:46','dd2290c1-55b7-443f-94ad-4ec9aec299b6'),(21,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2023-05-05 16:34:42','2023-05-29 15:42:07',NULL,NULL,'051da313-987d-4aaf-8de4-4431563c4841'),(22,NULL,NULL,NULL,2,'craft\\elements\\Asset',1,0,'2023-05-05 16:35:51','2023-05-05 16:35:51',NULL,NULL,'d01b0c7a-c5cd-48b2-bfca-c0b476c55d19'),(23,21,NULL,9,4,'craft\\elements\\Entry',1,0,'2023-05-06 13:13:47','2023-05-06 13:13:47',NULL,NULL,'8ed87eb5-5c67-49c7-b8d5-f9c10c051e75'),(24,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2023-05-06 13:17:53','2023-05-29 15:41:24',NULL,NULL,'60efcede-4900-4ece-a068-87ee9af11581'),(25,NULL,NULL,NULL,2,'craft\\elements\\Asset',1,0,'2023-05-06 13:19:17','2023-05-06 13:19:35',NULL,NULL,'af8c4872-5037-491f-8c80-8eb7d53ae1ad'),(26,24,NULL,10,4,'craft\\elements\\Entry',1,0,'2023-05-06 13:19:40','2023-05-06 13:19:40',NULL,NULL,'5a3f8687-4a9b-4a50-aaa4-762ab9537685'),(27,21,NULL,11,4,'craft\\elements\\Entry',1,0,'2023-05-06 13:28:03','2023-05-06 13:28:03',NULL,NULL,'60e9f060-4e99-4262-9d35-6e9b9761d718'),(29,21,NULL,12,4,'craft\\elements\\Entry',1,0,'2023-05-06 13:29:56','2023-05-06 13:29:56',NULL,NULL,'6464c35b-768b-4377-ace9-c90402fb2340'),(31,21,NULL,13,4,'craft\\elements\\Entry',0,0,'2023-05-06 13:30:08','2023-05-06 13:30:08',NULL,NULL,'0d1d9ae1-7dc9-42bb-a277-31a48e7d3871'),(33,21,NULL,14,4,'craft\\elements\\Entry',1,0,'2023-05-06 13:30:19','2023-05-06 13:30:19',NULL,NULL,'fc678ee9-4afc-4ca4-be01-893f1d2251c9'),(34,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2023-05-07 07:02:11','2023-05-29 14:26:07',NULL,NULL,'7073e5c9-10bf-4aa8-8f84-e10b461623e2'),(35,NULL,NULL,NULL,2,'craft\\elements\\Asset',1,0,'2023-05-07 07:02:48','2023-05-07 07:10:07',NULL,NULL,'f2c4f0f9-3916-466d-8f37-e643870b17f6'),(36,34,NULL,15,4,'craft\\elements\\Entry',1,0,'2023-05-07 07:02:59','2023-05-07 07:02:59',NULL,NULL,'74a66de5-2136-4c36-98e0-4b03cb847fe6'),(37,NULL,NULL,NULL,2,'craft\\elements\\Asset',1,0,'2023-05-07 07:05:42','2023-05-07 07:05:42',NULL,NULL,'ff2c2f27-0f9c-4b6d-91f3-a210aec234e2'),(39,34,NULL,16,4,'craft\\elements\\Entry',1,0,'2023-05-07 07:05:49','2023-05-07 07:05:49',NULL,NULL,'7b2ab9df-01ca-4255-b1b1-8f0b1b245582'),(40,2,NULL,17,1,'craft\\elements\\Entry',1,0,'2023-05-29 10:11:01','2023-05-29 10:11:01',NULL,NULL,'91bddd87-ccd4-4703-8cd2-e3a9e2f3fdcb'),(41,2,NULL,18,1,'craft\\elements\\Entry',1,0,'2023-05-29 10:11:01','2023-05-29 10:11:01',NULL,NULL,'1560333c-dcab-4e13-89db-051b8972cd7a'),(42,2,NULL,19,1,'craft\\elements\\Entry',1,0,'2023-05-29 10:11:01','2023-05-29 10:11:01',NULL,NULL,'241e78dd-aef7-4b82-8639-8f96b96248f7'),(43,2,NULL,20,1,'craft\\elements\\Entry',1,0,'2023-05-29 10:11:01','2023-05-29 10:11:01',NULL,NULL,'493e80c0-2f83-4b6a-8e8a-53f329ae5e50'),(44,NULL,NULL,NULL,5,'craft\\elements\\Category',1,0,'2023-05-29 14:01:39','2023-05-29 14:01:50',NULL,NULL,'d92f6d16-f467-4a9d-a64f-054ab5348eeb'),(47,34,NULL,21,4,'craft\\elements\\Entry',1,0,'2023-05-29 14:26:07','2023-05-29 14:26:07',NULL,NULL,'1c3b8af3-b70b-4177-8b57-3801f289f3a1'),(48,NULL,NULL,NULL,5,'craft\\elements\\Category',1,0,'2023-05-29 15:41:01','2023-05-29 15:41:09',NULL,NULL,'710bb06f-f024-4950-8b17-b9951e864e2a'),(50,24,NULL,22,4,'craft\\elements\\Entry',1,0,'2023-05-29 15:41:24','2023-05-29 15:41:24',NULL,NULL,'bb88df37-f61f-498d-8d51-9f66701cabe7'),(51,21,NULL,23,4,'craft\\elements\\Entry',1,0,'2023-05-29 15:42:07','2023-05-29 15:42:07',NULL,NULL,'d28f374d-1ac8-4564-b977-cd62a9d427e8'),(52,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2023-05-30 03:20:20','2023-05-30 03:23:18',NULL,'2023-05-30 03:24:00','2b5d0ab7-fbab-4a5b-b184-17e7eb9f3c97'),(53,52,NULL,24,6,'craft\\elements\\Entry',1,0,'2023-05-30 03:20:20','2023-05-30 03:20:20',NULL,NULL,'f94ffea8-0a15-4876-9a74-31564dda2ec6'),(54,52,NULL,25,6,'craft\\elements\\Entry',1,0,'2023-05-30 03:20:20','2023-05-30 03:20:20',NULL,NULL,'8a15cb16-7518-411d-b62d-c3f19d0485b8'),(55,52,NULL,26,6,'craft\\elements\\Entry',1,0,'2023-05-30 03:20:21','2023-05-30 03:20:21',NULL,NULL,'6d7a862c-c39d-4f44-9b24-24ef4e5cc9de'),(57,NULL,NULL,NULL,2,'craft\\elements\\Asset',1,0,'2023-05-30 03:21:26','2023-05-30 03:21:26',NULL,NULL,'3c7ba3a4-562a-439a-a7db-0e49dbb3466c'),(58,52,NULL,27,6,'craft\\elements\\Entry',1,0,'2023-05-30 03:21:31','2023-05-30 03:21:31',NULL,NULL,'df9968f4-aa9d-4b6d-805a-575fd3e463c3'),(59,52,NULL,28,6,'craft\\elements\\Entry',1,0,'2023-05-30 03:21:43','2023-05-30 03:21:43',NULL,NULL,'4564c80d-6a52-4b98-8547-4d1462292c65'),(60,52,NULL,29,6,'craft\\elements\\Entry',0,0,'2023-05-30 03:22:19','2023-05-30 03:22:19',NULL,NULL,'7dbab867-240b-4afc-8e25-0e3d46a0f66c'),(61,52,NULL,30,6,'craft\\elements\\Entry',1,0,'2023-05-30 03:23:18','2023-05-30 03:23:18',NULL,NULL,'d3cbefcb-8922-4439-befa-513a36077a12'),(62,52,21,NULL,6,'craft\\elements\\Entry',1,0,'2023-05-30 03:23:32','2023-05-30 03:23:32',NULL,NULL,'845e569f-9419-4c59-9b96-83f4df7d9d97'),(63,NULL,NULL,NULL,7,'craft\\elements\\Entry',1,0,'2023-05-30 03:24:20','2023-05-30 03:25:06',NULL,NULL,'e969f79e-fb83-4891-9f41-66e7bc1c8ee2'),(64,63,NULL,31,7,'craft\\elements\\Entry',1,0,'2023-05-30 03:24:20','2023-05-30 03:24:20',NULL,NULL,'48c6ab86-06ac-4dc3-b4e3-f6573f99bfcb'),(65,63,NULL,32,7,'craft\\elements\\Entry',1,0,'2023-05-30 03:24:20','2023-05-30 03:24:20',NULL,NULL,'fa4808af-266d-4f36-845f-739248764c17'),(66,63,NULL,33,7,'craft\\elements\\Entry',1,0,'2023-05-30 03:24:30','2023-05-30 03:24:30',NULL,NULL,'4e3e5b25-5766-4607-b3c0-ca60f304d895'),(68,63,NULL,34,7,'craft\\elements\\Entry',1,0,'2023-05-30 03:24:52','2023-05-30 03:24:52',NULL,NULL,'267e6a8a-5608-4c4d-b594-fafcb006f4df'),(69,63,NULL,35,7,'craft\\elements\\Entry',1,0,'2023-05-30 03:25:06','2023-05-30 03:25:06',NULL,NULL,'985e3253-d70a-4ae0-8ee1-c4950219d7b6');
/*!40000 ALTER TABLE `elements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements_sites`
--

LOCK TABLES `elements_sites` WRITE;
/*!40000 ALTER TABLE `elements_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements_sites` VALUES (1,1,1,NULL,NULL,1,'2023-05-01 08:06:42','2023-05-01 08:06:42','c39ad4aa-9c9d-4931-871d-51805f1ac191'),(2,2,1,'home','__home__',1,'2023-05-01 15:38:56','2023-05-01 15:38:56','c107eff1-a4e8-425f-9155-3d4a488b8e76'),(3,3,1,'home','__home__',1,'2023-05-01 15:38:56','2023-05-01 15:38:56','d9571b5f-ff6b-4993-af64-1fda60431589'),(4,4,1,'home','__home__',1,'2023-05-01 15:39:06','2023-05-01 15:39:06','a22484ef-a843-478c-a0cf-5980d91188de'),(5,5,1,'home','__home__',1,'2023-05-01 15:40:41','2023-05-01 15:40:41','b8c3c1f0-8028-48eb-a1d7-ae4d1892573b'),(7,7,1,'home','__home__',1,'2023-05-01 15:40:58','2023-05-01 15:40:58','5d8a454a-cd67-4301-9723-d31488b5fc04'),(9,9,1,'home','__home__',1,'2023-05-05 15:33:02','2023-05-05 15:33:02','47624357-5d6b-4b6b-8f36-59c5b882b77f'),(10,10,1,NULL,NULL,1,'2023-05-05 15:34:21','2023-05-05 15:34:21','4a4b4004-d30e-40ea-aee5-489ff3c3f5a9'),(11,11,1,NULL,NULL,1,'2023-05-05 15:34:22','2023-05-05 15:34:22','4a4c02fe-309c-4ab0-b576-074d33b8269e'),(12,12,1,NULL,NULL,1,'2023-05-05 15:34:24','2023-05-05 15:34:24','0108649b-6dcf-4867-aa6d-6e5c23c42522'),(13,13,1,'home','__home__',1,'2023-05-05 15:34:35','2023-05-05 15:34:35','12e019ad-a7ec-47f0-af6e-ab4b38eb66bf'),(15,15,1,'home','__home__',1,'2023-05-05 15:39:30','2023-05-05 15:39:30','de55bff4-0db0-408e-8083-37559f856684'),(16,16,1,'home','__home__',1,'2023-05-05 15:41:47','2023-05-05 15:41:47','02501f1e-72fc-47cd-b7ec-e9a5a72e17c2'),(17,17,1,'__temp_nkpihxyucbkodtamyxjgtopoidwigvgvymsx','property/__temp_nkpihxyucbkodtamyxjgtopoidwigvgvymsx',1,'2023-05-05 16:30:12','2023-05-05 16:30:12','5a7e4c4f-a9fe-40dc-98c8-339a823ffe08'),(18,18,1,'property1','property/property1',1,'2023-05-05 16:30:43','2023-05-05 16:30:51','cea30c08-661b-46ff-a7e3-3acb3253675e'),(19,19,1,'property1','property/property1',1,'2023-05-05 16:30:51','2023-05-05 16:30:51','345f1166-16c0-4c1f-ad51-68999288d076'),(20,20,1,'property1','property/property1',1,'2023-05-05 16:33:26','2023-05-05 16:33:26','f28a1afc-17ec-401d-b636-132582bc8e3b'),(21,21,1,'1-california-usa','property/1-california-usa',1,'2023-05-05 16:34:42','2023-05-06 13:29:16','d0cb2ef4-25d1-4bb0-a558-7bacf43295b9'),(22,22,1,NULL,NULL,1,'2023-05-05 16:35:51','2023-05-05 16:35:51','824d3a51-afa6-4b15-99b7-b4ccbc3ee61b'),(23,23,1,'1-california-usa','property/1-california-usa',1,'2023-05-06 13:13:47','2023-05-06 13:13:47','653a6570-3949-483a-aa46-de95529c5df1'),(24,24,1,'501-knights-run','property/501-knights-run',1,'2023-05-06 13:17:53','2023-05-06 13:28:55','198902c8-4b4a-4476-9be8-0584c988205d'),(25,25,1,NULL,NULL,1,'2023-05-06 13:19:17','2023-05-06 13:19:17','11c27411-92eb-44ce-b055-ddcecff6699a'),(26,26,1,'501-knights-run','property/501-knights-run',1,'2023-05-06 13:19:40','2023-05-06 13:19:40','2551ae6b-c348-4f11-9ee1-45602ab61bf5'),(27,27,1,'1-california-usa','property/1-california-usa',1,'2023-05-06 13:28:03','2023-05-06 13:28:03','38fbb35d-1daa-495c-84ad-a46d4a4c937d'),(29,29,1,'1-california-usa','property/1-california-usa',1,'2023-05-06 13:29:56','2023-05-06 13:29:56','52acf9db-a29b-4b09-bbfc-35eb8789f60b'),(31,31,1,'1-california-usa','property/1-california-usa',1,'2023-05-06 13:30:08','2023-05-06 13:30:08','fe95892a-c125-4069-8941-cbf2f3d0cf46'),(33,33,1,'1-california-usa','property/1-california-usa',1,'2023-05-06 13:30:19','2023-05-06 13:30:19','1b31d51b-d217-4446-8c42-df866881213a'),(34,34,1,'the-jardine-residences','property/the-jardine-residences',1,'2023-05-07 07:02:11','2023-05-07 07:02:22','25450fb3-ac9d-4008-8a90-f9a34d609c20'),(35,35,1,NULL,NULL,1,'2023-05-07 07:02:48','2023-05-07 07:02:48','4e0f8c53-62b3-4c45-a162-ad0b6fceda05'),(36,36,1,'the-jardine-residences','property/the-jardine-residences',1,'2023-05-07 07:02:59','2023-05-07 07:02:59','102d9880-2da2-4810-ac56-6b85651abb6d'),(37,37,1,NULL,NULL,1,'2023-05-07 07:05:42','2023-05-07 07:05:42','b79becad-7d03-44aa-854e-e26e7450994d'),(39,39,1,'the-jardine-residences','property/the-jardine-residences',1,'2023-05-07 07:05:49','2023-05-07 07:05:49','1db2c8ff-c09d-4d28-a471-a570fe8bbe6b'),(40,40,1,'home','__home__',1,'2023-05-29 10:11:01','2023-05-29 10:11:01','6fd404c0-922f-4426-af00-c638e7138114'),(41,41,1,'home','__home__',1,'2023-05-29 10:11:01','2023-05-29 10:11:01','58d1bf33-5b5d-4cbd-8e80-82cc8e37042f'),(42,42,1,'home','__home__',1,'2023-05-29 10:11:01','2023-05-29 10:11:01','c28336dc-20b4-45a9-be5f-42f95c1b7cc1'),(43,43,1,'home','__home__',1,'2023-05-29 10:11:01','2023-05-29 10:11:01','a969a89d-e4d7-426c-bc12-428b7e08c587'),(44,44,1,'landed','property/index-type/landed',1,'2023-05-29 14:01:39','2023-05-29 15:52:44','e2849f7c-6e29-4ea2-99e8-2d3802fa67b9'),(47,47,1,'the-jardine-residences','property/the-jardine-residences',1,'2023-05-29 14:26:07','2023-05-29 14:26:07','a03bcedd-43e1-4c0c-8180-707646356776'),(48,48,1,'condo','property/index-type/condo',1,'2023-05-29 15:41:01','2023-05-29 15:52:44','06508565-743f-45ff-a450-e88e5e560ef2'),(50,50,1,'501-knights-run','property/501-knights-run',1,'2023-05-29 15:41:24','2023-05-29 15:41:24','7b6c6097-002d-4319-afa3-9a2bdfc178ae'),(51,51,1,'1-california-usa','property/1-california-usa',1,'2023-05-29 15:42:07','2023-05-29 15:42:07','e0126b81-76a3-4c95-887e-1d78e5a5288e'),(52,52,1,'about',NULL,1,'2023-05-30 03:20:20','2023-05-30 03:20:20','e9a0c4f0-7b15-4f2d-9d87-5e8a40a47eda'),(53,53,1,'about',NULL,1,'2023-05-30 03:20:20','2023-05-30 03:20:20','67546142-daaa-4876-af6e-7c4bec1aa20e'),(54,54,1,'about',NULL,1,'2023-05-30 03:20:20','2023-05-30 03:20:20','2dd95beb-f433-45a6-9873-9a57a98f9fba'),(55,55,1,'about',NULL,1,'2023-05-30 03:20:21','2023-05-30 03:20:21','11d3b6d9-993c-4e39-a6f7-5360fdaff536'),(57,57,1,NULL,NULL,1,'2023-05-30 03:21:26','2023-05-30 03:21:26','0451569b-16f9-461f-bfa0-70b5d0fda8fa'),(58,58,1,'about',NULL,1,'2023-05-30 03:21:31','2023-05-30 03:21:31','55b95d34-22e6-435f-9077-9e6f21072464'),(59,59,1,'about',NULL,1,'2023-05-30 03:21:43','2023-05-30 03:21:43','acdb6339-8d3b-42bd-a9ca-3986dc9721a8'),(60,60,1,'about',NULL,1,'2023-05-30 03:22:19','2023-05-30 03:22:19','1de849a9-0d9e-4f04-87ee-a88078e59263'),(61,61,1,'about',NULL,1,'2023-05-30 03:23:18','2023-05-30 03:23:18','7699d011-a4aa-4c6a-9a35-b6158aaeecbf'),(62,62,1,'about',NULL,1,'2023-05-30 03:23:32','2023-05-30 03:23:32','f01770db-f335-41cd-8f9f-d4d6cbf279b9'),(63,63,1,'about','about',1,'2023-05-30 03:24:20','2023-05-30 03:24:20','574bc0e3-24cc-46e7-9f71-2ab52981fc75'),(64,64,1,'about','about',1,'2023-05-30 03:24:20','2023-05-30 03:24:20','86d75474-8d86-4fec-b3a6-361d05cd1394'),(65,65,1,'about','about',1,'2023-05-30 03:24:20','2023-05-30 03:24:20','a16b6e39-b8fc-449f-99d4-0d7c4489de3e'),(66,66,1,'about','about',1,'2023-05-30 03:24:30','2023-05-30 03:24:30','86680d0c-59df-48e1-8b4c-2c7d1d7d3843'),(68,68,1,'about','about',1,'2023-05-30 03:24:52','2023-05-30 03:24:52','8404f3fd-de60-4623-9ccd-b0deff93d58b'),(69,69,1,'about','about',1,'2023-05-30 03:25:06','2023-05-30 03:25:06','bf346b6a-2c19-446e-8482-2e3df26fa2d2');
/*!40000 ALTER TABLE `elements_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `entries`
--

LOCK TABLES `entries` WRITE;
/*!40000 ALTER TABLE `entries` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `entries` VALUES (2,1,NULL,1,NULL,'2023-05-01 15:38:00',NULL,NULL,'2023-05-01 15:38:56','2023-05-01 15:38:56'),(3,1,NULL,1,NULL,'2023-05-01 15:38:00',NULL,NULL,'2023-05-01 15:38:56','2023-05-01 15:38:56'),(4,1,NULL,1,NULL,'2023-05-01 15:38:00',NULL,NULL,'2023-05-01 15:39:06','2023-05-01 15:39:06'),(5,1,NULL,1,NULL,'2023-05-01 15:38:00',NULL,NULL,'2023-05-01 15:40:41','2023-05-01 15:40:41'),(7,1,NULL,1,NULL,'2023-05-01 15:38:00',NULL,NULL,'2023-05-01 15:40:58','2023-05-01 15:40:58'),(9,1,NULL,1,NULL,'2023-05-01 15:38:00',NULL,NULL,'2023-05-05 15:33:02','2023-05-05 15:33:02'),(13,1,NULL,1,NULL,'2023-05-01 15:38:00',NULL,NULL,'2023-05-05 15:34:35','2023-05-05 15:34:35'),(15,1,NULL,1,NULL,'2023-05-01 15:38:00',NULL,NULL,'2023-05-05 15:39:30','2023-05-05 15:39:30'),(16,1,NULL,1,NULL,'2023-05-01 15:38:00',NULL,NULL,'2023-05-05 15:41:47','2023-05-05 15:41:47'),(17,2,NULL,2,1,'2023-05-05 16:30:00',NULL,1,'2023-05-05 16:30:12','2023-05-05 16:30:12'),(18,2,NULL,2,1,'2023-05-05 16:30:00',NULL,1,'2023-05-05 16:30:43','2023-05-05 16:30:43'),(19,2,NULL,2,1,'2023-05-05 16:30:00',NULL,NULL,'2023-05-05 16:30:51','2023-05-05 16:30:51'),(20,2,NULL,3,1,'2023-05-05 16:30:00',NULL,NULL,'2023-05-05 16:33:26','2023-05-05 16:33:26'),(21,2,NULL,3,1,'2023-05-05 16:34:00',NULL,NULL,'2023-05-05 16:34:42','2023-05-05 16:34:42'),(23,2,NULL,3,1,'2023-05-05 16:34:00',NULL,NULL,'2023-05-06 13:13:47','2023-05-06 13:13:47'),(24,2,NULL,3,1,'2023-05-06 13:17:00',NULL,NULL,'2023-05-06 13:17:53','2023-05-06 13:17:53'),(26,2,NULL,3,1,'2023-05-06 13:17:00',NULL,NULL,'2023-05-06 13:19:40','2023-05-06 13:19:40'),(27,2,NULL,3,1,'2023-05-05 16:34:00',NULL,NULL,'2023-05-06 13:28:03','2023-05-06 13:28:03'),(29,2,NULL,3,1,'2023-05-05 16:34:00',NULL,NULL,'2023-05-06 13:29:56','2023-05-06 13:29:56'),(31,2,NULL,3,1,'2023-05-05 16:34:00',NULL,NULL,'2023-05-06 13:30:08','2023-05-06 13:30:08'),(33,2,NULL,3,1,'2023-05-05 16:34:00',NULL,NULL,'2023-05-06 13:30:19','2023-05-06 13:30:19'),(34,2,NULL,3,1,'2023-05-07 07:02:00',NULL,NULL,'2023-05-07 07:02:11','2023-05-07 07:02:11'),(36,2,NULL,3,1,'2023-05-07 07:02:00',NULL,NULL,'2023-05-07 07:02:59','2023-05-07 07:02:59'),(39,2,NULL,3,1,'2023-05-07 07:02:00',NULL,NULL,'2023-05-07 07:05:49','2023-05-07 07:05:49'),(40,1,NULL,1,NULL,'2023-05-01 15:38:00',NULL,NULL,'2023-05-29 10:11:01','2023-05-29 10:11:01'),(41,1,NULL,1,NULL,'2023-05-01 15:38:00',NULL,NULL,'2023-05-29 10:11:01','2023-05-29 10:11:01'),(42,1,NULL,1,NULL,'2023-05-01 15:38:00',NULL,NULL,'2023-05-29 10:11:01','2023-05-29 10:11:01'),(43,1,NULL,1,NULL,'2023-05-01 15:38:00',NULL,NULL,'2023-05-29 10:11:01','2023-05-29 10:11:01'),(47,2,NULL,3,1,'2023-05-07 07:02:00',NULL,NULL,'2023-05-29 14:26:07','2023-05-29 14:26:07'),(50,2,NULL,3,1,'2023-05-06 13:17:00',NULL,NULL,'2023-05-29 15:41:24','2023-05-29 15:41:24'),(51,2,NULL,3,1,'2023-05-05 16:34:00',NULL,NULL,'2023-05-29 15:42:07','2023-05-29 15:42:07'),(52,3,NULL,4,NULL,'2023-05-30 03:20:00',NULL,1,'2023-05-30 03:20:20','2023-05-30 03:20:20'),(53,3,NULL,4,NULL,'2023-05-30 03:20:00',NULL,NULL,'2023-05-30 03:20:20','2023-05-30 03:20:20'),(54,3,NULL,4,NULL,'2023-05-30 03:20:00',NULL,NULL,'2023-05-30 03:20:20','2023-05-30 03:20:20'),(55,3,NULL,4,NULL,'2023-05-30 03:20:00',NULL,NULL,'2023-05-30 03:20:21','2023-05-30 03:20:21'),(58,3,NULL,4,NULL,'2023-05-30 03:20:00',NULL,NULL,'2023-05-30 03:21:31','2023-05-30 03:21:31'),(59,3,NULL,4,NULL,'2023-05-30 03:20:00',NULL,NULL,'2023-05-30 03:21:43','2023-05-30 03:21:43'),(60,3,NULL,4,NULL,'2023-05-30 03:20:00',NULL,NULL,'2023-05-30 03:22:19','2023-05-30 03:22:19'),(61,3,NULL,4,NULL,'2023-05-30 03:20:00',NULL,NULL,'2023-05-30 03:23:18','2023-05-30 03:23:18'),(62,3,NULL,4,NULL,'2023-05-30 03:20:00',NULL,NULL,'2023-05-30 03:23:32','2023-05-30 03:23:32'),(63,4,NULL,5,NULL,'2023-05-30 03:24:00',NULL,NULL,'2023-05-30 03:24:20','2023-05-30 03:24:20'),(64,4,NULL,5,NULL,'2023-05-30 03:24:00',NULL,NULL,'2023-05-30 03:24:20','2023-05-30 03:24:20'),(65,4,NULL,5,NULL,'2023-05-30 03:24:00',NULL,NULL,'2023-05-30 03:24:20','2023-05-30 03:24:20'),(66,4,NULL,5,NULL,'2023-05-30 03:24:00',NULL,NULL,'2023-05-30 03:24:30','2023-05-30 03:24:30'),(68,4,NULL,5,NULL,'2023-05-30 03:24:00',NULL,NULL,'2023-05-30 03:24:52','2023-05-30 03:24:52'),(69,4,NULL,5,NULL,'2023-05-30 03:24:00',NULL,NULL,'2023-05-30 03:25:06','2023-05-30 03:25:06');
/*!40000 ALTER TABLE `entries` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `entrytypes`
--

LOCK TABLES `entrytypes` WRITE;
/*!40000 ALTER TABLE `entrytypes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `entrytypes` VALUES (1,1,1,'Home','home',0,'site',NULL,'{section.name|raw}',1,'2023-05-01 15:38:56','2023-05-01 15:38:56',NULL,'20b3a2cc-928b-4f67-a9e9-b871c7e9356d'),(2,2,3,'Default','default',1,'site',NULL,NULL,1,'2023-05-05 16:28:33','2023-05-05 16:28:33','2023-05-05 16:33:46','2c706861-70ea-4d85-8ff5-8d632949e088'),(3,2,4,'Normal Property','normalProperty',1,'site',NULL,NULL,2,'2023-05-05 16:30:01','2023-05-05 16:34:33',NULL,'7f071c0f-0498-4c4d-9237-5c1652b7803f'),(4,3,6,'About','about',1,'site',NULL,NULL,1,'2023-05-30 03:19:50','2023-05-30 03:20:21','2023-05-30 03:24:00','f3bb34b3-0e5c-4998-8991-18e6a519d6b6'),(5,4,7,'About','about',0,'site',NULL,'{section.name|raw}',1,'2023-05-30 03:24:20','2023-05-30 03:24:20',NULL,'cd8a9b25-b028-41f5-a1fb-9b9598d38b4d');
/*!40000 ALTER TABLE `entrytypes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fieldgroups`
--

LOCK TABLES `fieldgroups` WRITE;
/*!40000 ALTER TABLE `fieldgroups` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fieldgroups` VALUES (1,'Common','2023-05-01 08:06:42','2023-05-01 08:06:42',NULL,'3ba498a1-6662-447d-859f-64de252b31b8'),(2,'Home','2023-05-01 15:35:59','2023-05-01 15:35:59',NULL,'c65b609c-c051-4a11-b7cf-270031689a67'),(3,'property','2023-05-05 16:31:54','2023-05-05 16:31:54',NULL,'ff5bce1f-d6a8-4b4a-9b65-9c80a3c7df94');
/*!40000 ALTER TABLE `fieldgroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fieldlayoutfields`
--

LOCK TABLES `fieldlayoutfields` WRITE;
/*!40000 ALTER TABLE `fieldlayoutfields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fieldlayoutfields` VALUES (29,1,21,1,0,1,'2023-05-29 10:11:01','2023-05-29 10:11:01','5cb0da61-10f0-4946-ab3a-bf8df4fc7c6c'),(30,1,21,2,0,2,'2023-05-29 10:11:01','2023-05-29 10:11:01','3104405f-9d19-4cba-9f9e-6af8a8799eae'),(39,4,27,7,0,1,'2023-05-29 14:03:50','2023-05-29 14:03:50','382dde43-b9e1-4fbc-8fb4-3f12bab85a2d'),(40,4,27,4,0,2,'2023-05-29 14:03:50','2023-05-29 14:03:50','8c4095eb-e100-433e-85c5-d734986d160d'),(41,4,27,6,0,3,'2023-05-29 14:03:50','2023-05-29 14:03:50','2801c9ed-1046-447d-b318-fcbd667024df'),(42,4,27,5,0,4,'2023-05-29 14:03:50','2023-05-29 14:03:50','06c90be7-b832-4c6f-a342-1d03d777fab8'),(43,4,27,3,0,5,'2023-05-29 14:03:50','2023-05-29 14:03:50','08b3f3f2-a63a-42d9-b014-530b826fcd92'),(46,6,33,9,0,1,'2023-05-30 03:20:21','2023-05-30 03:20:21','a89d6c2b-0436-4235-9a7c-3b4990bcc1ed'),(47,6,33,8,0,2,'2023-05-30 03:20:21','2023-05-30 03:20:21','a1f5ed3c-2bce-42f8-8e35-85a92efafefc'),(48,7,35,9,0,1,'2023-05-30 03:24:30','2023-05-30 03:24:30','e63033db-848d-4a48-afd3-668be915d234'),(49,7,35,8,0,2,'2023-05-30 03:24:30','2023-05-30 03:24:30','01a607c5-9847-4f7a-9219-efc90dde70e1');
/*!40000 ALTER TABLE `fieldlayoutfields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fieldlayouts`
--

LOCK TABLES `fieldlayouts` WRITE;
/*!40000 ALTER TABLE `fieldlayouts` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fieldlayouts` VALUES (1,'craft\\elements\\Entry','2023-05-01 15:38:56','2023-05-01 15:38:56',NULL,'98c9827c-5472-4a6b-8f8f-7d0d3e2d993b'),(2,'craft\\elements\\Asset','2023-05-05 15:30:42','2023-05-05 15:30:42',NULL,'dc408bb2-f08d-463a-9243-60d07dccb177'),(3,'craft\\elements\\Entry','2023-05-05 16:28:33','2023-05-05 16:28:33','2023-05-05 16:33:46','3ff3e512-422b-43d1-9650-ad93935f1126'),(4,'craft\\elements\\Entry','2023-05-05 16:30:01','2023-05-05 16:30:01',NULL,'20c6814f-67ef-4096-aae6-8d176bf9ef02'),(5,'craft\\elements\\Category','2023-05-29 13:59:09','2023-05-29 13:59:09',NULL,'74d78374-2b4c-4645-aaae-ae2236fb6266'),(6,'craft\\elements\\Entry','2023-05-30 03:19:50','2023-05-30 03:19:50','2023-05-30 03:24:00','12e65eb8-3112-4d6b-9706-6a4352d73154'),(7,'craft\\elements\\Entry','2023-05-30 03:24:20','2023-05-30 03:24:20',NULL,'1a56c455-3e11-47d9-88c6-d87fc9fe930c');
/*!40000 ALTER TABLE `fieldlayouts` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fieldlayouttabs`
--

LOCK TABLES `fieldlayouttabs` WRITE;
/*!40000 ALTER TABLE `fieldlayouttabs` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fieldlayouttabs` VALUES (6,3,'Content',NULL,'[{\"type\":\"craft\\\\fieldlayoutelements\\\\EntryTitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"a45195f6-8253-44d6-80c7-33eb2708c967\"}]',1,'2023-05-05 16:28:33','2023-05-29 04:19:22','ee1e6e93-8eac-4262-a10e-68352987e1cf'),(21,1,'Content','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"618d18a6-fbb1-430e-b3a1-605fef4fab88\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"20a7d9b7-6d6d-479f-9fab-8bbfed93e512\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"8d5a8e2a-8913-4146-89a2-155418535bd4\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"129a2365-4f74-4b64-9d3b-8a60b312f848\"}]',1,'2023-05-29 10:11:01','2023-05-29 10:11:01','32fdc493-98c1-45eb-9605-ade39195c830'),(25,2,'Content','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\assets\\\\AssetTitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"62714ae2-9c9f-4805-8e32-99f93ffb9bea\",\"userCondition\":null,\"elementCondition\":null}]',1,'2023-05-29 10:11:02','2023-05-29 10:11:02','4c16f436-a6f9-4b54-aece-6394a47c0342'),(27,4,'Content','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"7f4ae5ef-e1a6-4393-b21d-1eea4c027f8f\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"daf9bacc-8ead-4504-9e3c-5244d71d7fc6\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"eaa73a01-56ea-40be-971b-c3968933d7c2\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"f5dc7358-09e8-4aba-bf1a-ea6a227d888b\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"d11c8c5f-8aa7-4992-87c0-d5a5db276260\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"258870ed-da63-4941-99fc-19c9dc65839f\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"1f4f2aa8-cd42-4d72-847f-e246f74e22a0\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"88838aab-9a64-4025-a386-09dead7c61bf\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"5d1f4896-4385-47ed-a94e-4b027195e527\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"13ce2fa8-244a-4066-bcba-1a49014748c1\"}]',1,'2023-05-29 14:03:50','2023-05-29 14:03:50','20f280c0-0245-46ce-9ae7-cbf96e9fc975'),(30,5,'Content','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\TitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"490a79e5-dd3c-4302-a6e7-86efc1d94a2e\",\"userCondition\":null,\"elementCondition\":null}]',1,'2023-05-29 15:52:44','2023-05-29 15:52:44','8efd4cf6-afe7-460f-8c47-7229c665c9b9'),(33,6,'Content','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"46651f98-53c7-4c7a-9c35-66df9ce82d5d\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"da29978b-0aba-45e0-91ef-fff4aadc5db7\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"8cb71acd-feff-4ee0-b731-711439a5773d\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"e67710ed-f643-4e83-a66f-9fbb562e06ee\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"3268c203-ca86-4709-89af-bf5f18dd6b0c\"}]',1,'2023-05-30 03:20:21','2023-05-30 03:20:21','03c66a40-866f-4a1a-9c01-4e0e3da65af4'),(35,7,'Content','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"519b15da-1acf-43f8-a944-9ba24ea7f5ef\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"548d02e0-1056-4325-8ef8-df412281096d\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"8cb71acd-feff-4ee0-b731-711439a5773d\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"b6b02c84-02aa-41e2-8da0-e1ddd00f86c0\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"3268c203-ca86-4709-89af-bf5f18dd6b0c\"}]',1,'2023-05-30 03:24:30','2023-05-30 03:24:30','b2a54dd9-fe8a-4d66-94e8-18bfc983c817');
/*!40000 ALTER TABLE `fieldlayouttabs` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fields`
--

LOCK TABLES `fields` WRITE;
/*!40000 ALTER TABLE `fields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fields` VALUES (1,1,'Home Title','homeTitle','global','dcwxekih','Title On the Top of Hero Box',0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":150,\"code\":\"\",\"columnType\":null,\"initialRows\":\"2\",\"multiline\":\"1\",\"placeholder\":\"Easiest Way to Find Your Dream Home\",\"uiMode\":\"normal\"}','2023-05-01 15:37:04','2023-05-01 15:37:04','5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b'),(2,2,'hero images','heroImages','global',NULL,'The hero pictures in the background ',0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowUploads\":true,\"allowedKinds\":null,\"defaultUploadLocationSource\":\"volume:79a24291-0544-4c50-913c-9dda4ee5656e\",\"defaultUploadLocationSubpath\":\"\\/home\\/hero\",\"limit\":\"5\",\"localizeRelations\":false,\"previewMode\":\"full\",\"restrictFiles\":\"\",\"selectionLabel\":\"Select\",\"showSiteMenu\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"singleUploadLocationSource\":\"volume:79a24291-0544-4c50-913c-9dda4ee5656e\",\"singleUploadLocationSubpath\":\"\",\"source\":null,\"sources\":[\"volume:79a24291-0544-4c50-913c-9dda4ee5656e\"],\"targetSiteId\":null,\"useSingleFolder\":false,\"validateRelatedElements\":false,\"viewMode\":\"list\"}','2023-05-05 15:32:32','2023-05-05 15:32:32','129a2365-4f74-4b64-9d3b-8a60b312f848'),(3,3,'pictures','pictures','global',NULL,'Pictures of the property',0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowUploads\":true,\"allowedKinds\":null,\"defaultUploadLocationSource\":\"volume:79a24291-0544-4c50-913c-9dda4ee5656e\",\"defaultUploadLocationSubpath\":\"property\\/slug\",\"limit\":\"\",\"localizeRelations\":false,\"previewMode\":\"full\",\"restrictFiles\":\"\",\"selectionLabel\":\"\",\"showSiteMenu\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"singleUploadLocationSource\":\"volume:79a24291-0544-4c50-913c-9dda4ee5656e\",\"singleUploadLocationSubpath\":\"\",\"source\":null,\"sources\":\"*\",\"targetSiteId\":null,\"useSingleFolder\":false,\"validateRelatedElements\":false,\"viewMode\":\"list\"}','2023-05-05 16:32:32','2023-05-05 16:32:32','13ce2fa8-244a-4066-bcba-1a49014748c1'),(4,3,'price','price','global','hedotwnu','Price In thousands',0,'none',NULL,'craft\\fields\\Number','{\"decimals\":0,\"defaultValue\":null,\"max\":null,\"min\":null,\"prefix\":null,\"previewCurrency\":\"\",\"previewFormat\":\"decimal\",\"size\":null,\"suffix\":null}','2023-05-06 13:04:50','2023-05-06 13:04:50','43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb'),(5,3,'Suburb','suburb','global','fixdfhog','',0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":\"\",\"columnType\":null,\"initialRows\":\"4\",\"multiline\":\"\",\"placeholder\":null,\"uiMode\":\"normal\"}','2023-05-06 13:06:16','2023-05-06 13:06:16','88838aab-9a64-4025-a386-09dead7c61bf'),(6,3,'State','state','global','nyrarqel','The state',0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":\"\",\"columnType\":null,\"initialRows\":\"4\",\"multiline\":\"\",\"placeholder\":null,\"uiMode\":\"normal\"}','2023-05-06 13:06:47','2023-05-06 13:06:47','258870ed-da63-4941-99fc-19c9dc65839f'),(7,3,'Property Type','propertyType','global',NULL,'Type of Property',0,'site',NULL,'craft\\fields\\Categories','{\"allowSelfRelations\":false,\"branchLimit\":null,\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":1,\"minRelations\":1,\"selectionLabel\":null,\"showSiteMenu\":true,\"source\":\"group:9ca8966f-b6f7-4cf9-acf9-401ac6a384d0\",\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":null}','2023-05-29 14:03:28','2023-05-29 14:04:41','eaa73a01-56ea-40be-971b-c3968933d7c2'),(8,1,'mainImage','mainImage','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":null,\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:79a24291-0544-4c50-913c-9dda4ee5656e\",\"defaultUploadLocationSubpath\":\"common\",\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":1,\"minRelations\":1,\"previewMode\":\"full\",\"restrictFiles\":false,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:79a24291-0544-4c50-913c-9dda4ee5656e\",\"restrictedLocationSubpath\":null,\"selectionCondition\":{\"elementType\":\"craft\\\\elements\\\\Asset\",\"fieldContext\":\"global\",\"class\":\"craft\\\\elements\\\\conditions\\\\assets\\\\AssetCondition\"},\"selectionLabel\":null,\"showSiteMenu\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":\"*\",\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"list\"}','2023-05-30 03:18:03','2023-05-30 03:18:03','3268c203-ca86-4709-89af-bf5f18dd6b0c'),(9,1,'mainText','mainText','global','idddvzgl',NULL,0,'none',NULL,'craft\\redactor\\Field','{\"availableTransforms\":\"*\",\"availableVolumes\":\"*\",\"columnType\":\"text\",\"configSelectionMode\":\"choose\",\"defaultTransform\":\"\",\"manualConfig\":\"\",\"purifierConfig\":null,\"purifyHtml\":true,\"redactorConfig\":null,\"removeEmptyTags\":false,\"removeInlineStyles\":false,\"removeNbsp\":false,\"showHtmlButtonForNonAdmins\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"uiMode\":\"enlarged\"}','2023-05-30 03:19:09','2023-05-30 03:19:09','8cb71acd-feff-4ee0-b731-711439a5773d');
/*!40000 ALTER TABLE `fields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `globalsets`
--

LOCK TABLES `globalsets` WRITE;
/*!40000 ALTER TABLE `globalsets` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `globalsets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `gqlschemas`
--

LOCK TABLES `gqlschemas` WRITE;
/*!40000 ALTER TABLE `gqlschemas` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `gqlschemas` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `gqltokens`
--

LOCK TABLES `gqltokens` WRITE;
/*!40000 ALTER TABLE `gqltokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `gqltokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `imagetransforms`
--

LOCK TABLES `imagetransforms` WRITE;
/*!40000 ALTER TABLE `imagetransforms` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `imagetransforms` VALUES (2,'Resize to 400 webp','resizeTo400Webp','crop','center-center',400,325,'webp',NULL,'none',NULL,1,'2023-05-29 10:11:02','2023-05-07 14:50:57','2023-05-29 10:11:02','f79cb78d-6246-447e-82bf-cd55d2e2f18a');
/*!40000 ALTER TABLE `imagetransforms` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `info`
--

LOCK TABLES `info` WRITE;
/*!40000 ALTER TABLE `info` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `info` VALUES (1,'4.4.13','4.4.0.4',0,'hvmbpjhwepoq','3@qvfsiaqudr','2023-05-01 08:06:42','2023-05-30 03:24:30','7ccb66ac-fd5c-4918-b2ec-e6167f685177');
/*!40000 ALTER TABLE `info` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `matrixblocks`
--

LOCK TABLES `matrixblocks` WRITE;
/*!40000 ALTER TABLE `matrixblocks` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `matrixblocks` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `matrixblocks_owners`
--

LOCK TABLES `matrixblocks_owners` WRITE;
/*!40000 ALTER TABLE `matrixblocks_owners` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `matrixblocks_owners` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `matrixblocktypes`
--

LOCK TABLES `matrixblocktypes` WRITE;
/*!40000 ALTER TABLE `matrixblocktypes` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `matrixblocktypes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `migrations` VALUES (1,'craft','Install','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','486b7dac-cdd8-407c-a87c-0ac7337df34e'),(2,'craft','m150403_183908_migrations_table_changes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','9f1d4609-f839-4a11-a153-9ee3f3fe5967'),(3,'craft','m150403_184247_plugins_table_changes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','141251e5-616a-4d44-975e-809fab4de2cb'),(4,'craft','m150403_184533_field_version','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','c1d159e4-1623-4ba6-99c4-0acf39543faa'),(5,'craft','m150403_184729_type_columns','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','d98d5db5-f61c-4492-9281-aecb5081b4c8'),(6,'craft','m150403_185142_volumes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','fa1fdd90-1329-492a-bd19-946cda89ea77'),(7,'craft','m150428_231346_userpreferences','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','dd632634-61f7-4d15-a141-1c8934a99e03'),(8,'craft','m150519_150900_fieldversion_conversion','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','892c7ad4-7fa7-4a7d-8d21-0bac39beb44d'),(9,'craft','m150617_213829_update_email_settings','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','1c933ad3-2dbd-4cae-b472-4e90a8b9b2c3'),(10,'craft','m150721_124739_templatecachequeries','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','f34ab49a-859c-45ed-a604-eed7fe8b0635'),(11,'craft','m150724_140822_adjust_quality_settings','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','f8dab34e-d6d3-4aa2-b402-c4e1bb33574b'),(12,'craft','m150815_133521_last_login_attempt_ip','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','d5b8a150-4a9e-4cb4-9716-a9143dc79283'),(13,'craft','m151002_095935_volume_cache_settings','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','8c248e94-6d98-4688-aa57-313ba0bae4b0'),(14,'craft','m151005_142750_volume_s3_storage_settings','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','d0f77be5-bedb-493d-a156-c10ac7eda573'),(15,'craft','m151016_133600_delete_asset_thumbnails','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','e2653fcc-cebc-4c28-b85e-e26696301398'),(16,'craft','m151209_000000_move_logo','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','5e77033e-e96f-4585-aeeb-142a7ac6e7eb'),(17,'craft','m151211_000000_rename_fileId_to_assetId','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','42983931-c9e9-45ef-897c-c26ad6c848c4'),(18,'craft','m151215_000000_rename_asset_permissions','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','7f2d3401-ca06-470c-97d1-9fc240943c8f'),(19,'craft','m160707_000001_rename_richtext_assetsource_setting','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','3b0b38c3-d70d-492e-b3bb-25c247c89a12'),(20,'craft','m160708_185142_volume_hasUrls_setting','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','36a3f9dd-36b3-4255-8ba8-dfb25c96b03e'),(21,'craft','m160714_000000_increase_max_asset_filesize','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','8b63384c-820f-4132-9332-802333dcc28d'),(22,'craft','m160727_194637_column_cleanup','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','5d70aee5-64f6-4234-9737-fe64f6896571'),(23,'craft','m160804_110002_userphotos_to_assets','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','614e61f4-5a1d-424d-888d-d7ee7ab94a08'),(24,'craft','m160807_144858_sites','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','5f799296-d5de-488b-9c81-e2c8c8937d1e'),(25,'craft','m160829_000000_pending_user_content_cleanup','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','7733c4e9-228d-4f8f-878c-c87ed8707a27'),(26,'craft','m160830_000000_asset_index_uri_increase','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','6383cbd1-a004-4ad2-8eb2-33958db48b4e'),(27,'craft','m160912_230520_require_entry_type_id','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','605c7921-7ee6-4765-b2b4-08b71f5ca79d'),(28,'craft','m160913_134730_require_matrix_block_type_id','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','5611db56-25b5-4f27-bb3a-bd650190f648'),(29,'craft','m160920_174553_matrixblocks_owner_site_id_nullable','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','d37afd0b-399c-468e-8f51-3364b74d46b2'),(30,'craft','m160920_231045_usergroup_handle_title_unique','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','0950dcaf-c897-4fb9-98f1-7e11bd9f7c0a'),(31,'craft','m160925_113941_route_uri_parts','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','c5c7eb2a-a11f-4bec-b931-4aa49ba9d9aa'),(32,'craft','m161006_205918_schemaVersion_not_null','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','a4f081f3-b17e-4401-96f2-5002c25c796a'),(33,'craft','m161007_130653_update_email_settings','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','d5a9c818-07c0-4b60-8dbf-41fe0af88e62'),(34,'craft','m161013_175052_newParentId','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','76a6f1c8-c42e-4995-81cc-b1a246090513'),(35,'craft','m161021_102916_fix_recent_entries_widgets','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','735c1948-4df9-48d7-852f-5314796a2e34'),(36,'craft','m161021_182140_rename_get_help_widget','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','4f736085-0ab2-47b0-b145-c1b3661fb640'),(37,'craft','m161025_000000_fix_char_columns','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','1750e0b1-0d55-4190-945c-feab0d6e5e2f'),(38,'craft','m161029_124145_email_message_languages','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','f80cfc4f-5c81-4676-ba38-e1aca87a57a9'),(39,'craft','m161108_000000_new_version_format','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','9d986060-0da1-4d64-8bf0-bc0221176572'),(40,'craft','m161109_000000_index_shuffle','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','d062c8cc-833c-495d-a082-8c170456cc08'),(41,'craft','m161122_185500_no_craft_app','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','166a1871-6a28-4303-8aa3-bea89403d45a'),(42,'craft','m161125_150752_clear_urlmanager_cache','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','92e7f18b-4060-4c91-b3b3-9b308867e07d'),(43,'craft','m161220_000000_volumes_hasurl_notnull','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','87ed341b-4e52-4a3a-a436-94861deb3a4d'),(44,'craft','m170114_161144_udates_permission','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','d2b54e6a-9f6e-4c9a-a3fa-09cb961df0e2'),(45,'craft','m170120_000000_schema_cleanup','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','52974b40-6229-4064-91aa-065af1366da1'),(46,'craft','m170126_000000_assets_focal_point','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','f4a82c7e-9413-4a05-91b6-c06a7254e15d'),(47,'craft','m170206_142126_system_name','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','8f64d8a6-783d-46c3-9181-248af472698a'),(48,'craft','m170217_044740_category_branch_limits','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','d069c9bc-12e0-4ffa-80d9-28cd7ace221d'),(49,'craft','m170217_120224_asset_indexing_columns','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','e8e52a74-2d89-4280-8ae5-49f0b965778e'),(50,'craft','m170223_224012_plain_text_settings','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','e950e6db-f910-4919-9129-cdbfbc64d26c'),(51,'craft','m170227_120814_focal_point_percentage','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','daad77d1-3cd2-4d3c-bee8-460468a7e9ad'),(52,'craft','m170228_171113_system_messages','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','744bfb6c-f9cd-42fd-b74a-5835e42b3397'),(53,'craft','m170303_140500_asset_field_source_settings','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','fb3a3065-c441-470d-bdeb-7594db33ab4e'),(54,'craft','m170306_150500_asset_temporary_uploads','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','3b20309e-43f9-4baf-9977-1a2301bb2a08'),(55,'craft','m170523_190652_element_field_layout_ids','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','1a323e45-c470-4470-b637-f2f4426a3725'),(56,'craft','m170621_195237_format_plugin_handles','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','42fb2b50-18d8-4bab-b196-3fce63ed5b86'),(57,'craft','m170630_161027_deprecation_line_nullable','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','46ffa9cc-d0ec-473f-80ff-ee062f8464b2'),(58,'craft','m170630_161028_deprecation_changes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','88102cbc-9b72-4234-a20c-b8afa92e3e96'),(59,'craft','m170703_181539_plugins_table_tweaks','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','0dc2b8cc-6676-4aab-8ff4-a774ae8b2852'),(60,'craft','m170704_134916_sites_tables','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','820d48ad-d467-40d5-b58c-80cfecc0a3a4'),(61,'craft','m170706_183216_rename_sequences','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','97312c58-4c80-4321-a944-3b577fb2a617'),(62,'craft','m170707_094758_delete_compiled_traits','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','547b4d70-2e84-49dc-8343-554831db525c'),(63,'craft','m170731_190138_drop_asset_packagist','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','428441d1-f577-49b9-821d-e4f4e858d91c'),(64,'craft','m170810_201318_create_queue_table','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','abd83f0c-dcfa-4716-8a72-296cac1381c7'),(65,'craft','m170903_192801_longblob_for_queue_jobs','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','14baeafe-639b-4605-9b05-944a385a9548'),(66,'craft','m170914_204621_asset_cache_shuffle','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','08682dc0-573f-4956-ade5-3303bc9d5087'),(67,'craft','m171011_214115_site_groups','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','43b72270-123f-4b59-88d2-3c429d2a1789'),(68,'craft','m171012_151440_primary_site','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','00c57217-6d4c-4440-8001-abd1e5ca1bb3'),(69,'craft','m171013_142500_transform_interlace','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','caa830fa-2ff4-4bd4-9f9a-63f399b9b6ec'),(70,'craft','m171016_092553_drop_position_select','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','bac5bc41-0cbd-4f6b-b635-30b1e2d41e73'),(71,'craft','m171016_221244_less_strict_translation_method','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','4c11a194-3a9a-4287-a5a7-babaf0268423'),(72,'craft','m171107_000000_assign_group_permissions','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','f5032bd6-d8b3-47b4-9a2b-78192847306c'),(73,'craft','m171117_000001_templatecache_index_tune','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','a169c6cb-7f85-4b31-987a-568667a728d1'),(74,'craft','m171126_105927_disabled_plugins','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','15a54aeb-f531-46b8-a5b3-15b0372e2489'),(75,'craft','m171130_214407_craftidtokens_table','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','0e0a93fb-8b29-4694-9259-91e2de21d1df'),(76,'craft','m171202_004225_update_email_settings','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','e7b6f7b3-8e20-460b-bac6-cb15ce425e08'),(77,'craft','m171204_000001_templatecache_index_tune_deux','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','29fea159-0d94-44b5-8df6-1ac895df0886'),(78,'craft','m171205_130908_remove_craftidtokens_refreshtoken_column','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','17469828-07fe-4661-9f70-ec81b202babd'),(79,'craft','m171218_143135_longtext_query_column','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','39d3b946-2cb2-459d-9307-fdf8417a6f6f'),(80,'craft','m171231_055546_environment_variables_to_aliases','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','a4d47c30-bef9-40dc-afdd-2c25633845bb'),(81,'craft','m180113_153740_drop_users_archived_column','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','d98c74dd-733e-41e4-a2b6-cc9b2a1e4b79'),(82,'craft','m180122_213433_propagate_entries_setting','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','84ebc74e-9235-419d-8684-a67a1d05e128'),(83,'craft','m180124_230459_fix_propagate_entries_values','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','df8b5a2f-ee23-4644-805a-5de3deaba702'),(84,'craft','m180128_235202_set_tag_slugs','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','7ab2ed06-f114-42b2-b16e-f15e61d6a773'),(85,'craft','m180202_185551_fix_focal_points','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','a56f772f-28d3-4083-9f6b-de252d6ae9d9'),(86,'craft','m180217_172123_tiny_ints','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','7c013935-9976-4713-a52c-a57831ef2236'),(87,'craft','m180321_233505_small_ints','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','c1092edf-b3f5-4b70-a4d9-afa6bb9d1b5f'),(88,'craft','m180404_182320_edition_changes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','58ece99d-d508-4c12-baa8-5605e06fe7d6'),(89,'craft','m180411_102218_fix_db_routes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','d9487b5a-c9f2-4014-9a05-d9e21db4ec39'),(90,'craft','m180416_205628_resourcepaths_table','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','e27fafc9-8375-4ffe-86fa-c6e088973cb0'),(91,'craft','m180418_205713_widget_cleanup','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','b138c047-e467-4540-89a1-6e56c612047f'),(92,'craft','m180425_203349_searchable_fields','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','dfaf55c8-b988-44f7-b6dc-025201099a76'),(93,'craft','m180516_153000_uids_in_field_settings','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','c09b2f97-8dd7-4851-a64d-c69b664d995f'),(94,'craft','m180517_173000_user_photo_volume_to_uid','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','5392e2c3-b059-4cb5-a52a-edf554688815'),(95,'craft','m180518_173000_permissions_to_uid','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','b6bbe90b-d5fe-4a55-aa37-7fe50278814c'),(96,'craft','m180520_173000_matrix_context_to_uids','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','7d4d004a-a8c6-47e5-bb7b-5c536a44a4cf'),(97,'craft','m180521_172900_project_config_table','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','2ceda55f-c33a-4666-b3e3-3a6715ce2341'),(98,'craft','m180521_173000_initial_yml_and_snapshot','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','aa5b34aa-44e2-4517-9929-26bdbbe83332'),(99,'craft','m180731_162030_soft_delete_sites','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','36b55c56-3770-448e-b35e-7ffb497f52b9'),(100,'craft','m180810_214427_soft_delete_field_layouts','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','ce98f3ba-b62c-4006-83e8-cdabf43170f8'),(101,'craft','m180810_214439_soft_delete_elements','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','8e4334fb-dabc-4c39-b345-21df244614fa'),(102,'craft','m180824_193422_case_sensitivity_fixes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','836c140d-7a49-41fc-86ee-042ca14d7a24'),(103,'craft','m180901_151639_fix_matrixcontent_tables','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','8d8cbacd-accd-4a14-8596-87ae31633657'),(104,'craft','m180904_112109_permission_changes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','c6f299b4-2944-4d7d-8836-eb35a3711d8b'),(105,'craft','m180910_142030_soft_delete_sitegroups','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','e8557178-e98e-4707-996a-5173d5903057'),(106,'craft','m181011_160000_soft_delete_asset_support','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','8ea11722-bd18-45c3-9135-62a4dec3100f'),(107,'craft','m181016_183648_set_default_user_settings','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','fd374275-232d-4119-bfc4-6d8121a082f6'),(108,'craft','m181017_225222_system_config_settings','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','eef7d2ca-28e8-4e83-a86e-4bffe19466c8'),(109,'craft','m181018_222343_drop_userpermissions_from_config','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','65af6435-77fb-4b17-a935-db1a6d5f0d8d'),(110,'craft','m181029_130000_add_transforms_routes_to_config','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','096d9ec3-9bfc-49bc-82f7-c4c17565e688'),(111,'craft','m181112_203955_sequences_table','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','20ea2b52-e060-4a13-b8ce-41352e3f045c'),(112,'craft','m181121_001712_cleanup_field_configs','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','bb5b5474-99a8-413a-b244-be3e4957f8ae'),(113,'craft','m181128_193942_fix_project_config','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','f3be2066-0a0a-4559-8424-b4da2a79efcd'),(114,'craft','m181130_143040_fix_schema_version','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','6e8f535b-65d8-48ba-9fb5-1b78e405ad90'),(115,'craft','m181211_143040_fix_entry_type_uids','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','18d5f00e-6f9b-4625-ac48-93076bb49a8b'),(116,'craft','m181217_153000_fix_structure_uids','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','26085567-04df-4b3f-a3e2-4f0bb36631a7'),(117,'craft','m190104_152725_store_licensed_plugin_editions','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','87785ba9-edb4-4bdf-a8e2-1989d9f6263c'),(118,'craft','m190108_110000_cleanup_project_config','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','49fd37d3-dae7-4549-b915-565c8dca7d2c'),(119,'craft','m190108_113000_asset_field_setting_change','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','3a4805c1-5d14-418a-b068-07c1b1f5fadb'),(120,'craft','m190109_172845_fix_colspan','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','d834e63b-6893-4bfa-9ee2-c03d20f6eb09'),(121,'craft','m190110_150000_prune_nonexisting_sites','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','b0ee7eff-7d55-4a1d-9903-61d6e5ff8d10'),(122,'craft','m190110_214819_soft_delete_volumes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','2b48618b-def7-48bb-a6f5-2fa5d45cbe2e'),(123,'craft','m190112_124737_fix_user_settings','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','17cf26d6-c936-4ed3-ba8b-bb8db577a6bd'),(124,'craft','m190112_131225_fix_field_layouts','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','6d973586-4835-48f0-9f6c-cbecb2f74537'),(125,'craft','m190112_201010_more_soft_deletes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','a4174f60-4b91-4042-92aa-673bcdf0e35d'),(126,'craft','m190114_143000_more_asset_field_setting_changes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','bdbdf449-58a9-4b97-b86e-4be09e24f365'),(127,'craft','m190121_120000_rich_text_config_setting','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','618f90da-c81b-4911-8d75-3535297d3c15'),(128,'craft','m190125_191628_fix_email_transport_password','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','d89c1d5e-ab9e-4160-a163-2750b4187319'),(129,'craft','m190128_181422_cleanup_volume_folders','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','a6e3bd31-d47f-4694-9965-b547bb8ca1a0'),(130,'craft','m190205_140000_fix_asset_soft_delete_index','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','2762d1ab-d09b-4f02-af21-33db8dd20e2d'),(131,'craft','m190218_143000_element_index_settings_uid','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','c4448588-c106-460a-b8ac-388251950006'),(132,'craft','m190312_152740_element_revisions','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','05c90318-00a9-4242-99b5-c1662abb2ec9'),(133,'craft','m190327_235137_propagation_method','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','c8b75cb0-3f9d-4aaa-9ee9-1a9d379c1441'),(134,'craft','m190401_223843_drop_old_indexes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','20129b6a-2046-4b63-8a0c-c80f4b8232c4'),(135,'craft','m190416_014525_drop_unique_global_indexes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','db96a878-b197-49a9-9d21-bf3e45319b74'),(136,'craft','m190417_085010_add_image_editor_permissions','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','c81ab7c3-9ded-4164-b112-c78e0ca46205'),(137,'craft','m190502_122019_store_default_user_group_uid','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','6443588b-129b-4d94-8bb0-6d47066fd39f'),(138,'craft','m190504_150349_preview_targets','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','720771b8-78db-4d4e-845d-50b2feb1ba27'),(139,'craft','m190516_184711_job_progress_label','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','edcfc33c-ff8e-41b0-a2bd-ccfb37b1f04f'),(140,'craft','m190523_190303_optional_revision_creators','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','47927ed7-8cd2-4840-bba5-c38c116d3b96'),(141,'craft','m190529_204501_fix_duplicate_uids','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','7bc8225e-024f-462e-b6ec-49cb0176b3d5'),(142,'craft','m190605_223807_unsaved_drafts','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','abf4a73c-31f6-4fff-98ce-f16b3d9a4ec5'),(143,'craft','m190607_230042_entry_revision_error_tables','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','39373e94-fac0-40bb-9456-430dd1b6918b'),(144,'craft','m190608_033429_drop_elements_uid_idx','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','8a2384e7-dd82-479b-ae63-119c677cc875'),(145,'craft','m190617_164400_add_gqlschemas_table','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','06f5a170-a4a5-4548-9c5d-e502c12bd37a'),(146,'craft','m190624_234204_matrix_propagation_method','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','8fae2dcd-c291-4183-a37e-0941b58e0984'),(147,'craft','m190711_153020_drop_snapshots','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','43f588fb-1d41-471b-a73c-c9b82c86f99d'),(148,'craft','m190712_195914_no_draft_revisions','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','e5af7f04-fed7-403b-8d80-1da82aca9958'),(149,'craft','m190723_140314_fix_preview_targets_column','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','bfd991c7-9e7f-4c69-a931-cf2bc3af241e'),(150,'craft','m190820_003519_flush_compiled_templates','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','291d7b6a-2706-4d47-b020-7ae664d40b82'),(151,'craft','m190823_020339_optional_draft_creators','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','4cf978c1-d0ed-4ffd-b13c-bbc109069625'),(152,'craft','m190913_152146_update_preview_targets','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','60960786-8ad3-4b18-bfd7-e6a610467a5b'),(153,'craft','m191107_122000_add_gql_project_config_support','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','fc7a0b7d-f137-40e0-894b-508b697ec693'),(154,'craft','m191204_085100_pack_savable_component_settings','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','eea770cb-5617-4049-a6e7-35dafb7675a2'),(155,'craft','m191206_001148_change_tracking','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','7350f6f3-98ed-4610-a0fa-433d25a1e2ca'),(156,'craft','m191216_191635_asset_upload_tracking','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','599e5446-fec4-4fac-9f6a-2d4db6a08beb'),(157,'craft','m191222_002848_peer_asset_permissions','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','9e30c8eb-0421-4acd-9c50-1e93f81eec98'),(158,'craft','m200127_172522_queue_channels','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','aec0de74-33ec-419a-87d9-47e80a388f2d'),(159,'craft','m200211_175048_truncate_element_query_cache','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','7d5b8959-79df-47fc-be57-f2eec6266fd1'),(160,'craft','m200213_172522_new_elements_index','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','0146d32b-ced2-4320-bb25-33b2982d6a4d'),(161,'craft','m200228_195211_long_deprecation_messages','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','057b095c-94a0-483a-ab8a-09f5267cf448'),(162,'craft','m200306_054652_disabled_sites','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','ff7c9687-f6f9-4cf5-9e78-2b82ea49e87e'),(163,'craft','m200522_191453_clear_template_caches','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','b1229ddd-8c01-4997-89b0-5ff145f67051'),(164,'craft','m200606_231117_migration_tracks','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','8fc17b0e-20f7-4b1a-95a4-f229cb2d7673'),(165,'craft','m200619_215137_title_translation_method','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','3b029e97-48fe-42c0-b580-d5a77adc1605'),(166,'craft','m200620_005028_user_group_descriptions','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','21fce416-36e4-4ee8-88c3-60b87d36a9a9'),(167,'craft','m200620_230205_field_layout_changes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','4ce04482-b2c9-47cd-963c-58c4f2a23137'),(168,'craft','m200625_131100_move_entrytypes_to_top_project_config','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','220775b2-d3ab-4081-bb4c-716b2324a052'),(169,'craft','m200629_112700_remove_project_config_legacy_files','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','ff00a37a-e9a3-4a9e-9fb7-74c189375a53'),(170,'craft','m200630_183000_drop_configmap','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','08bb482e-bf7c-49ea-ae73-d214f4b9c885'),(171,'craft','m200715_113400_transform_index_error_flag','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','3fce3765-7502-4e88-94d6-4b7ec39c8547'),(172,'craft','m200716_110900_replace_file_asset_permissions','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','54c0a4bc-5806-47ee-a63e-9b1cc7dae6ba'),(173,'craft','m200716_153800_public_token_settings_in_project_config','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','d977b463-c449-40a8-86b2-525a3f9ed816'),(174,'craft','m200720_175543_drop_unique_constraints','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','864cf7e5-9cb7-46b9-8df6-97fb4781c3db'),(175,'craft','m200825_051217_project_config_version','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','96c9f66d-afc5-4994-ac2e-01f63a9c32bc'),(176,'craft','m201116_190500_asset_title_translation_method','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','fa6f118a-6948-4ec9-b1c4-8db62a390903'),(177,'craft','m201124_003555_plugin_trials','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','028550f1-cb72-4a75-91a3-8c2079bc48eb'),(178,'craft','m210209_135503_soft_delete_field_groups','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','689a1b47-789a-4a48-84d7-eba799578c8a'),(179,'craft','m210212_223539_delete_invalid_drafts','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','afa8935e-5bd8-44d5-a195-89059e71b689'),(180,'craft','m210214_202731_track_saved_drafts','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','9c465b31-89aa-4973-a30e-20b0edbc5bea'),(181,'craft','m210223_150900_add_new_element_gql_schema_components','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','46f7884f-df26-46ef-92a4-330fb70e0686'),(182,'craft','m210302_212318_canonical_elements','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','82dac694-4125-46bc-9d03-e82f7452bdd9'),(183,'craft','m210326_132000_invalidate_projectconfig_cache','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','40bd847c-25aa-4e84-bcf7-123eb7fefee0'),(184,'craft','m210329_214847_field_column_suffixes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','4f2e5b24-0a89-47cf-9d70-91eaf467e572'),(185,'craft','m210331_220322_null_author','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','bd3f98e4-5e2b-48a0-b8ae-e77765ee62de'),(186,'craft','m210405_231315_provisional_drafts','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','8b937471-a238-4ebf-a37c-3431a818df20'),(187,'craft','m210602_111300_project_config_names_in_config','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','c4bd724f-ea46-47d4-baab-7742c93ac526'),(188,'craft','m210611_233510_default_placement_settings','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','76ae0daa-70f5-417b-ba03-cf183757f043'),(189,'craft','m210613_145522_sortable_global_sets','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','4f27fb99-41ef-409c-883f-dd6d3ccdbc6d'),(190,'craft','m210613_184103_announcements','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','9035fce9-fd3b-432c-9248-0955221f02a7'),(191,'craft','m210829_000000_element_index_tweak','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','88ffff1d-2b36-4ed5-bd72-f880eda48645'),(192,'craft','m220209_095604_add_indexes','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','7de51048-0976-4c33-be40-3e6760339098'),(193,'craft','m220214_000000_truncate_sessions','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','ea717fbe-5727-402e-86ab-cd73dbacebb4'),(194,'craft','m230221_185926_drop_element_fks','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','147abd26-8132-4311-8505-316db2fe191b'),(195,'craft','m230226_013114_drop_plugin_license_columns','2023-05-01 08:06:43','2023-05-01 08:06:43','2023-05-01 08:06:43','eb646f99-0361-40f9-a9f6-1f1d8328c707'),(196,'plugin:postmark','m190220_005730_update_email_settings','2023-05-26 13:49:34','2023-05-26 13:49:34','2023-05-26 13:49:34','e2ab1f59-0513-45d9-bcaf-314fe15fcd0b'),(197,'plugin:postmark','m190727_220415_drop_plugin_settings','2023-05-26 13:49:34','2023-05-26 13:49:34','2023-05-26 13:49:34','e1aa1662-edbf-42e9-af5a-397eab604029'),(198,'craft','m210121_145800_asset_indexing_changes','2023-05-29 04:19:21','2023-05-29 04:19:21','2023-05-29 04:19:21','3ff5bf0c-06bb-43f1-98ea-35ed241b77ad'),(199,'craft','m210624_222934_drop_deprecated_tables','2023-05-29 04:19:21','2023-05-29 04:19:21','2023-05-29 04:19:21','e5faeb7f-d400-4351-a53d-11ec2520cba5'),(200,'craft','m210724_180756_rename_source_cols','2023-05-29 04:19:21','2023-05-29 04:19:21','2023-05-29 04:19:21','fec701ba-c461-4408-aaf0-8758e0c94c7a'),(201,'craft','m210809_124211_remove_superfluous_uids','2023-05-29 04:19:21','2023-05-29 04:19:21','2023-05-29 04:19:21','a896ad37-0c95-409c-be23-5e12f01ba87a'),(202,'craft','m210817_014201_universal_users','2023-05-29 04:19:21','2023-05-29 04:19:21','2023-05-29 04:19:21','968b9ada-9cd9-447b-90de-74694a510493'),(203,'craft','m210904_132612_store_element_source_settings_in_project_config','2023-05-29 04:19:21','2023-05-29 04:19:21','2023-05-29 04:19:21','347285bb-4062-485f-b204-5fc34b2307aa'),(204,'craft','m211115_135500_image_transformers','2023-05-29 04:19:21','2023-05-29 04:19:21','2023-05-29 04:19:21','6e74271f-aee8-45ef-b592-2a92e6f0ed20'),(205,'craft','m211201_131000_filesystems','2023-05-29 04:19:21','2023-05-29 04:19:21','2023-05-29 04:19:21','785e420c-7136-45ea-9508-010f332b8638'),(206,'craft','m220103_043103_tab_conditions','2023-05-29 04:19:21','2023-05-29 04:19:21','2023-05-29 04:19:21','c1438fb3-1542-45da-b154-2aed6c7d6c20'),(207,'craft','m220104_003433_asset_alt_text','2023-05-29 04:19:21','2023-05-29 04:19:21','2023-05-29 04:19:21','a731548c-2f31-4ce7-915b-33e762a89b77'),(208,'craft','m220123_213619_update_permissions','2023-05-29 04:19:21','2023-05-29 04:19:21','2023-05-29 04:19:21','2fa75859-5666-4937-a331-f476bcf1f5b1'),(209,'craft','m220126_003432_addresses','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','fdbdb6e0-c8cb-4a18-b024-5561e691a959'),(210,'craft','m220213_015220_matrixblocks_owners_table','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','b62cd2ad-26a6-4577-bf9f-f9d322f484f7'),(211,'craft','m220222_122159_full_names','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','b11ebbc2-3797-4c4f-9b16-8c55e9df20ca'),(212,'craft','m220223_180559_nullable_address_owner','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','3c763b2e-1f0f-4b71-8e0c-47e334cb7aab'),(213,'craft','m220225_165000_transform_filesystems','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','0c1f3cea-7eb1-41b3-85a9-b6513b67e843'),(214,'craft','m220309_152006_rename_field_layout_elements','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','c41ba40e-5b11-4698-89bd-2688f63e799c'),(215,'craft','m220314_211928_field_layout_element_uids','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','ba4a98dc-dbb9-4e02-95f5-7190000a199a'),(216,'craft','m220316_123800_transform_fs_subpath','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','85245d8c-2409-445d-93fb-577748bb8607'),(217,'craft','m220317_174250_release_all_jobs','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','812a85bd-ff09-48a6-82fc-026b5d942ddb'),(218,'craft','m220330_150000_add_site_gql_schema_components','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','dadc72ce-275f-4377-9d2c-d78f43ecb521'),(219,'craft','m220413_024536_site_enabled_string','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','e09e7cff-c585-447c-9919-679bb97a7277'),(220,'craft','m221027_160703_add_image_transform_fill','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','a64799af-8384-42c7-b806-5e66e8dfef92'),(221,'craft','m221028_130548_add_canonical_id_index','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','8f985993-9ae3-4a16-a85a-7a2721b4e729'),(222,'craft','m221118_003031_drop_element_fks','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','0e1c4948-aa1f-411c-a754-0b75e314a790'),(223,'craft','m230131_120713_asset_indexing_session_new_options','2023-05-29 04:19:22','2023-05-29 04:19:22','2023-05-29 04:19:22','f9dea7d7-95af-472e-86ff-84c282bfd84a'),(224,'plugin:redactor','m180430_204710_remove_old_plugins','2023-05-30 03:14:16','2023-05-30 03:14:16','2023-05-30 03:14:16','77a23369-06bb-440e-ac52-bab9f44fe207'),(225,'plugin:redactor','Install','2023-05-30 03:14:16','2023-05-30 03:14:16','2023-05-30 03:14:16','0b98b411-b275-4874-8072-52871ce4fd01'),(226,'plugin:redactor','m190225_003922_split_cleanup_html_settings','2023-05-30 03:14:16','2023-05-30 03:14:16','2023-05-30 03:14:16','b30d84f4-d9c1-4ee2-b149-c5277ead210e');
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `plugins`
--

LOCK TABLES `plugins` WRITE;
/*!40000 ALTER TABLE `plugins` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `plugins` VALUES (1,'postmark','3.0.0','2.0.1','2023-05-26 13:49:34','2023-05-26 13:49:34','2023-05-29 08:31:16','6f25ce64-565d-49d4-a9ba-3daa6f37badb'),(2,'contact-form','3.0.1','1.0.0','2023-05-29 08:38:38','2023-05-29 08:38:38','2023-05-29 08:38:38','a9882526-7df0-4d6c-8a8d-98497da29aab'),(3,'redactor','3.0.4','2.3.0','2023-05-30 03:14:16','2023-05-30 03:14:16','2023-05-30 03:14:16','11c56e61-2d39-4e7b-be76-1e1444c34e24');
/*!40000 ALTER TABLE `plugins` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `projectconfig`
--

LOCK TABLES `projectconfig` WRITE;
/*!40000 ALTER TABLE `projectconfig` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `projectconfig` VALUES ('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.defaultPlacement','\"beginning\"'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elementCondition','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.autocapitalize','true'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.autocomplete','false'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.autocorrect','true'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.class','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.disabled','false'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.elementCondition','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.id','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.instructions','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.label','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.max','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.min','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.name','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.orientation','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.placeholder','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.readonly','false'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.requirable','false'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.size','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.step','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.tip','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.title','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\TitleField\"'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.uid','\"490a79e5-dd3c-4302-a6e7-86efc1d94a2e\"'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.userCondition','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.warning','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.elements.0.width','100'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.name','\"Content\"'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.uid','\"8efd4cf6-afe7-460f-8c47-7229c665c9b9\"'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.fieldLayouts.74d78374-2b4c-4645-aaae-ae2236fb6266.tabs.0.userCondition','null'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.handle','\"propertyType\"'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.name','\"Property Type\"'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.hasUrls','true'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.template','\"property\\\\index-type\"'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.uriFormat','\"property/index-type/{slug}\"'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.structure.maxLevels','1'),('categoryGroups.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0.structure.uid','\"4b84aca1-5c3b-4db3-afa6-a124f936d98b\"'),('dateModified','1685417070'),('email.fromEmail','\"postmaster@wesvault.com\"'),('email.fromName','\"WV Craft Demo\"'),('email.replyToEmail','null'),('email.template','null'),('email.transportSettings.messageStream','\"outbound\"'),('email.transportSettings.token','\"db4ca69e-a9f1-4be1-bccb-7f6b461099df\"'),('email.transportType','\"craftcms\\\\postmark\\\\Adapter\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elementCondition','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.autocapitalize','true'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.autocomplete','false'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.autocorrect','true'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.class','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.disabled','false'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.elementCondition','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.id','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.instructions','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.label','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.max','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.min','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.name','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.orientation','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.placeholder','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.readonly','false'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.requirable','false'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.size','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.step','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.tip','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.title','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.uid','\"618d18a6-fbb1-430e-b3a1-605fef4fab88\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.userCondition','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.warning','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.0.width','100'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.1.elementCondition','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.1.fieldUid','\"5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.1.instructions','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.1.label','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.1.required','false'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.1.tip','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.1.uid','\"20a7d9b7-6d6d-479f-9fab-8bbfed93e512\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.1.userCondition','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.1.warning','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.1.width','100'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.2.elementCondition','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.2.fieldUid','\"129a2365-4f74-4b64-9d3b-8a60b312f848\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.2.instructions','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.2.label','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.2.required','false'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.2.tip','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.2.uid','\"8d5a8e2a-8913-4146-89a2-155418535bd4\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.2.userCondition','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.2.warning','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.elements.2.width','100'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.name','\"Content\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.uid','\"32fdc493-98c1-45eb-9605-ade39195c830\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.fieldLayouts.98c9827c-5472-4a6b-8f8f-7d0d3e2d993b.tabs.0.userCondition','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.handle','\"home\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.hasTitleField','false'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.name','\"Home\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.section','\"f308ed4b-53b7-4442-8b5e-53b14988a4eb\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.sortOrder','1'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.titleFormat','\"{section.name|raw}\"'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.titleTranslationKeyFormat','null'),('entryTypes.20b3a2cc-928b-4f67-a9e9-b871c7e9356d.titleTranslationMethod','\"site\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elementCondition','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.autocapitalize','true'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.autocomplete','false'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.autocorrect','true'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.class','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.disabled','false'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.elementCondition','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.id','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.instructions','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.label','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.max','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.min','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.name','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.orientation','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.placeholder','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.readonly','false'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.requirable','false'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.size','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.step','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.tip','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.title','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.uid','\"7f4ae5ef-e1a6-4393-b21d-1eea4c027f8f\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.userCondition','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.warning','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.0.width','100'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.1.elementCondition','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.1.fieldUid','\"eaa73a01-56ea-40be-971b-c3968933d7c2\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.1.instructions','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.1.label','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.1.required','false'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.1.tip','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.1.uid','\"daf9bacc-8ead-4504-9e3c-5244d71d7fc6\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.1.userCondition','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.1.warning','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.1.width','100'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.2.elementCondition','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.2.fieldUid','\"43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.2.instructions','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.2.label','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.2.required','false'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.2.tip','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.2.uid','\"f5dc7358-09e8-4aba-bf1a-ea6a227d888b\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.2.userCondition','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.2.warning','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.2.width','100'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.3.elementCondition','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.3.fieldUid','\"258870ed-da63-4941-99fc-19c9dc65839f\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.3.instructions','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.3.label','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.3.required','false'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.3.tip','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.3.uid','\"d11c8c5f-8aa7-4992-87c0-d5a5db276260\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.3.userCondition','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.3.warning','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.3.width','100'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.4.elementCondition','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.4.fieldUid','\"88838aab-9a64-4025-a386-09dead7c61bf\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.4.instructions','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.4.label','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.4.required','false'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.4.tip','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.4.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.4.uid','\"1f4f2aa8-cd42-4d72-847f-e246f74e22a0\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.4.userCondition','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.4.warning','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.4.width','100'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.5.elementCondition','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.5.fieldUid','\"13ce2fa8-244a-4066-bcba-1a49014748c1\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.5.instructions','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.5.label','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.5.required','false'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.5.tip','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.5.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.5.uid','\"5d1f4896-4385-47ed-a94e-4b027195e527\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.5.userCondition','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.5.warning','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.elements.5.width','100'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.name','\"Content\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.uid','\"20f280c0-0245-46ce-9ae7-cbf96e9fc975\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.fieldLayouts.20c6814f-67ef-4096-aae6-8d176bf9ef02.tabs.0.userCondition','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.handle','\"normalProperty\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.hasTitleField','true'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.name','\"Normal Property\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.section','\"f4222736-b675-492e-bddc-9eba68ec2eca\"'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.sortOrder','2'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.titleFormat','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.titleTranslationKeyFormat','null'),('entryTypes.7f071c0f-0498-4c4d-9237-5c1652b7803f.titleTranslationMethod','\"site\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elementCondition','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.autocapitalize','true'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.autocomplete','false'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.autocorrect','true'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.class','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.disabled','false'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.elementCondition','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.id','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.instructions','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.label','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.max','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.min','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.name','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.orientation','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.placeholder','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.readonly','false'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.requirable','false'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.size','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.step','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.tip','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.title','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.uid','\"519b15da-1acf-43f8-a944-9ba24ea7f5ef\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.userCondition','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.warning','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.0.width','100'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.1.elementCondition','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.1.fieldUid','\"8cb71acd-feff-4ee0-b731-711439a5773d\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.1.instructions','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.1.label','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.1.required','false'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.1.tip','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.1.uid','\"548d02e0-1056-4325-8ef8-df412281096d\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.1.userCondition','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.1.warning','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.1.width','100'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.2.elementCondition','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.2.fieldUid','\"3268c203-ca86-4709-89af-bf5f18dd6b0c\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.2.instructions','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.2.label','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.2.required','false'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.2.tip','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.2.uid','\"b6b02c84-02aa-41e2-8da0-e1ddd00f86c0\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.2.userCondition','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.2.warning','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.elements.2.width','100'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.name','\"Content\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.uid','\"b2a54dd9-fe8a-4d66-94e8-18bfc983c817\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.fieldLayouts.1a56c455-3e11-47d9-88c6-d87fc9fe930c.tabs.0.userCondition','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.handle','\"about\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.hasTitleField','false'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.name','\"About\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.section','\"08167144-d72f-4247-a8c1-4d6efa693bb9\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.sortOrder','1'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.titleFormat','\"{section.name|raw}\"'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.titleTranslationKeyFormat','null'),('entryTypes.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d.titleTranslationMethod','\"site\"'),('fieldGroups.3ba498a1-6662-447d-859f-64de252b31b8.name','\"Common\"'),('fieldGroups.c65b609c-c051-4a11-b7cf-270031689a67.name','\"Home\"'),('fieldGroups.ff5bce1f-d6a8-4b4a-9b65-9c80a3c7df94.name','\"property\"'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.columnSuffix','null'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.contentColumnType','\"string\"'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.fieldGroup','\"c65b609c-c051-4a11-b7cf-270031689a67\"'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.handle','\"heroImages\"'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.instructions','\"The hero pictures in the background \"'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.name','\"hero images\"'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.searchable','false'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.allowedKinds','null'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.allowSelfRelations','false'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.allowSubfolders','false'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.allowUploads','true'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.branchLimit','null'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.defaultUploadLocationSource','\"volume:79a24291-0544-4c50-913c-9dda4ee5656e\"'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.defaultUploadLocationSubpath','\"/home/hero\"'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.localizeRelations','false'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.maintainHierarchy','false'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.maxRelations','5'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.minRelations','null'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.previewMode','\"full\"'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.restrictedDefaultUploadSubpath','null'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.restrictedLocationSource','\"volume:79a24291-0544-4c50-913c-9dda4ee5656e\"'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.restrictedLocationSubpath','null'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.restrictFiles','false'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.restrictLocation','false'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.selectionLabel','\"Select\"'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.showSiteMenu','false'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.showUnpermittedFiles','false'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.showUnpermittedVolumes','false'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.sources.0','\"volume:79a24291-0544-4c50-913c-9dda4ee5656e\"'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.targetSiteId','null'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.validateRelatedElements','false'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.settings.viewMode','\"list\"'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.translationKeyFormat','null'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.translationMethod','\"site\"'),('fields.129a2365-4f74-4b64-9d3b-8a60b312f848.type','\"craft\\\\fields\\\\Assets\"'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.columnSuffix','null'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.contentColumnType','\"string\"'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.fieldGroup','\"ff5bce1f-d6a8-4b4a-9b65-9c80a3c7df94\"'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.handle','\"pictures\"'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.instructions','\"Pictures of the property\"'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.name','\"pictures\"'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.searchable','false'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.allowedKinds','null'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.allowSelfRelations','false'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.allowSubfolders','false'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.allowUploads','true'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.branchLimit','null'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.defaultUploadLocationSource','\"volume:79a24291-0544-4c50-913c-9dda4ee5656e\"'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.defaultUploadLocationSubpath','\"property/slug\"'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.localizeRelations','false'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.maintainHierarchy','false'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.maxRelations','null'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.minRelations','null'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.previewMode','\"full\"'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.restrictedDefaultUploadSubpath','null'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.restrictedLocationSource','\"volume:79a24291-0544-4c50-913c-9dda4ee5656e\"'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.restrictedLocationSubpath','null'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.restrictFiles','false'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.restrictLocation','false'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.selectionLabel','null'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.showSiteMenu','false'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.showUnpermittedFiles','false'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.showUnpermittedVolumes','false'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.sources','\"*\"'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.targetSiteId','null'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.validateRelatedElements','false'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.settings.viewMode','\"list\"'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.translationKeyFormat','null'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.translationMethod','\"site\"'),('fields.13ce2fa8-244a-4066-bcba-1a49014748c1.type','\"craft\\\\fields\\\\Assets\"'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.columnSuffix','\"nyrarqel\"'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.contentColumnType','\"text\"'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.fieldGroup','\"ff5bce1f-d6a8-4b4a-9b65-9c80a3c7df94\"'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.handle','\"state\"'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.instructions','\"The state\"'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.name','\"State\"'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.searchable','false'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.settings.byteLimit','null'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.settings.charLimit','null'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.settings.code','false'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.settings.columnType','null'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.settings.initialRows','4'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.settings.multiline','false'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.settings.placeholder','null'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.settings.uiMode','\"normal\"'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.translationKeyFormat','null'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.translationMethod','\"none\"'),('fields.258870ed-da63-4941-99fc-19c9dc65839f.type','\"craft\\\\fields\\\\PlainText\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.columnSuffix','null'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.contentColumnType','\"string\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.fieldGroup','\"3ba498a1-6662-447d-859f-64de252b31b8\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.handle','\"mainImage\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.instructions','null'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.name','\"mainImage\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.searchable','false'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.allowedKinds','null'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.allowSelfRelations','false'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.allowSubfolders','false'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.allowUploads','true'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.branchLimit','null'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.defaultUploadLocationSource','\"volume:79a24291-0544-4c50-913c-9dda4ee5656e\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.defaultUploadLocationSubpath','\"common\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.localizeRelations','false'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.maintainHierarchy','false'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.maxRelations','1'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.minRelations','1'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.previewMode','\"full\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.restrictedDefaultUploadSubpath','null'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.restrictedLocationSource','\"volume:79a24291-0544-4c50-913c-9dda4ee5656e\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.restrictedLocationSubpath','null'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.restrictFiles','false'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.restrictLocation','false'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.selectionCondition.__assoc__.0.0','\"elementType\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.selectionCondition.__assoc__.0.1','\"craft\\\\elements\\\\Asset\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.selectionCondition.__assoc__.1.0','\"fieldContext\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.selectionCondition.__assoc__.1.1','\"global\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.selectionCondition.__assoc__.2.0','\"class\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.selectionCondition.__assoc__.2.1','\"craft\\\\elements\\\\conditions\\\\assets\\\\AssetCondition\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.selectionLabel','null'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.showSiteMenu','false'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.showUnpermittedFiles','false'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.showUnpermittedVolumes','false'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.sources','\"*\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.targetSiteId','null'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.validateRelatedElements','false'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.settings.viewMode','\"list\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.translationKeyFormat','null'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.translationMethod','\"site\"'),('fields.3268c203-ca86-4709-89af-bf5f18dd6b0c.type','\"craft\\\\fields\\\\Assets\"'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.columnSuffix','\"hedotwnu\"'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.contentColumnType','\"integer(10)\"'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.fieldGroup','\"ff5bce1f-d6a8-4b4a-9b65-9c80a3c7df94\"'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.handle','\"price\"'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.instructions','\"Price In thousands\"'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.name','\"price\"'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.searchable','false'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.settings.decimals','0'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.settings.defaultValue','null'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.settings.max','null'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.settings.min','null'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.settings.prefix','null'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.settings.previewCurrency','null'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.settings.previewFormat','\"decimal\"'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.settings.size','null'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.settings.suffix','null'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.translationKeyFormat','null'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.translationMethod','\"none\"'),('fields.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb.type','\"craft\\\\fields\\\\Number\"'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.columnSuffix','\"dcwxekih\"'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.contentColumnType','\"string(600)\"'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.fieldGroup','\"3ba498a1-6662-447d-859f-64de252b31b8\"'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.handle','\"homeTitle\"'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.instructions','\"Title On the Top of Hero Box\"'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.name','\"Home Title\"'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.searchable','false'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.settings.byteLimit','null'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.settings.charLimit','150'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.settings.code','false'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.settings.columnType','null'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.settings.initialRows','2'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.settings.multiline','true'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.settings.placeholder','\"Easiest Way to Find Your Dream Home\"'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.settings.uiMode','\"normal\"'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.translationKeyFormat','null'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.translationMethod','\"none\"'),('fields.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b.type','\"craft\\\\fields\\\\PlainText\"'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.columnSuffix','\"fixdfhog\"'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.contentColumnType','\"text\"'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.fieldGroup','\"ff5bce1f-d6a8-4b4a-9b65-9c80a3c7df94\"'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.handle','\"suburb\"'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.instructions','null'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.name','\"Suburb\"'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.searchable','false'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.settings.byteLimit','null'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.settings.charLimit','null'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.settings.code','false'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.settings.columnType','null'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.settings.initialRows','4'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.settings.multiline','false'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.settings.placeholder','null'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.settings.uiMode','\"normal\"'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.translationKeyFormat','null'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.translationMethod','\"none\"'),('fields.88838aab-9a64-4025-a386-09dead7c61bf.type','\"craft\\\\fields\\\\PlainText\"'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.columnSuffix','\"idddvzgl\"'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.contentColumnType','\"text\"'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.fieldGroup','\"3ba498a1-6662-447d-859f-64de252b31b8\"'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.handle','\"mainText\"'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.instructions','null'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.name','\"mainText\"'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.searchable','false'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.availableTransforms','\"*\"'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.availableVolumes','\"*\"'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.columnType','\"text\"'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.configSelectionMode','\"choose\"'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.defaultTransform','\"\"'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.manualConfig','\"\"'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.purifierConfig','null'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.purifyHtml','true'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.redactorConfig','null'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.removeEmptyTags','false'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.removeInlineStyles','false'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.removeNbsp','false'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.showHtmlButtonForNonAdmins','false'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.showUnpermittedFiles','false'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.showUnpermittedVolumes','false'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.settings.uiMode','\"enlarged\"'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.translationKeyFormat','null'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.translationMethod','\"none\"'),('fields.8cb71acd-feff-4ee0-b731-711439a5773d.type','\"craft\\\\redactor\\\\Field\"'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.columnSuffix','null'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.contentColumnType','\"string\"'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.fieldGroup','\"ff5bce1f-d6a8-4b4a-9b65-9c80a3c7df94\"'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.handle','\"propertyType\"'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.instructions','\"Type of Property\"'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.name','\"Property Type\"'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.searchable','false'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.settings.allowSelfRelations','false'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.settings.branchLimit','null'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.settings.localizeRelations','false'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.settings.maintainHierarchy','false'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.settings.maxRelations','1'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.settings.minRelations','1'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.settings.selectionLabel','null'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.settings.showSiteMenu','true'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.settings.source','\"group:9ca8966f-b6f7-4cf9-acf9-401ac6a384d0\"'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.settings.targetSiteId','null'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.settings.validateRelatedElements','false'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.settings.viewMode','null'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.translationKeyFormat','null'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.translationMethod','\"site\"'),('fields.eaa73a01-56ea-40be-971b-c3968933d7c2.type','\"craft\\\\fields\\\\Categories\"'),('fs.siteImages.hasUrls','true'),('fs.siteImages.name','\"site images\"'),('fs.siteImages.settings.path','\"@webroot/site-images\"'),('fs.siteImages.type','\"craft\\\\fs\\\\Local\"'),('fs.siteImages.url','\"@web/site-images\"'),('graphql.publicToken.enabled','false'),('graphql.publicToken.expiryDate','null'),('imageTransforms.f79cb78d-6246-447e-82bf-cd55d2e2f18a.fill','null'),('imageTransforms.f79cb78d-6246-447e-82bf-cd55d2e2f18a.format','\"webp\"'),('imageTransforms.f79cb78d-6246-447e-82bf-cd55d2e2f18a.handle','\"resizeTo400Webp\"'),('imageTransforms.f79cb78d-6246-447e-82bf-cd55d2e2f18a.height','325'),('imageTransforms.f79cb78d-6246-447e-82bf-cd55d2e2f18a.interlace','\"none\"'),('imageTransforms.f79cb78d-6246-447e-82bf-cd55d2e2f18a.mode','\"crop\"'),('imageTransforms.f79cb78d-6246-447e-82bf-cd55d2e2f18a.name','\"Resize to 400 webp\"'),('imageTransforms.f79cb78d-6246-447e-82bf-cd55d2e2f18a.position','\"center-center\"'),('imageTransforms.f79cb78d-6246-447e-82bf-cd55d2e2f18a.quality','null'),('imageTransforms.f79cb78d-6246-447e-82bf-cd55d2e2f18a.upscale','true'),('imageTransforms.f79cb78d-6246-447e-82bf-cd55d2e2f18a.width','400'),('meta.__names__.035bb8ef-8937-4a8a-806e-9c0a82a9a301','\"Public Schema\"'),('meta.__names__.08167144-d72f-4247-a8c1-4d6efa693bb9','\"About\"'),('meta.__names__.129a2365-4f74-4b64-9d3b-8a60b312f848','\"hero images\"'),('meta.__names__.13ce2fa8-244a-4066-bcba-1a49014748c1','\"pictures\"'),('meta.__names__.1874dee1-77b1-41b0-a203-23ef8669eb55','\"WV Craft Demo\"'),('meta.__names__.20b3a2cc-928b-4f67-a9e9-b871c7e9356d','\"Home\"'),('meta.__names__.258870ed-da63-4941-99fc-19c9dc65839f','\"State\"'),('meta.__names__.3268c203-ca86-4709-89af-bf5f18dd6b0c','\"mainImage\"'),('meta.__names__.3ba498a1-6662-447d-859f-64de252b31b8','\"Common\"'),('meta.__names__.43e81a5a-8616-4c96-8c9d-ec6c77f2c5bb','\"price\"'),('meta.__names__.5428e098-3c0b-4af2-8ca3-b73d1bf5eb9b','\"Home Title\"'),('meta.__names__.712c24dd-d034-4b61-9ba8-d0254aacfc9d','\"Public Schema\"'),('meta.__names__.79a24291-0544-4c50-913c-9dda4ee5656e','\"site images\"'),('meta.__names__.7f071c0f-0498-4c4d-9237-5c1652b7803f','\"Normal Property\"'),('meta.__names__.88838aab-9a64-4025-a386-09dead7c61bf','\"Suburb\"'),('meta.__names__.8cb71acd-feff-4ee0-b731-711439a5773d','\"mainText\"'),('meta.__names__.9ca8966f-b6f7-4cf9-acf9-401ac6a384d0','\"Property Type\"'),('meta.__names__.c65b609c-c051-4a11-b7cf-270031689a67','\"Home\"'),('meta.__names__.cd8a9b25-b028-41f5-a1fb-9b9598d38b4d','\"About\"'),('meta.__names__.cf3c3607-490b-445f-baab-1d99ba9bb49c','\"WV Craft Demo\"'),('meta.__names__.eaa73a01-56ea-40be-971b-c3968933d7c2','\"Property Type\"'),('meta.__names__.f308ed4b-53b7-4442-8b5e-53b14988a4eb','\"Home\"'),('meta.__names__.f4222736-b675-492e-bddc-9eba68ec2eca','\"property\"'),('meta.__names__.f79cb78d-6246-447e-82bf-cd55d2e2f18a','\"Resize to 400 webp\"'),('meta.__names__.ff5bce1f-d6a8-4b4a-9b65-9c80a3c7df94','\"property\"'),('plugins.contact-form.edition','\"standard\"'),('plugins.contact-form.enabled','true'),('plugins.contact-form.schemaVersion','\"1.0.0\"'),('plugins.contact-form.settings.allowAttachments','\"\"'),('plugins.contact-form.settings.allowedMessageFields','null'),('plugins.contact-form.settings.prependSender','\"On behalf of\"'),('plugins.contact-form.settings.prependSubject','\"New message from WV Craft Demo\"'),('plugins.contact-form.settings.successFlashMessage','\"Your message has been sent.\"'),('plugins.contact-form.settings.toEmail','\"auzadventure@gmail.com\"'),('plugins.postmark.edition','\"standard\"'),('plugins.postmark.enabled','true'),('plugins.postmark.schemaVersion','\"2.0.1\"'),('plugins.redactor.edition','\"standard\"'),('plugins.redactor.enabled','true'),('plugins.redactor.schemaVersion','\"2.3.0\"'),('sections.08167144-d72f-4247-a8c1-4d6efa693bb9.defaultPlacement','\"end\"'),('sections.08167144-d72f-4247-a8c1-4d6efa693bb9.enableVersioning','true'),('sections.08167144-d72f-4247-a8c1-4d6efa693bb9.handle','\"about\"'),('sections.08167144-d72f-4247-a8c1-4d6efa693bb9.name','\"About\"'),('sections.08167144-d72f-4247-a8c1-4d6efa693bb9.propagationMethod','\"all\"'),('sections.08167144-d72f-4247-a8c1-4d6efa693bb9.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.enabledByDefault','true'),('sections.08167144-d72f-4247-a8c1-4d6efa693bb9.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.hasUrls','true'),('sections.08167144-d72f-4247-a8c1-4d6efa693bb9.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.template','\"about.twig\"'),('sections.08167144-d72f-4247-a8c1-4d6efa693bb9.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.uriFormat','\"about\"'),('sections.08167144-d72f-4247-a8c1-4d6efa693bb9.type','\"single\"'),('sections.f308ed4b-53b7-4442-8b5e-53b14988a4eb.defaultPlacement','\"end\"'),('sections.f308ed4b-53b7-4442-8b5e-53b14988a4eb.enableVersioning','true'),('sections.f308ed4b-53b7-4442-8b5e-53b14988a4eb.handle','\"home\"'),('sections.f308ed4b-53b7-4442-8b5e-53b14988a4eb.name','\"Home\"'),('sections.f308ed4b-53b7-4442-8b5e-53b14988a4eb.propagationMethod','\"all\"'),('sections.f308ed4b-53b7-4442-8b5e-53b14988a4eb.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.enabledByDefault','true'),('sections.f308ed4b-53b7-4442-8b5e-53b14988a4eb.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.hasUrls','true'),('sections.f308ed4b-53b7-4442-8b5e-53b14988a4eb.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.template','\"_index\"'),('sections.f308ed4b-53b7-4442-8b5e-53b14988a4eb.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.uriFormat','\"__home__\"'),('sections.f308ed4b-53b7-4442-8b5e-53b14988a4eb.type','\"single\"'),('sections.f4222736-b675-492e-bddc-9eba68ec2eca.defaultPlacement','\"end\"'),('sections.f4222736-b675-492e-bddc-9eba68ec2eca.enableVersioning','true'),('sections.f4222736-b675-492e-bddc-9eba68ec2eca.handle','\"property\"'),('sections.f4222736-b675-492e-bddc-9eba68ec2eca.name','\"property\"'),('sections.f4222736-b675-492e-bddc-9eba68ec2eca.propagationMethod','\"all\"'),('sections.f4222736-b675-492e-bddc-9eba68ec2eca.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.enabledByDefault','true'),('sections.f4222736-b675-492e-bddc-9eba68ec2eca.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.hasUrls','true'),('sections.f4222736-b675-492e-bddc-9eba68ec2eca.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.template','\"property/_entry\"'),('sections.f4222736-b675-492e-bddc-9eba68ec2eca.siteSettings.1874dee1-77b1-41b0-a203-23ef8669eb55.uriFormat','\"property/{slug}\"'),('sections.f4222736-b675-492e-bddc-9eba68ec2eca.structure.maxLevels','1'),('sections.f4222736-b675-492e-bddc-9eba68ec2eca.structure.uid','\"3fb6e08f-25dc-4a7f-b1fd-242fd0c53b25\"'),('sections.f4222736-b675-492e-bddc-9eba68ec2eca.type','\"structure\"'),('siteGroups.cf3c3607-490b-445f-baab-1d99ba9bb49c.name','\"WV Craft Demo\"'),('sites.1874dee1-77b1-41b0-a203-23ef8669eb55.baseUrl','\"$PRIMARY_SITE_URL\"'),('sites.1874dee1-77b1-41b0-a203-23ef8669eb55.enabled','true'),('sites.1874dee1-77b1-41b0-a203-23ef8669eb55.handle','\"default\"'),('sites.1874dee1-77b1-41b0-a203-23ef8669eb55.hasUrls','true'),('sites.1874dee1-77b1-41b0-a203-23ef8669eb55.language','\"en-US\"'),('sites.1874dee1-77b1-41b0-a203-23ef8669eb55.name','\"WV Craft Demo\"'),('sites.1874dee1-77b1-41b0-a203-23ef8669eb55.primary','true'),('sites.1874dee1-77b1-41b0-a203-23ef8669eb55.siteGroup','\"cf3c3607-490b-445f-baab-1d99ba9bb49c\"'),('sites.1874dee1-77b1-41b0-a203-23ef8669eb55.sortOrder','1'),('system.edition','\"solo\"'),('system.live','true'),('system.name','\"WV Craft Demo\"'),('system.schemaVersion','\"4.4.0.4\"'),('system.timeZone','\"America/Los_Angeles\"'),('users.allowPublicRegistration','false'),('users.deactivateByDefault','false'),('users.defaultGroup','null'),('users.photoSubpath','null'),('users.photoVolumeUid','null'),('users.requireEmailVerification','true'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elementCondition','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.autocapitalize','true'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.autocomplete','false'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.autocorrect','true'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.class','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.disabled','false'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.elementCondition','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.id','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.instructions','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.label','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.max','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.min','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.name','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.orientation','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.placeholder','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.readonly','false'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.requirable','false'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.size','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.step','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.tip','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.title','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\assets\\\\AssetTitleField\"'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.uid','\"62714ae2-9c9f-4805-8e32-99f93ffb9bea\"'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.userCondition','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.warning','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.elements.0.width','100'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.name','\"Content\"'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.uid','\"4c16f436-a6f9-4b54-aece-6394a47c0342\"'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fieldLayouts.dc408bb2-f08d-463a-9243-60d07dccb177.tabs.0.userCondition','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.fs','\"siteImages\"'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.handle','\"siteImages\"'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.name','\"site images\"'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.sortOrder','1'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.titleTranslationKeyFormat','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.titleTranslationMethod','\"site\"'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.transformFs','null'),('volumes.79a24291-0544-4c50-913c-9dda4ee5656e.transformSubpath','\"\"');
/*!40000 ALTER TABLE `projectconfig` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `queue`
--

LOCK TABLES `queue` WRITE;
/*!40000 ALTER TABLE `queue` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `queue` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `relations`
--

LOCK TABLES `relations` WRITE;
/*!40000 ALTER TABLE `relations` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `relations` VALUES (4,2,2,NULL,10,2,'2023-05-05 15:34:35','2023-05-05 15:39:30','7d2f4d55-156b-4af7-8f44-3e91bd5cbade'),(5,2,2,NULL,11,1,'2023-05-05 15:34:35','2023-05-05 15:39:30','08f6062f-cff7-4bad-9f4a-5ab90d2143b1'),(6,2,2,NULL,12,3,'2023-05-05 15:34:35','2023-05-05 15:34:35','5fb160c0-af8e-41e7-85fe-33064c43124a'),(7,2,13,NULL,10,1,'2023-05-05 15:34:35','2023-05-05 15:34:35','7fd14378-444c-4fcd-8bb2-fb09dc76e570'),(8,2,13,NULL,11,2,'2023-05-05 15:34:35','2023-05-05 15:34:35','7ec2b23f-ca31-41bb-a766-5982408674c4'),(9,2,13,NULL,12,3,'2023-05-05 15:34:35','2023-05-05 15:34:35','4e92ae44-29fb-4664-b6c4-9f3ccc829d58'),(13,2,15,NULL,11,1,'2023-05-05 15:39:30','2023-05-05 15:39:30','3abacf87-0580-409e-9f33-b2f61f6b01bb'),(14,2,15,NULL,10,2,'2023-05-05 15:39:30','2023-05-05 15:39:30','61a5bc85-8c40-49af-bffa-5fc64a16b1e9'),(15,2,15,NULL,12,3,'2023-05-05 15:39:30','2023-05-05 15:39:30','03e6f186-68ec-49d9-a40d-1d59047c0816'),(16,2,16,NULL,11,1,'2023-05-05 15:41:47','2023-05-05 15:41:47','334dc005-db7e-4994-ba93-ce0f7e74db26'),(17,2,16,NULL,10,2,'2023-05-05 15:41:47','2023-05-05 15:41:47','b7e004a9-b0bd-4eec-a0b4-5ecaaa958909'),(18,2,16,NULL,12,3,'2023-05-05 15:41:47','2023-05-05 15:41:47','a1288ecf-b7a6-4c5a-9df6-79a117a36344'),(19,3,21,NULL,22,1,'2023-05-05 16:35:52','2023-05-05 16:35:52','fb378e50-abd0-4fab-aacb-8f18014b8951'),(20,3,23,NULL,22,1,'2023-05-06 13:13:47','2023-05-06 13:13:47','690ac811-be0a-4673-ae73-275566137331'),(21,3,24,NULL,25,1,'2023-05-06 13:19:23','2023-05-06 13:19:23','c8df165c-aee3-44f8-8d3d-3280351cdbff'),(22,3,26,NULL,25,1,'2023-05-06 13:19:40','2023-05-06 13:19:40','405a4838-411a-4bf1-930b-03bf0bbfe4ad'),(23,3,27,NULL,22,1,'2023-05-06 13:28:03','2023-05-06 13:28:03','a7f65f59-7213-40ac-b8d7-920725a297fe'),(25,3,29,NULL,22,1,'2023-05-06 13:29:56','2023-05-06 13:29:56','85869b6c-a2bb-47df-a317-35bed1b25dd3'),(27,3,31,NULL,22,1,'2023-05-06 13:30:08','2023-05-06 13:30:08','5143a830-161b-47dc-b1b5-8b72f0d852a9'),(29,3,33,NULL,22,1,'2023-05-06 13:30:19','2023-05-06 13:30:19','934c260b-d5d6-4c6d-977d-fe00e418f19d'),(30,3,34,NULL,35,1,'2023-05-07 07:02:50','2023-05-07 07:02:50','80d3b73a-6908-4f93-a0a3-fc4d794511ac'),(31,3,36,NULL,35,1,'2023-05-07 07:02:59','2023-05-07 07:02:59','5f698348-e90a-4a78-b3c9-ee735097df1a'),(34,3,34,NULL,37,2,'2023-05-07 07:05:49','2023-05-07 07:05:49','f9b84374-17d8-4eec-827a-7c28800c54d1'),(35,3,39,NULL,35,1,'2023-05-07 07:05:49','2023-05-07 07:05:49','07871c07-0860-4c45-8437-819853488ec2'),(36,3,39,NULL,37,2,'2023-05-07 07:05:49','2023-05-07 07:05:49','6b8656b9-5672-4277-8031-be89fec6b935'),(37,2,40,NULL,11,1,'2023-05-29 10:11:01','2023-05-29 10:11:01','ace1f4d1-24c3-4842-bb7b-df43aad9e890'),(38,2,40,NULL,10,2,'2023-05-29 10:11:01','2023-05-29 10:11:01','63263327-44cb-4bf3-8822-fccc4c5f99e6'),(39,2,40,NULL,12,3,'2023-05-29 10:11:01','2023-05-29 10:11:01','ed67303a-d2cb-4399-a581-6a886733789b'),(40,2,41,NULL,11,1,'2023-05-29 10:11:01','2023-05-29 10:11:01','6bcdfa6d-71bf-4e30-a39b-8c01eb40dfce'),(41,2,41,NULL,10,2,'2023-05-29 10:11:01','2023-05-29 10:11:01','3f45c9b5-aef3-4c01-a823-1c3e07545310'),(42,2,41,NULL,12,3,'2023-05-29 10:11:01','2023-05-29 10:11:01','7d5e6526-e063-46a1-a23b-725a016db1b9'),(43,2,42,NULL,11,1,'2023-05-29 10:11:01','2023-05-29 10:11:01','f37b979a-75cf-4703-9fcb-7bd42bc2ee66'),(44,2,42,NULL,10,2,'2023-05-29 10:11:01','2023-05-29 10:11:01','509ddd5b-6f28-4777-bd8d-9635131d9a0f'),(45,2,42,NULL,12,3,'2023-05-29 10:11:01','2023-05-29 10:11:01','d07ce12a-3a52-4fd1-b726-1a2e1a54c9aa'),(46,2,43,NULL,11,1,'2023-05-29 10:11:01','2023-05-29 10:11:01','0786a9ab-8391-47c7-8aaa-614090b1c4e5'),(47,2,43,NULL,10,2,'2023-05-29 10:11:01','2023-05-29 10:11:01','7ce4146d-2277-44ec-be71-fa8eb3ae9b87'),(48,2,43,NULL,12,3,'2023-05-29 10:11:01','2023-05-29 10:11:01','4f7c4333-8f58-4699-b870-b502448ad32b'),(54,7,34,NULL,44,1,'2023-05-29 14:26:07','2023-05-29 14:26:07','01e9d4e1-29fe-4763-80ca-e8d68cff6d19'),(55,7,47,NULL,44,1,'2023-05-29 14:26:07','2023-05-29 14:26:07','18167767-b1c1-4c52-ada6-5adfe9466a46'),(56,3,47,NULL,35,1,'2023-05-29 14:26:07','2023-05-29 14:26:07','1e0762c0-ddd9-4f6f-ab70-472e9f1ed5ad'),(57,3,47,NULL,37,2,'2023-05-29 14:26:07','2023-05-29 14:26:07','e48f965d-087d-4624-8b45-bda84e342b58'),(60,7,24,NULL,48,1,'2023-05-29 15:41:24','2023-05-29 15:41:24','57f66d34-8deb-4ae2-81f8-5a510e51534c'),(61,7,50,NULL,48,1,'2023-05-29 15:41:24','2023-05-29 15:41:24','8aa9bbef-c440-4b84-a69e-0830d0fc6faa'),(62,3,50,NULL,25,1,'2023-05-29 15:41:24','2023-05-29 15:41:24','adb45a4c-e9b6-452a-a912-af30dd1ff3ae'),(64,7,21,NULL,48,1,'2023-05-29 15:42:07','2023-05-29 15:42:07','a8b0c04d-99d7-44d5-914e-d6fe5ade2297'),(65,7,51,NULL,48,1,'2023-05-29 15:42:07','2023-05-29 15:42:07','b701d771-dfde-4ff9-ae23-7e0d7346b442'),(66,3,51,NULL,22,1,'2023-05-29 15:42:07','2023-05-29 15:42:07','ca0e7bde-5923-4af2-9b13-86e51275d81e'),(68,8,52,NULL,57,1,'2023-05-30 03:21:31','2023-05-30 03:21:31','00c3e179-3d2f-40b1-8ab4-ce726cc78603'),(69,8,58,NULL,57,1,'2023-05-30 03:21:31','2023-05-30 03:21:31','e7c6a6b1-8079-4c61-be2e-4d7d7df1591f'),(70,8,59,NULL,57,1,'2023-05-30 03:21:43','2023-05-30 03:21:43','d74a4d71-672f-45eb-89c2-31b181c97710'),(71,8,60,NULL,57,1,'2023-05-30 03:22:19','2023-05-30 03:22:19','16542f63-8491-4eb7-904a-29e5e006967b'),(72,8,61,NULL,57,1,'2023-05-30 03:23:18','2023-05-30 03:23:18','a4fb628b-5cfb-4d76-bfdf-bea69af659a2'),(75,8,63,NULL,57,1,'2023-05-30 03:24:52','2023-05-30 03:24:52','f62f4313-7ba6-4fcc-bbbd-a0dc63692f5d'),(76,8,68,NULL,57,1,'2023-05-30 03:24:52','2023-05-30 03:24:52','e2e23898-cc98-439c-acaf-404e9c4c3008'),(77,8,69,NULL,57,1,'2023-05-30 03:25:06','2023-05-30 03:25:06','f2b0f0a1-5ae0-4d39-93f5-3c4c569b89c6');
/*!40000 ALTER TABLE `relations` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `revisions` VALUES (1,2,1,1,NULL),(2,2,1,2,NULL),(3,2,1,3,NULL),(4,2,1,4,'Applied “Draft 1”'),(5,2,1,5,NULL),(6,2,1,6,'Applied “Draft 1”'),(7,2,1,7,'Applied “Draft 1”'),(8,18,1,1,''),(9,21,1,1,''),(10,24,1,1,''),(11,21,1,2,''),(12,21,1,3,'Applied “Draft 1”'),(13,21,1,4,'Applied “Draft 1”'),(14,21,1,5,'Applied “Draft 1”'),(15,34,1,1,''),(16,34,1,2,'Applied “Draft 1”'),(17,2,1,8,NULL),(18,2,1,9,NULL),(19,2,1,10,NULL),(20,2,1,11,NULL),(21,34,1,3,'Applied “Draft 1”'),(22,24,1,2,'Applied “Draft 1”'),(23,21,1,6,'Applied “Draft 1”'),(24,52,1,1,NULL),(25,52,1,2,NULL),(26,52,1,3,NULL),(27,52,1,4,'Applied “Draft 1”'),(28,52,1,5,''),(29,52,1,6,NULL),(30,52,1,7,NULL),(31,63,1,1,NULL),(32,63,1,2,NULL),(33,63,1,3,NULL),(34,63,1,4,'Applied “Draft 1”'),(35,63,1,5,'');
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `searchindex`
--

LOCK TABLES `searchindex` WRITE;
/*!40000 ALTER TABLE `searchindex` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `searchindex` VALUES (1,'email',0,1,' auzadventure gmail com '),(1,'fullname',0,1,''),(1,'lastname',0,1,''),(1,'firstname',0,1,''),(1,'username',0,1,' admin '),(16,'title',0,1,' home '),(2,'slug',0,1,' home '),(2,'title',0,1,' home '),(1,'slug',0,1,''),(16,'slug',0,1,' home '),(10,'filename',0,1,' hero bg 1 jpg '),(10,'extension',0,1,' jpg '),(10,'kind',0,1,' image '),(10,'slug',0,1,''),(10,'title',0,1,' hero bg 1 '),(11,'filename',0,1,' hero bg 2 jpg '),(11,'extension',0,1,' jpg '),(11,'kind',0,1,' image '),(11,'slug',0,1,''),(11,'title',0,1,' hero bg 2 '),(12,'filename',0,1,' hero bg 3 jpg '),(12,'extension',0,1,' jpg '),(12,'kind',0,1,' image '),(12,'slug',0,1,''),(12,'title',0,1,' hero bg 3 '),(17,'slug',0,1,' temp nkpihxyucbkodtamyxjgtopoidwigvgvymsx '),(17,'title',0,1,''),(18,'slug',0,1,' property1 '),(18,'title',0,1,' property1 '),(20,'slug',0,1,' property1 '),(20,'title',0,1,' property1 '),(21,'slug',0,1,' 1 california usa '),(22,'filename',0,1,' img 1 jpg '),(21,'title',0,1,' 1600 william street '),(22,'extension',0,1,' jpg '),(22,'kind',0,1,' image '),(22,'slug',0,1,''),(22,'title',0,1,' img 1 '),(24,'title',0,1,' 501 knights run '),(24,'slug',0,1,' 501 knights run '),(25,'kind',0,1,' image '),(25,'extension',0,1,' webp '),(25,'filename',0,1,' u8142581 1 0 webp '),(25,'slug',0,1,''),(25,'title',0,1,' 501knights 1 '),(34,'slug',0,1,' the jardine residences '),(34,'title',0,1,' the jardine residences '),(44,'slug',0,1,' landed '),(44,'title',0,1,' landed '),(35,'title',0,1,' jardin house 1 '),(35,'slug',0,1,''),(35,'filename',0,1,' jardin house 1 jpg '),(35,'extension',0,1,' jpg '),(35,'kind',0,1,' image '),(37,'filename',0,1,' 2 png '),(37,'extension',0,1,' png '),(37,'kind',0,1,' image '),(37,'slug',0,1,''),(37,'title',0,1,' 2 '),(48,'slug',0,1,' condo '),(48,'title',0,1,' condo '),(62,'title',0,1,' about '),(52,'title',0,1,' about '),(52,'slug',0,1,' about '),(57,'filename',0,1,' real estate profile webp '),(57,'extension',0,1,' webp '),(57,'kind',0,1,' image '),(57,'alt',0,1,''),(57,'slug',0,1,''),(57,'title',0,1,' real estate profile '),(62,'slug',0,1,' about '),(63,'slug',0,1,' about '),(63,'title',0,1,' about ');
/*!40000 ALTER TABLE `searchindex` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sections`
--

LOCK TABLES `sections` WRITE;
/*!40000 ALTER TABLE `sections` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `sections` VALUES (1,NULL,'Home','home','single',1,'all','end',NULL,'2023-05-01 15:38:56','2023-05-01 15:38:56',NULL,'f308ed4b-53b7-4442-8b5e-53b14988a4eb'),(2,1,'property','property','structure',1,'all','end',NULL,'2023-05-05 16:28:33','2023-05-06 13:28:39',NULL,'f4222736-b675-492e-bddc-9eba68ec2eca'),(3,NULL,'About','about','single',1,'all','end',NULL,'2023-05-30 03:19:50','2023-05-30 03:20:20','2023-05-30 03:24:00','09698018-2535-4cb1-9886-664588859227'),(4,NULL,'About','about','single',1,'all','end',NULL,'2023-05-30 03:24:20','2023-05-30 03:24:20',NULL,'08167144-d72f-4247-a8c1-4d6efa693bb9');
/*!40000 ALTER TABLE `sections` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sections_sites`
--

LOCK TABLES `sections_sites` WRITE;
/*!40000 ALTER TABLE `sections_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `sections_sites` VALUES (1,1,1,1,'__home__','_index',1,'2023-05-01 15:38:56','2023-05-01 15:38:56','0ac77080-d2d1-42a7-9e71-c17fce2b2b52'),(2,2,1,1,'property/{slug}','property/_entry',1,'2023-05-05 16:28:33','2023-05-05 16:28:33','1b954af5-5eaa-431d-875c-aa85891ee448'),(3,3,1,0,NULL,NULL,1,'2023-05-30 03:19:50','2023-05-30 03:20:20','9cab0db0-e7d2-46dd-89b5-e616f34f89e0'),(4,4,1,1,'about','about.twig',1,'2023-05-30 03:24:20','2023-05-30 03:24:20','023f8ee4-add1-4ce4-a06b-535b3a58f7ce');
/*!40000 ALTER TABLE `sections_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sequences`
--

LOCK TABLES `sequences` WRITE;
/*!40000 ALTER TABLE `sequences` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `sequences` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `shunnedmessages`
--

LOCK TABLES `shunnedmessages` WRITE;
/*!40000 ALTER TABLE `shunnedmessages` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `shunnedmessages` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sitegroups`
--

LOCK TABLES `sitegroups` WRITE;
/*!40000 ALTER TABLE `sitegroups` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `sitegroups` VALUES (1,'WV Craft Demo','2023-05-01 08:06:42','2023-05-01 08:06:42',NULL,'cf3c3607-490b-445f-baab-1d99ba9bb49c');
/*!40000 ALTER TABLE `sitegroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sites`
--

LOCK TABLES `sites` WRITE;
/*!40000 ALTER TABLE `sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `sites` VALUES (1,1,1,'1','WV Craft Demo','default','en-US',1,'$PRIMARY_SITE_URL',1,'2023-05-01 08:06:42','2023-05-29 10:11:02',NULL,'1874dee1-77b1-41b0-a203-23ef8669eb55');
/*!40000 ALTER TABLE `sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `structureelements`
--

LOCK TABLES `structureelements` WRITE;
/*!40000 ALTER TABLE `structureelements` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `structureelements` VALUES (1,1,NULL,1,1,8,0,'2023-05-06 13:28:39','2023-05-07 07:02:11','58f58e33-cd6f-489f-90f8-3f889ace91a0'),(2,1,21,1,4,5,1,'2023-05-06 13:28:39','2023-05-06 13:29:16','68d3d755-f93f-4a3c-966e-92f1112ff54c'),(3,1,24,1,2,3,1,'2023-05-06 13:28:39','2023-05-06 13:29:16','d9fdd4b0-eb24-4f19-bdd5-c719c6ec944c'),(4,1,34,1,6,7,1,'2023-05-07 07:02:11','2023-05-07 07:02:11','39fee8e5-7827-4ca7-92c0-12f4993effac'),(5,2,NULL,5,1,6,0,'2023-05-29 14:01:39','2023-05-29 15:41:01','45a0baeb-3a4e-48b9-8f18-92cec1a8df11'),(6,2,44,5,4,5,1,'2023-05-29 14:01:39','2023-05-29 15:41:01','0a8582f7-d8ad-4522-b461-d038a3ab5a03'),(7,2,48,5,2,3,1,'2023-05-29 15:41:01','2023-05-29 15:41:01','37a1858b-fc02-4d64-bdea-2298ea7d0209');
/*!40000 ALTER TABLE `structureelements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `structures`
--

LOCK TABLES `structures` WRITE;
/*!40000 ALTER TABLE `structures` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `structures` VALUES (1,1,'2023-05-06 13:28:39','2023-05-06 13:28:39',NULL,'3fb6e08f-25dc-4a7f-b1fd-242fd0c53b25'),(2,1,'2023-05-29 13:59:09','2023-05-29 13:59:09',NULL,'4b84aca1-5c3b-4db3-afa6-a124f936d98b');
/*!40000 ALTER TABLE `structures` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `systemmessages`
--

LOCK TABLES `systemmessages` WRITE;
/*!40000 ALTER TABLE `systemmessages` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `systemmessages` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `taggroups`
--

LOCK TABLES `taggroups` WRITE;
/*!40000 ALTER TABLE `taggroups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `taggroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `tokens`
--

LOCK TABLES `tokens` WRITE;
/*!40000 ALTER TABLE `tokens` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `tokens` VALUES (7,'JTofC9HzROzJ4CC4NdQkehtvYazd1AqH','[\"preview\\/preview\",{\"elementType\":\"craft\\\\elements\\\\Entry\",\"canonicalId\":2,\"siteId\":1,\"draftId\":null,\"revisionId\":null,\"userId\":1}]',NULL,NULL,'2023-05-31 03:28:37','2023-05-30 03:28:37','2023-05-30 03:28:37','7de7d3ca-8920-47f9-99a1-3fbf6334f865');
/*!40000 ALTER TABLE `tokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `usergroups`
--

LOCK TABLES `usergroups` WRITE;
/*!40000 ALTER TABLE `usergroups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `usergroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `usergroups_users`
--

LOCK TABLES `usergroups_users` WRITE;
/*!40000 ALTER TABLE `usergroups_users` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `usergroups_users` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `userpermissions`
--

LOCK TABLES `userpermissions` WRITE;
/*!40000 ALTER TABLE `userpermissions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `userpermissions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `userpermissions_usergroups`
--

LOCK TABLES `userpermissions_usergroups` WRITE;
/*!40000 ALTER TABLE `userpermissions_usergroups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `userpermissions_usergroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `userpermissions_users`
--

LOCK TABLES `userpermissions_users` WRITE;
/*!40000 ALTER TABLE `userpermissions_users` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `userpermissions_users` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `userpreferences`
--

LOCK TABLES `userpreferences` WRITE;
/*!40000 ALTER TABLE `userpreferences` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `userpreferences` VALUES (1,'{\"language\":\"en-US\"}');
/*!40000 ALTER TABLE `userpreferences` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `users` VALUES (1,'admin',NULL,NULL,NULL,NULL,'auzadventure@gmail.com','$2y$13$9pcq076utg17yx1F/CbBxuQKMVrfkvca2CfUQelHnSCU2K7UgAMFq',1,1,0,0,0,'2023-05-30 03:17:25',NULL,NULL,NULL,'2023-05-29 13:56:28',NULL,1,NULL,NULL,NULL,0,'2023-05-04 15:24:43','2023-05-01 08:06:43','2023-05-30 03:17:25');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `volumefolders`
--

LOCK TABLES `volumefolders` WRITE;
/*!40000 ALTER TABLE `volumefolders` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `volumefolders` VALUES (1,NULL,1,'site images',NULL,'2023-05-05 15:30:42','2023-05-29 10:11:01','ff10f4e5-8c32-47ca-b4b8-aca060dab021'),(2,NULL,NULL,'Temporary source',NULL,'2023-05-05 15:33:08','2023-05-05 15:33:08','17ff2b79-ffba-4ccf-b6f0-0ec85b69881c'),(3,2,NULL,'user_1','user_1/','2023-05-05 15:33:08','2023-05-05 15:33:08','4cdc04a6-10a8-48c4-aea7-334ddfb35830'),(4,1,1,'home','home/','2023-05-05 15:34:21','2023-05-05 15:34:21','82736880-27a9-4187-8d09-368837322a56'),(5,4,1,'hero','home/hero/','2023-05-05 15:34:21','2023-05-05 15:34:21','c6d68897-36da-4c8c-b5e1-606c719948cf'),(6,1,1,'property','property/','2023-05-05 16:35:51','2023-05-05 16:35:51','97cd9a21-6b9b-4877-8204-70f55624a39e'),(7,6,1,'slug','property/slug/','2023-05-05 16:35:51','2023-05-05 16:35:51','37913a35-3ce6-4f0b-a114-f1f92b4eee77'),(8,1,1,'about','about/','2023-05-30 03:21:13','2023-05-30 03:21:13','1f38818d-9aa7-48e5-8cfd-52c920232c2e');
/*!40000 ALTER TABLE `volumefolders` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `volumes` VALUES (1,2,'site images','siteImages','siteImages',NULL,NULL,'site',NULL,1,'2023-05-05 15:30:42','2023-05-05 15:30:42',NULL,'79a24291-0544-4c50-913c-9dda4ee5656e');
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `widgets` VALUES (1,1,'craft\\widgets\\RecentEntries',1,NULL,'{\"siteId\":1,\"section\":\"*\",\"limit\":10}',1,'2023-05-01 15:34:01','2023-05-01 15:34:01','26e06f14-f3eb-4958-88c9-54989d9d8b07'),(2,1,'craft\\widgets\\CraftSupport',2,NULL,'[]',1,'2023-05-01 15:34:01','2023-05-01 15:34:01','84faddf9-c615-4b3f-a4ba-5941dfa9123f'),(3,1,'craft\\widgets\\Updates',3,NULL,'[]',1,'2023-05-01 15:34:01','2023-05-01 15:34:01','a634f631-2c9c-4762-aa50-de60084708e6'),(4,1,'craft\\widgets\\Feed',4,NULL,'{\"url\":\"https:\\/\\/craftcms.com\\/news.rss\",\"title\":\"Craft News\",\"limit\":5}',1,'2023-05-01 15:34:01','2023-05-01 15:34:01','1fbb99a2-803e-4d98-a999-ae37f69a524a');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping routines for database 'addons_craft_demo'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-05-30 11:37:30
